/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.dialog;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.table.UIFramePositionPairTableBuilder;
import org.applied_geodesy.coordtrans.ui.table.UIHomologousFramePositionPairTableBuilder;
import org.applied_geodesy.coordtrans.ui.table.UIParameterTableBuilder;
import org.applied_geodesy.coordtrans.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.util.io.FileProgressChangeListener;
import org.applied_geodesy.util.io.FileProgressEvent;
import org.applied_geodesy.util.io.SourceFileReader;

public class ReadFileProgressDialog<T> {
    private static Window window;
    private ReadFileTask readFileTask;
    private boolean preventClosing = false;
    private I18N i18n = I18N.getInstance();
    private Dialog<List<T>> dialog = null;
    private ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
    private Label progressLabel = new Label();
    private List<T> results;

    public Optional<List<T>> showAndWait(SourceFileReader<T> reader, List<File> selectedFiles, boolean resetReaderResult) {
        this.init();
        this.reset();
        this.process(reader, selectedFiles, resetReaderResult);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ReadFileProgressDialog.this.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)ReadFileProgressDialog.this.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return this.dialog.showAndWait();
    }

    public static void setOwner(Window owner) {
        window = owner;
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.initOwner(window);
        this.dialog.setTitle(this.i18n.getString("ReadFileProgressDialog.title", "File reader"));
        this.dialog.setHeaderText(this.i18n.getString("ReadFileProgressDialog.header", "Read source file\u2026"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        VBox vbox = new VBox();
        vbox.getChildren().addAll((Object[])new Node[]{this.createProgressPane()});
        this.dialog.getDialogPane().getScene().getWindow().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (ReadFileProgressDialog.this.preventClosing) {
                    event.consume();
                    if (ReadFileProgressDialog.this.readFileTask != null) {
                        ReadFileProgressDialog.this.readFileTask.cancelled();
                    }
                }
            }
        });
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                if (ReadFileProgressDialog.this.preventClosing) {
                    event.consume();
                    if (ReadFileProgressDialog.this.readFileTask != null) {
                        ReadFileProgressDialog.this.readFileTask.cancelled();
                    }
                }
            }
        });
        this.dialog.setResultConverter(new Callback<ButtonType, List<T>>(){

            public List<T> call(ButtonType buttonType) {
                return ReadFileProgressDialog.this.results;
            }
        });
        this.dialog.getDialogPane().setContent((Node)vbox);
    }

    private void reset() {
        this.results = null;
        this.progressIndicator.setProgress(-1.0);
        this.progressLabel.setText(null);
        this.preventClosing = false;
    }

    private Node createProgressPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMinWidth(400.0);
        gridPane.setHgap(20.0);
        gridPane.setVgap(15.0);
        gridPane.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        this.progressIndicator.setMinWidth(50.0);
        this.progressIndicator.setMinHeight(50.0);
        gridPane.add((Node)this.progressIndicator, 0, 0, 1, 2);
        gridPane.add((Node)this.progressLabel, 1, 0);
        return gridPane;
    }

    private void process(SourceFileReader<T> reader, List<File> selectedFiles, boolean resetReaderResult) {
        this.reset();
        this.readFileTask = new ReadFileTask(reader, selectedFiles, resetReaderResult);
        this.readFileTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                ReadFileProgressDialog.this.results = (List)ReadFileProgressDialog.this.readFileTask.getValue();
            }
        });
        this.readFileTask.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                ReadFileProgressDialog.this.preventClosing = false;
                ReadFileProgressDialog.this.dialog.hide();
                final Throwable throwable = ReadFileProgressDialog.this.readFileTask.getException();
                if (throwable != null) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            OptionDialog.showThrowableDialog((this).ReadFileProgressDialog.this.i18n.getString("ReadFileProgressDialog.message.error.import.exception.title", "I/O Error"), (this).ReadFileProgressDialog.this.i18n.getString("ReadFileProgressDialog.message.error.import.exception.header", "Error, could not import selected file."), (this).ReadFileProgressDialog.this.i18n.getString("ReadFileProgressDialog.message.error.import.exception.message", "An exception has occurred during file import."), throwable);
                        }
                    });
                    throwable.printStackTrace();
                }
                UITreeBuilder.getInstance().getTree().getSelectionModel().select(0);
                UIHomologousFramePositionPairTableBuilder.getInstance().getTable().refresh();
                UIFramePositionPairTableBuilder.getInstance().getTable().refresh();
                UIParameterTableBuilder.getInstance().getTable().refresh();
            }
        });
        Thread th = new Thread((Runnable)((Object)this.readFileTask));
        th.setDaemon(true);
        th.start();
    }

    private class ReadFileTask
    extends Task<List<T>>
    implements FileProgressChangeListener {
        private SourceFileReader<T> reader;
        private boolean resetReaderResult = Boolean.FALSE;
        private double processState = 0.0;
        private List<File> selectedFiles;
        private static final long DEFAULT_PARTICLE_SIZE = 65536L;
        private long totalBytes = 0L;
        private long readedBytes = 0L;
        private long particleSize = 65536L;
        private int cnt = 1;

        public ReadFileTask(SourceFileReader<T> reader, List<File> selectedFiles, boolean resetReaderResult) {
            this.reader = reader;
            this.selectedFiles = selectedFiles;
            this.resetReaderResult = resetReaderResult;
        }

        protected List<T> call() throws Exception {
            try {
                ReadFileProgressDialog.this.preventClosing = true;
                this.updateProgress(-1.0, -1.0);
                this.updateProgressMessage(ReadFileProgressDialog.this.i18n.getString("ReadFileProgressDialog.pleasewait.label", "Please wait\u2026"));
                this.reader.addFileProgressChangeListener(this);
                if (this.isCancelled()) {
                    return null;
                }
                this.processState = 0.0;
                this.updateProgress(this.processState, 1.0);
                for (File file : this.selectedFiles) {
                    this.totalBytes += Files.size(file.toPath());
                }
                this.particleSize = 65536L;
                this.cnt = 1;
                int ratio = (int)Math.ceil(this.totalBytes / this.particleSize);
                if (ratio < 15) {
                    ratio = 15;
                }
                if (ratio > 30) {
                    ratio = 30;
                }
                this.particleSize = this.totalBytes / (long)ratio;
                this.reader.reset();
                ArrayList results = new ArrayList(this.resetReaderResult ? this.selectedFiles.size() : 1);
                int i = 0;
                while (i < this.selectedFiles.size()) {
                    File file = this.selectedFiles.get(i);
                    this.updateProgressMessage(String.format(Locale.ENGLISH, ReadFileProgressDialog.this.i18n.getString("ReadFileProgressDialog.sourcefile.label", "File %d of %d - Please wait\u2026\r\n%s"), i + 1, this.selectedFiles.size(), file.getName()));
                    this.reader.setPath(file.toPath(), this.resetReaderResult);
                    Object result = this.reader.readAndImport();
                    if (this.resetReaderResult || i == 0) {
                        results.add(result);
                    }
                    this.updateProgressMessage(ReadFileProgressDialog.this.i18n.getString("ReadFileProgressDialog.pleasewait.label", "Please wait\u2026"));
                    this.readedBytes += Files.size(file.toPath());
                    ++i;
                }
                if (this.isCancelled()) {
                    return null;
                }
                this.updateProgress(-1.0, -1.0);
                this.updateMessage(ReadFileProgressDialog.this.i18n.getString("ReadFileProgressDialog.save.label", "Save results\u2026"));
                this.updateProgressMessage(ReadFileProgressDialog.this.i18n.getString("ReadFileProgressDialog.pleasewait.label", "Please wait\u2026"));
                ArrayList arrayList = results;
                return arrayList;
            }
            finally {
                this.destroy();
                this.updateProgressMessage(null);
                ReadFileProgressDialog.this.preventClosing = false;
            }
        }

        protected void succeeded() {
            ReadFileProgressDialog.this.preventClosing = false;
            super.succeeded();
            this.hideDialog();
        }

        protected void failed() {
            ReadFileProgressDialog.this.results = null;
            ReadFileProgressDialog.this.preventClosing = false;
            super.failed();
            this.hideDialog();
        }

        protected void cancelled() {
            ReadFileProgressDialog.this.results = null;
            super.cancelled();
            if (this.reader != null) {
                this.reader.interrupt();
            }
        }

        private void hideDialog() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!((ReadFileTask)ReadFileTask.this).ReadFileProgressDialog.this.preventClosing) {
                        ((ReadFileTask)ReadFileTask.this).ReadFileProgressDialog.this.dialog.hide();
                    }
                }
            });
        }

        private void updateProgressMessage(final String message) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((ReadFileTask)ReadFileTask.this).ReadFileProgressDialog.this.progressLabel.setText(message);
                }
            });
        }

        protected void updateProgress(final double workDone, double max) {
            super.updateProgress(workDone, max);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Node node;
                    ((ReadFileTask)ReadFileTask.this).ReadFileProgressDialog.this.progressIndicator.setProgress(workDone);
                    if (workDone >= 1.0 && (node = ((ReadFileTask)ReadFileTask.this).ReadFileProgressDialog.this.progressIndicator.lookup(".percentage")) != null && node instanceof Text) {
                        Text text = (Text)node;
                        text.setText(((ReadFileTask)ReadFileTask.this).ReadFileProgressDialog.this.i18n.getString("ReadFileProgressDialog.done.label", "Done"));
                        ((ReadFileTask)ReadFileTask.this).ReadFileProgressDialog.this.progressIndicator.setPrefWidth(text.getLayoutBounds().getWidth());
                    }
                }
            });
        }

        private void destroy() {
            if (this.reader != null) {
                this.reader.removeFileProgressChangeListener(this);
            }
            this.reader = null;
            this.selectedFiles = null;
            this.totalBytes = 0L;
            this.readedBytes = 0L;
            this.particleSize = 65536L;
            this.cnt = 1;
            ReadFileProgressDialog.this.results = null;
        }

        @Override
        public void fileProgressChanged(FileProgressEvent evt) {
            if (evt.getEventType() == FileProgressEvent.FileProgressEventType.READ_LINE) {
                long readedBytes = evt.getReadedBytes();
                if ((readedBytes += this.readedBytes) > (long)this.cnt * this.particleSize) {
                    ++this.cnt;
                    double frac = Math.min((double)readedBytes / (double)this.totalBytes, 1.0);
                    this.processState = Math.max(this.processState, frac);
                    this.updateProgress(this.processState, 1.0);
                }
            }
        }
    }
}

