/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.dialog;

import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpperSymmBandMatrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePosition;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;
import org.applied_geodesy.coordtrans.ui.dialog.FrameType;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.utils.UiUtil;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;

public class MatrixDialog {
    private I18N i18n = I18N.getInstance();
    private static MatrixDialog matrixDialog = new MatrixDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private DoubleTextField[][] matrixElementsSourceSystem;
    private DoubleTextField[][] matrixElementsTargetSystem;
    private TitledPane sourceDispersionTitledPane;
    private TitledPane targetDispersionTitledPane;
    private Accordion accordion = null;
    private DispersionablePosition currentSourcePosition;
    private DispersionablePosition currentTargetPosition;
    private ToggleGroup matrixTypeSourceSystemToggleGroup;
    private ToggleGroup matrixTypeTargetSystemToggleGroup;
    private MatrixType matrixTypeSourceSystem = null;
    private MatrixType matrixTypeTargetSystem = null;
    private TableView.TableViewSelectionModel<? extends PositionPair<?, ?>> tableViewSelectionModel;
    private Button previousButton = null;
    private Button nextButton = null;

    private MatrixDialog() {
    }

    public static void setOwner(Window owner) {
        MatrixDialog.matrixDialog.window = owner;
    }

    public static Optional<Void> showAndWait(TableView.TableViewSelectionModel<? extends PositionPair<?, ?>> tableViewSelectionModel) {
        MatrixDialog.matrixDialog.tableViewSelectionModel = tableViewSelectionModel;
        matrixDialog.init();
        matrixDialog.setSelectedPositionPair();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MatrixDialog.matrixDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)MatrixDialog.matrixDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return MatrixDialog.matrixDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("MatrixDialog.title", "Dispersion matrix"));
        this.dialog.setHeaderText(String.format(Locale.ENGLISH, this.i18n.getString("MatrixDialog.header", "Dispersion of point %s"), ""));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.PREVIOUS, ButtonType.NEXT, ButtonType.OK, ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        Node closeButton = this.dialog.getDialogPane().lookupButton(ButtonType.CLOSE);
        closeButton.managedProperty().bind((ObservableValue)closeButton.visibleProperty());
        closeButton.setVisible(false);
        this.previousButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.PREVIOUS);
        this.previousButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                event.consume();
                MatrixDialog.this.changePositionPair(false);
            }
        });
        this.nextButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.NEXT);
        this.nextButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                event.consume();
                MatrixDialog.this.changePositionPair(true);
            }
        });
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Void>(){

            public Void call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    MatrixDialog.this.setMatrix(MatrixDialog.this.currentSourcePosition, FrameType.SOURCE);
                    MatrixDialog.this.setMatrix(MatrixDialog.this.currentTargetPosition, FrameType.TARGET);
                }
                return null;
            }
        });
    }

    private void setSelectedPositionPair() {
        int numberOfPointPairs = this.tableViewSelectionModel.getTableView().getItems().size();
        if (numberOfPointPairs <= 0) {
            return;
        }
        PositionPair positionPair = (PositionPair)this.tableViewSelectionModel.getSelectedItem();
        if (positionPair == null) {
            this.tableViewSelectionModel.clearAndSelect(0);
            positionPair = (PositionPair)this.tableViewSelectionModel.getSelectedItem();
        }
        if (positionPair != null) {
            int index = this.tableViewSelectionModel.getSelectedIndex();
            this.tableViewSelectionModel.clearAndSelect(index);
            DispersionablePosition sourcePosition = positionPair.getSourceSystemPosition() instanceof DispersionablePosition ? (DispersionablePosition)positionPair.getSourceSystemPosition() : null;
            DispersionablePosition targetPosition = positionPair.getTargetSystemPosition() instanceof DispersionablePosition ? (DispersionablePosition)positionPair.getTargetSystemPosition() : null;
            this.setName(positionPair.getName());
            this.setDispersionablePositions(sourcePosition, targetPosition);
            this.previousButton.setDisable(index <= 0);
            this.nextButton.setDisable(index + 1 >= numberOfPointPairs);
        }
    }

    private void changePositionPair(boolean next) {
        this.setMatrix(this.currentSourcePosition, FrameType.SOURCE);
        this.setMatrix(this.currentTargetPosition, FrameType.TARGET);
        if (next) {
            this.tableViewSelectionModel.selectNext();
        } else {
            this.tableViewSelectionModel.selectPrevious();
        }
        this.setSelectedPositionPair();
    }

    private void setDispersionablePositions(DispersionablePosition sourcePosition, DispersionablePosition targetPosition) {
        try {
            this.currentSourcePosition = sourcePosition;
            this.currentTargetPosition = targetPosition;
            this.sourceDispersionTitledPane.setAnimated(false);
            this.targetDispersionTitledPane.setAnimated(false);
            if (targetPosition == null || this.accordion.getExpandedPane() == null) {
                this.targetDispersionTitledPane.setExpanded(targetPosition != null);
                this.accordion.setExpandedPane(this.sourceDispersionTitledPane);
            } else if (sourcePosition == null || this.accordion.getExpandedPane() == null) {
                this.sourceDispersionTitledPane.setExpanded(sourcePosition != null);
                this.accordion.setExpandedPane(this.targetDispersionTitledPane);
            }
            this.sourceDispersionTitledPane.setCollapsible(sourcePosition != null && targetPosition != null);
            this.targetDispersionTitledPane.setCollapsible(targetPosition != null && sourcePosition != null);
            this.sourceDispersionTitledPane.setVisible(sourcePosition != null);
            this.targetDispersionTitledPane.setVisible(targetPosition != null);
            this.setDispersionablePosition(this.currentSourcePosition, FrameType.SOURCE);
            this.setDispersionablePosition(this.currentTargetPosition, FrameType.TARGET);
        }
        finally {
            this.sourceDispersionTitledPane.setAnimated(true);
            this.targetDispersionTitledPane.setAnimated(true);
        }
    }

    private void setName(String name) {
        this.dialog.setHeaderText(String.format(Locale.ENGLISH, this.i18n.getString("MatrixDialog.header", "Dispersion of point %s"), name));
    }

    private void setDispersionablePosition(DispersionablePosition position, FrameType frameType) {
        if (position == null) {
            return;
        }
        Matrix matrix = position.getDispersionApriori();
        MatrixType matrixType = null;
        DoubleTextField[][] matrixElements = null;
        ToggleGroup matrixTypeToggleGroup = null;
        matrixType = matrix instanceof UpperSymmPackMatrix ? MatrixType.DENSE : (matrix instanceof UpperSymmBandMatrix ? MatrixType.DIAGONAL : MatrixType.IDENTITY);
        if (frameType == FrameType.SOURCE) {
            this.matrixTypeSourceSystem = matrixType;
            matrixElements = this.matrixElementsSourceSystem;
            matrixTypeToggleGroup = this.matrixTypeSourceSystemToggleGroup;
        } else {
            this.matrixTypeTargetSystem = matrixType;
            matrixElements = this.matrixElementsTargetSystem;
            matrixTypeToggleGroup = this.matrixTypeTargetSystemToggleGroup;
        }
        for (Toggle toggle : matrixTypeToggleGroup.getToggles()) {
            if (toggle.getUserData() != matrixType) continue;
            toggle.setSelected(true);
            break;
        }
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (i < matrix.numRows() && j < matrix.numColumns()) {
                    matrixElements[i][j].setVisible(true);
                    matrixElements[i][j].setManaged(true);
                    if (i <= j) {
                        matrixElements[i][j].setValue(matrix.get(i, j));
                    }
                    if (matrixType == MatrixType.IDENTITY) {
                        matrixElements[i][j].setDisable(true);
                    } else if (matrixType == MatrixType.DIAGONAL) {
                        matrixElements[i][j].setDisable(i != j);
                    } else {
                        matrixElements[i][j].setDisable(i > j);
                    }
                } else {
                    matrixElements[i][j].setVisible(false);
                    matrixElements[i][j].setManaged(false);
                }
                ++j;
            }
            ++i;
        }
    }

    private Node createPane() {
        this.sourceDispersionTitledPane = UiUtil.createTitledPane(this.i18n.getString("MatrixDialog.matrix.frame.source.title", "Source System"), this.i18n.getString("MatrixDialog.matrix.frame.source.tooltip", "Define source system dispersion matrix of point"), this.createMatrixPane(FrameType.SOURCE));
        this.targetDispersionTitledPane = UiUtil.createTitledPane(this.i18n.getString("MatrixDialog.matrix.frame.target.title", "Target System"), this.i18n.getString("MatrixDialog.matrix.frame.target.tooltip", "Define target system dispersion matrix of point"), this.createMatrixPane(FrameType.TARGET));
        this.accordion = new Accordion();
        this.accordion.getPanes().addAll((Object[])new TitledPane[]{this.sourceDispersionTitledPane, this.targetDispersionTitledPane});
        this.accordion.expandedPaneProperty().addListener((ChangeListener)new ExpandedPaneChangeListener());
        return this.accordion;
    }

    private Node createMatrixPane(FrameType frameType) {
        GridPane gridPane = UiUtil.createGridPane();
        ToggleGroup matrixTypeToggleGroup = new ToggleGroup();
        RadioButton identityRadioButton = UiUtil.createRadioButton(this.i18n.getString("MatrixDialog.matrix.type.identity.label", "Identiy matrix"), this.i18n.getString("MatrixDialog.matrix.type.identity.tooltip", "If selected, the matrix type is set to the identity type"), matrixTypeToggleGroup);
        RadioButton diagonalRadioButton = UiUtil.createRadioButton(this.i18n.getString("MatrixDialog.matrix.type.diagonal.label", "Diagonal matrix"), this.i18n.getString("MatrixDialog.matrix.type.diagonal.tooltip", "If selected, the matrix type is set to the diagonal type"), matrixTypeToggleGroup);
        RadioButton denseRadioButton = UiUtil.createRadioButton(this.i18n.getString("MatrixDialog.matrix.type.dense.label", "Dense matrix"), this.i18n.getString("MatrixDialog.matrix.type.dense.tooltip", "If selected, the matrix type is set to the symmetric dense type"), matrixTypeToggleGroup);
        identityRadioButton.setUserData((Object)MatrixType.IDENTITY);
        diagonalRadioButton.setUserData((Object)MatrixType.DIAGONAL);
        denseRadioButton.setUserData((Object)MatrixType.DENSE);
        Region spacer = new Region();
        VBox buttonBox = new VBox(7.0);
        VBox.setVgrow((Node)identityRadioButton, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)diagonalRadioButton, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)denseRadioButton, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        buttonBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        buttonBox.getChildren().addAll((Object[])new Node[]{identityRadioButton, diagonalRadioButton, denseRadioButton, spacer});
        Insets insetsField = new Insets(5.0, 5.0, 5.0, 5.0);
        DoubleTextField[][] matrixElements = new DoubleTextField[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                matrixElements[i][j] = UiUtil.createDoubleTextField(CellValueType.DOUBLE, 0.0, this.i18n.getString("MatrixDialog.matrix.element.tooltip", "Element"));
                if (i > j) {
                    matrixElements[i][j].numberProperty().bind(matrixElements[j][i].numberProperty());
                }
                GridPane.setMargin((Node)matrixElements[i][j], (Insets)insetsField);
                gridPane.add((Node)matrixElements[i][j], j, i);
                ++j;
            }
            ++i;
        }
        matrixTypeToggleGroup.selectedToggleProperty().addListener((ChangeListener)new MatrixTypeChangeListener(frameType));
        if (frameType == FrameType.SOURCE) {
            this.matrixElementsSourceSystem = matrixElements;
            this.matrixTypeSourceSystemToggleGroup = matrixTypeToggleGroup;
        } else {
            this.matrixElementsTargetSystem = matrixElements;
            this.matrixTypeTargetSystemToggleGroup = matrixTypeToggleGroup;
        }
        GridPane.setMargin((Node)buttonBox, (Insets)new Insets(5.0, 5.0, 5.0, 10.0));
        gridPane.add((Node)buttonBox, 4, 0, 1, 3);
        return gridPane;
    }

    private void changeMatrixType(MatrixType matrixType, FrameType frameType) {
        DoubleTextField[][] matrixElements = null;
        if (frameType == FrameType.SOURCE) {
            this.matrixTypeSourceSystem = matrixType;
            matrixElements = this.matrixElementsSourceSystem;
        } else {
            this.matrixTypeTargetSystem = matrixType;
            matrixElements = this.matrixElementsTargetSystem;
        }
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (matrixType == MatrixType.IDENTITY) {
                    matrixElements[i][j].setDisable(true);
                    if (i == j) {
                        matrixElements[i][j].setValue(1.0);
                    } else if (i < j) {
                        matrixElements[i][j].setValue(0.0);
                    }
                } else if (matrixType == MatrixType.DIAGONAL) {
                    matrixElements[i][j].setDisable(i != j);
                    if (i < j) {
                        matrixElements[i][j].setValue(0.0);
                    }
                } else {
                    matrixElements[i][j].setDisable(i > j);
                }
                ++j;
            }
            ++i;
        }
    }

    private void setMatrix(DispersionablePosition position, FrameType frameType) {
        if (position == null) {
            return;
        }
        int dimension = position.getDimension();
        MatrixType matrixType = null;
        Matrix matrix = null;
        DoubleTextField[][] matrixElements = null;
        if (frameType == FrameType.SOURCE) {
            matrixType = this.matrixTypeSourceSystem;
            matrixElements = this.matrixElementsSourceSystem;
        } else {
            matrixType = this.matrixTypeTargetSystem;
            matrixElements = this.matrixElementsTargetSystem;
        }
        if (matrixType == MatrixType.DENSE) {
            boolean diagonalMatrixType = true;
            int row = 0;
            while (row < dimension) {
                int column = row + 1;
                while (column < dimension) {
                    if (matrixElements[row][column].getNumber() != 0.0) {
                        diagonalMatrixType = false;
                        break;
                    }
                    ++column;
                }
                ++row;
            }
            if (diagonalMatrixType) {
                matrixType = MatrixType.DIAGONAL;
            }
        }
        if (matrixType == MatrixType.DIAGONAL) {
            boolean identityMatrixType = true;
            int idx = 0;
            while (idx < dimension) {
                if (matrixElements[idx][idx].getNumber() != 1.0) {
                    identityMatrixType = false;
                    break;
                }
                ++idx;
            }
            if (identityMatrixType) {
                matrixType = MatrixType.IDENTITY;
            }
        }
        switch (matrixType) {
            case DENSE: {
                matrix = new UpperSymmPackMatrix(dimension);
                break;
            }
            case DIAGONAL: {
                matrix = new UpperSymmBandMatrix(dimension, 0);
                break;
            }
            case IDENTITY: {
                matrix = MathExtension.identity(dimension);
            }
        }
        if (matrix == null) {
            return;
        }
        if (matrixType != MatrixType.IDENTITY) {
            for (MatrixEntry entry : matrix) {
                double value = matrixElements[entry.row()][entry.column()].getNumber();
                entry.set(value);
            }
        }
        try {
            position.setDispersionApriori(matrix);
        }
        catch (IllegalArgumentException e) {
            OptionDialog.showThrowableDialog(this.i18n.getString("MatrixDialog.message.error.failed.exception.title", "Invalid Dispersion Matrix"), this.i18n.getString("MatrixDialog.message.error.failed.exception.header", "Error, could not save dispersion matrix."), this.i18n.getString("MatrixDialog.message.error.failed.exception.message", "An exception has occurred when saving dispersion matrix."), e);
            throw e;
        }
    }

    private class ExpandedPaneChangeListener
    implements ChangeListener<TitledPane> {
        private ExpandedPaneChangeListener() {
        }

        public void changed(ObservableValue<? extends TitledPane> abservable, TitledPane oldValue, TitledPane newValue) {
            if (!MatrixDialog.this.sourceDispersionTitledPane.isExpanded() && !MatrixDialog.this.targetDispersionTitledPane.isExpanded()) {
                if (oldValue == MatrixDialog.this.sourceDispersionTitledPane) {
                    MatrixDialog.this.targetDispersionTitledPane.setExpanded(true);
                    MatrixDialog.this.accordion.setExpandedPane(MatrixDialog.this.targetDispersionTitledPane);
                } else if (oldValue == MatrixDialog.this.targetDispersionTitledPane) {
                    MatrixDialog.this.sourceDispersionTitledPane.setExpanded(true);
                    MatrixDialog.this.accordion.setExpandedPane(MatrixDialog.this.sourceDispersionTitledPane);
                }
            }
        }
    }

    private static enum MatrixType {
        IDENTITY,
        DIAGONAL,
        DENSE;

    }

    private class MatrixTypeChangeListener
    implements ChangeListener<Toggle> {
        private final FrameType frameType;

        MatrixTypeChangeListener(FrameType frameType) {
            this.frameType = frameType;
        }

        public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
            ToggleGroup matrixTypeToggleGroup;
            ToggleGroup toggleGroup = matrixTypeToggleGroup = this.frameType == FrameType.SOURCE ? MatrixDialog.this.matrixTypeSourceSystemToggleGroup : MatrixDialog.this.matrixTypeTargetSystemToggleGroup;
            if (matrixTypeToggleGroup.getSelectedToggle() != null && matrixTypeToggleGroup.getSelectedToggle().getUserData() != null && matrixTypeToggleGroup.getSelectedToggle().getUserData() instanceof MatrixType) {
                MatrixType matrixType = (MatrixType)((Object)matrixTypeToggleGroup.getSelectedToggle().getUserData());
                MatrixDialog.this.changeMatrixType(matrixType, this.frameType);
            }
        }
    }
}

