/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.DefaultValue;
import org.applied_geodesy.adjustment.transformation.TransformationAdjustment;
import org.applied_geodesy.adjustment.transformation.VarianceComponentType;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.utils.UiUtil;
import org.applied_geodesy.ui.spinner.DoubleSpinner;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

public class LeastSquaresSettingDialog
implements FormatterChangedListener {
    private static I18N i18N = I18N.getInstance();
    private static LeastSquaresSettingDialog leastSquaresSettingDialog = new LeastSquaresSettingDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private Spinner<Integer> iterationSpinner;
    private DoubleSpinner lmDampingSpinner;
    private CheckBox applyVarianceOfUnitWeightCheckBox;
    private CheckBox adjustModelParametersOnlyCheckBox;
    private CheckBox preconditioningCheckBox;
    private CheckBox estimateCenterOfMassCheckBox;
    private TransformationAdjustment adjustment;
    private FormatterOptions options = FormatterOptions.getInstance();

    private LeastSquaresSettingDialog() {
    }

    public static void setOwner(Window owner) {
        LeastSquaresSettingDialog.leastSquaresSettingDialog.window = owner;
    }

    public static Optional<Void> showAndWait(TransformationAdjustment adjustment) {
        leastSquaresSettingDialog.init();
        leastSquaresSettingDialog.setTransformationAdjustment(adjustment);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    LeastSquaresSettingDialog.leastSquaresSettingDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)LeastSquaresSettingDialog.leastSquaresSettingDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return LeastSquaresSettingDialog.leastSquaresSettingDialog.dialog.showAndWait();
    }

    private void setTransformationAdjustment(TransformationAdjustment adjustment) {
        this.adjustment = adjustment;
        this.applyVarianceOfUnitWeightCheckBox.setSelected(this.adjustment.getVarianceComponent(VarianceComponentType.GLOBAL).isApplyAposterioriVarianceOfUnitWeight());
        this.adjustModelParametersOnlyCheckBox.setSelected(this.adjustment.isAdjustModelParametersOnly());
        this.preconditioningCheckBox.setSelected(this.adjustment.isPreconditioning());
        this.estimateCenterOfMassCheckBox.setSelected(this.adjustment.getTransformation() != null ? this.adjustment.getTransformation().isEstimateCenterOfMasses() : false);
        double dampingValue = this.adjustment.getLevenbergMarquardtDampingValue();
        SpinnerValueFactory.DoubleSpinnerValueFactory dampingSpinnerFactory = (SpinnerValueFactory.DoubleSpinnerValueFactory)this.lmDampingSpinner.getValueFactory();
        dampingValue = Math.max(Math.min(dampingValue, dampingSpinnerFactory.getMax()), dampingSpinnerFactory.getMin());
        dampingSpinnerFactory.setValue((Object)dampingValue);
        int iteration = this.adjustment.getMaximalNumberOfIterations();
        SpinnerValueFactory.IntegerSpinnerValueFactory iterationSpinnerFactory = (SpinnerValueFactory.IntegerSpinnerValueFactory)this.iterationSpinner.getValueFactory();
        iteration = Math.max(Math.min(iteration, iterationSpinnerFactory.getMax()), iterationSpinnerFactory.getMin());
        iterationSpinnerFactory.setValue((Object)iteration);
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("LeastSquaresSettingDialog.title", "Least-squares"));
        this.dialog.setHeaderText(i18N.getString("LeastSquaresSettingDialog.header", "Least-squares properties"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Void>(){

            public Void call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    LeastSquaresSettingDialog.this.adjustment.getVarianceComponent(VarianceComponentType.GLOBAL).setApplyAposterioriVarianceOfUnitWeight(LeastSquaresSettingDialog.this.applyVarianceOfUnitWeightCheckBox.isSelected());
                    LeastSquaresSettingDialog.this.adjustment.setAdjustModelParametersOnly(LeastSquaresSettingDialog.this.adjustModelParametersOnlyCheckBox.isSelected());
                    LeastSquaresSettingDialog.this.adjustment.setPreconditioning(LeastSquaresSettingDialog.this.preconditioningCheckBox.isSelected());
                    LeastSquaresSettingDialog.this.adjustment.setMaximalNumberOfIterations((Integer)LeastSquaresSettingDialog.this.iterationSpinner.getValue());
                    LeastSquaresSettingDialog.this.adjustment.setLevenbergMarquardtDampingValue((Double)LeastSquaresSettingDialog.this.lmDampingSpinner.getValue());
                    if (LeastSquaresSettingDialog.this.adjustment.getTransformation() != null) {
                        LeastSquaresSettingDialog.this.adjustment.getTransformation().setEstimateCenterOfMasses(LeastSquaresSettingDialog.this.estimateCenterOfMassCheckBox.isSelected());
                    }
                }
                return null;
            }
        });
        this.options.addFormatterChangedListener(this);
    }

    private Node createPane() {
        VBox contentPane = new VBox();
        contentPane.getChildren().add((Object)this.createGeneralSettingPane());
        contentPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        contentPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return contentPane;
    }

    private Node createGeneralSettingPane() {
        Label iterationLabel = new Label(i18N.getString("LeastSquaresSettingDialog.iterations.label", "Maximum number of iterations:"));
        Label dampingLabel = new Label(i18N.getString("LeastSquaresSettingDialog.lm.damping.label", "Levenberg-Marquardt damping value \u03bb:"));
        this.iterationSpinner = UiUtil.createIntegerSpinner(0, DefaultValue.getMaximumNumberOfIterations(), 10, i18N.getString("LeastSquaresSettingDialog.iterations.tooltip", "Set maximum permissible iteration value"));
        this.lmDampingSpinner = UiUtil.createDoubleSpinner(CellValueType.STATISTIC, 0.0, 100.0, 0.01, i18N.getString("LeastSquaresSettingDialog.lm.damping.tooltip", "Set damping value of Levenberg-Marquardt algorithm. The algorithm will be applied, if \u03bb > 0"));
        iterationLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        iterationLabel.setMaxSize(Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
        dampingLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        dampingLabel.setMaxSize(Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
        iterationLabel.setLabelFor(this.iterationSpinner);
        dampingLabel.setLabelFor((Node)this.lmDampingSpinner);
        this.applyVarianceOfUnitWeightCheckBox = UiUtil.createCheckBox(i18N.getString("LeastSquaresSettingDialog.applyvarianceofunitweight.label", "Apply variance of the unit weight"), i18N.getString("LeastSquaresSettingDialog.applyvarianceofunitweight.tooltip", "If checked, the estimated variance of the unit weight will be applied to scale the variance-covariance matrix"));
        this.adjustModelParametersOnlyCheckBox = UiUtil.createCheckBox(i18N.getString("LeastSquaresSettingDialog.adjustperametersonly.label", "Adjust only model parameters"), i18N.getString("LeastSquaresSettingDialog.adjustperametersonly.tooltip", "If checked, the model parameters will be adjusted but no outlier test will be carried out"));
        this.preconditioningCheckBox = UiUtil.createCheckBox(i18N.getString("LeastSquaresSettingDialog.preconditioning.label", "Preconditioning of normal system"), i18N.getString("LeastSquaresSettingDialog.preconditioning.tooltip", "If checked, a preconditioned iterative adjustment will be used"));
        this.estimateCenterOfMassCheckBox = UiUtil.createCheckBox(i18N.getString("LeastSquaresSettingDialog.centerofmass.label", "Center of mass reduction"), i18N.getString("LeastSquaresSettingDialog.centerofmass.tooltip", "If checked, points will be reduced by the center of mass"));
        GridPane gridPane = UiUtil.createGridPane();
        GridPane.setHgrow((Node)iterationLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)dampingLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.applyVarianceOfUnitWeightCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.adjustModelParametersOnlyCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.preconditioningCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.estimateCenterOfMassCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.iterationSpinner, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.lmDampingSpinner, (Priority)Priority.ALWAYS);
        Insets insetsCenter = new Insets(5.0, 2.0, 5.0, 2.0);
        Insets insetsTop = new Insets(10.0, 2.0, 5.0, 2.0);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 2.0);
        Insets insetsRight = new Insets(5.0, 2.0, 5.0, 7.0);
        GridPane.setMargin((Node)this.applyVarianceOfUnitWeightCheckBox, (Insets)insetsTop);
        GridPane.setMargin((Node)this.adjustModelParametersOnlyCheckBox, (Insets)insetsCenter);
        GridPane.setMargin((Node)this.preconditioningCheckBox, (Insets)insetsCenter);
        GridPane.setMargin((Node)this.estimateCenterOfMassCheckBox, (Insets)insetsCenter);
        GridPane.setMargin((Node)iterationLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)dampingLabel, (Insets)insetsLeft);
        GridPane.setMargin(this.iterationSpinner, (Insets)insetsRight);
        GridPane.setMargin((Node)this.lmDampingSpinner, (Insets)insetsRight);
        int row = 0;
        gridPane.add((Node)this.applyVarianceOfUnitWeightCheckBox, 0, row++, 2, 1);
        gridPane.add((Node)this.adjustModelParametersOnlyCheckBox, 0, row++, 2, 1);
        gridPane.add((Node)this.preconditioningCheckBox, 0, row++, 2, 1);
        gridPane.add((Node)this.estimateCenterOfMassCheckBox, 0, row++, 2, 1);
        gridPane.add((Node)iterationLabel, 0, row);
        gridPane.add(this.iterationSpinner, 1, row++);
        gridPane.add((Node)dampingLabel, 0, row);
        gridPane.add((Node)this.lmDampingSpinner, 1, row++);
        gridPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        gridPane.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return gridPane;
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        this.lmDampingSpinner.getEditor().setText(this.options.toStatisticFormat((Double)this.lmDampingSpinner.getValueFactory().getValue()));
    }
}

