/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.dialog;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.utils.UiUtil;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterOptions;
import org.applied_geodesy.util.unit.AngleUnit;
import org.applied_geodesy.util.unit.LengthUnit;
import org.applied_geodesy.util.unit.PercentUnit;
import org.applied_geodesy.util.unit.ScaleUnit;
import org.applied_geodesy.util.unit.Unit;
import org.applied_geodesy.util.unit.UnitType;

public class FormatterOptionDialog {
    private Map<CellValueType, ComboBox<Unit>> unitComboBoxes = new HashMap<CellValueType, ComboBox<Unit>>();
    private Map<CellValueType, Spinner<Integer>> digitsSpinners = new HashMap<CellValueType, Spinner<Integer>>();
    private FormatterOptions options = FormatterOptions.getInstance();
    private I18N i18n = I18N.getInstance();
    private static FormatterOptionDialog formatterOptionDialog = new FormatterOptionDialog();
    private Dialog<Void> dialog = null;
    private Accordion accordion = null;
    private boolean ignoreEvent = false;
    private Window window;

    private FormatterOptionDialog() {
    }

    public static void setOwner(Window owner) {
        FormatterOptionDialog.formatterOptionDialog.window = owner;
    }

    public static Optional<Void> showAndWait() {
        formatterOptionDialog.init();
        formatterOptionDialog.load();
        FormatterOptionDialog.formatterOptionDialog.accordion.setExpandedPane((TitledPane)FormatterOptionDialog.formatterOptionDialog.accordion.getPanes().get(0));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FormatterOptionDialog.formatterOptionDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)FormatterOptionDialog.formatterOptionDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return FormatterOptionDialog.formatterOptionDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("FormatterOptionDialog.title", "Preferences"));
        this.dialog.setHeaderText(this.i18n.getString("FormatterOptionDialog.header", "Formatter options and unit preferences"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.accordion = new Accordion();
        this.accordion.getPanes().addAll((Object[])new TitledPane[]{this.createFormatterOptionValuesPane(), this.createFormatterOptionUncertaintiesPane(), this.createFormatterOptionResidualsPane(), this.createFormatterOptionStatisticsPane()});
        this.dialog.getDialogPane().setContent((Node)this.accordion);
        this.dialog.setResizable(true);
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                FormatterOptionDialog.this.accordion.setExpandedPane((TitledPane)FormatterOptionDialog.this.accordion.getPanes().get(0));
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FormatterOptionDialog.this.digitsSpinners.get((Object)CellValueType.LENGTH).requestFocus();
            }
        });
    }

    private void load() {
        try {
            this.ignoreEvent = true;
            for (FormatterOptions.FormatterOption option : this.options.getFormatterOptions().values()) {
                CellValueType type = option.getType();
                if (this.digitsSpinners.containsKey((Object)type)) {
                    SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory = (SpinnerValueFactory.IntegerSpinnerValueFactory)this.digitsSpinners.get((Object)type).getValueFactory();
                    int digits = option.getFractionDigits();
                    digits = Math.max(Math.min(digits, valueFactory.getMax()), valueFactory.getMin());
                    this.digitsSpinners.get((Object)type).getValueFactory().setValue((Object)digits);
                }
                if (!this.unitComboBoxes.containsKey((Object)type)) continue;
                this.unitComboBoxes.get((Object)type).getSelectionModel().select((Object)option.getUnit());
            }
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    private TitledPane createFormatterOptionValuesPane() {
        String title = this.i18n.getString("FormatterOptionDialog.value.title", "Values");
        String tooltip = this.i18n.getString("FormatterOptionDialog.value.tooltip", "Preferences for measurement values");
        GridPane gridPane = UiUtil.createGridPane();
        Map<CellValueType, FormatterOptions.FormatterOption> formatterOptions = this.options.getFormatterOptions();
        int row = 0;
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.length.value.label", "Length:"), this.i18n.getString("FormatterOptionDialog.unit.length.value.tooltip.digits", "Set number of fraction digits for type length"), this.i18n.getString("FormatterOptionDialog.unit.length.value.tooltip.unit", "Set unit for type length value"), formatterOptions.get((Object)CellValueType.LENGTH), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.angle.value.label", "Angle:"), this.i18n.getString("FormatterOptionDialog.unit.angle.value.tooltip.digits", "Set number of fraction digits for type angle"), this.i18n.getString("FormatterOptionDialog.unit.angle.value.tooltip.unit", "Set unit for type angle value"), formatterOptions.get((Object)CellValueType.ANGLE), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.scale.value.label", "Scale:"), this.i18n.getString("FormatterOptionDialog.unit.scale.value.tooltip.digits", "Set number of fraction digits for type scale"), this.i18n.getString("FormatterOptionDialog.unit.scale.value.tooltip.unit", "Set unit for type scale value"), formatterOptions.get((Object)CellValueType.SCALE), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.vector.value.label", "Vector:"), this.i18n.getString("FormatterOptionDialog.unit.vector.value.tooltip.digits", "Set number of fraction digits for type vector"), this.i18n.getString("FormatterOptionDialog.unit.vector.value.tooltip.unit", "Set unit for type vector value"), formatterOptions.get((Object)CellValueType.VECTOR), gridPane, ++row);
        Region spacer = new Region();
        GridPane.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        gridPane.add((Node)spacer, 1, ++row, 3, 1);
        return UiUtil.createTitledPane(title, tooltip, (Node)gridPane);
    }

    private TitledPane createFormatterOptionUncertaintiesPane() {
        String title = this.i18n.getString("FormatterOptionDialog.uncertainty.title", "Uncertainties");
        String tooltip = this.i18n.getString("FormatterOptionDialog.uncertainty.tooltip", "Preferences for uncertainties");
        GridPane gridPane = UiUtil.createGridPane();
        Map<CellValueType, FormatterOptions.FormatterOption> formatterOptions = this.options.getFormatterOptions();
        int row = 0;
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.length.uncertainty.label", "Length uncertainty:"), this.i18n.getString("FormatterOptionDialog.unit.length.uncertainty.tooltip.digits", "Set number of fraction digits for type length uncertainty"), this.i18n.getString("FormatterOptionDialog.unit.length.uncertainty.tooltip.unit", "Set unit for type length uncertainty"), formatterOptions.get((Object)CellValueType.LENGTH_UNCERTAINTY), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.angle.uncertainty.label", "Angle uncertainty:"), this.i18n.getString("FormatterOptionDialog.unit.angle.uncertainty.tooltip.digits", "Set number of fraction digits for type angle uncertainty"), this.i18n.getString("FormatterOptionDialog.unit.angle.uncertainty.tooltip.unit", "Set unit for type angle uncertainty"), formatterOptions.get((Object)CellValueType.ANGLE_UNCERTAINTY), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.scale.uncertainty.label", "Scale uncertainty:"), this.i18n.getString("FormatterOptionDialog.unit.scale.uncertainty.tooltip.digits", "Set number of fraction digits for type scale uncertainty"), this.i18n.getString("FormatterOptionDialog.unit.scale.uncertainty.tooltip.unit", "Set unit for type scale uncertainty"), formatterOptions.get((Object)CellValueType.SCALE_UNCERTAINTY), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.vector.uncertainty.label", "Vector uncertainty:"), this.i18n.getString("FormatterOptionDialog.unit.vector.uncertainty.tooltip.digits", "Set number of fraction digits for type vector uncertainty"), this.i18n.getString("FormatterOptionDialog.unit.vector.uncertainty.tooltip.unit", "Set unit for type vector uncertainty"), formatterOptions.get((Object)CellValueType.VECTOR_UNCERTAINTY), gridPane, ++row);
        Region spacer = new Region();
        GridPane.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        gridPane.add((Node)spacer, 1, ++row, 3, 1);
        return UiUtil.createTitledPane(title, tooltip, (Node)gridPane);
    }

    private TitledPane createFormatterOptionResidualsPane() {
        String title = this.i18n.getString("FormatterOptionDialog.residual.title", "Residuals");
        String tooltip = this.i18n.getString("FormatterOptionDialog.residual.tooltip", "Preferences for residuals");
        GridPane gridPane = UiUtil.createGridPane();
        Map<CellValueType, FormatterOptions.FormatterOption> formatterOptions = this.options.getFormatterOptions();
        int row = 0;
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.length.residual.label", "Length residual:"), this.i18n.getString("FormatterOptionDialog.unit.length.residual.tooltip.digits", "Set number of fraction digits for type length residual"), this.i18n.getString("FormatterOptionDialog.unit.length.residual.tooltip.unit", "Set unit for type length residual"), formatterOptions.get((Object)CellValueType.LENGTH_RESIDUAL), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.angle.residual.label", "Angle residual:"), this.i18n.getString("FormatterOptionDialog.unit.angle.residual.tooltip.digits", "Set number of fraction digits for type angle residual"), this.i18n.getString("FormatterOptionDialog.unit.angle.residual.tooltip.unit", "Set unit for type angle residual"), formatterOptions.get((Object)CellValueType.ANGLE_RESIDUAL), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.scale.residual.label", "Scale residual:"), this.i18n.getString("FormatterOptionDialog.unit.scale.residual.tooltip.digits", "Set number of fraction digits for type scale residual"), this.i18n.getString("FormatterOptionDialog.unit.scale.residual.tooltip.unit", "Set unit for type scale residual"), formatterOptions.get((Object)CellValueType.SCALE_RESIDUAL), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.vector.residual.label", "Vector residual:"), this.i18n.getString("FormatterOptionDialog.unit.vector.residual.tooltip.digits", "Set number of fraction digits for type vector residual"), this.i18n.getString("FormatterOptionDialog.unit.vector.residual.tooltip.unit", "Set unit for type vector residual"), formatterOptions.get((Object)CellValueType.VECTOR_RESIDUAL), gridPane, ++row);
        Region spacer = new Region();
        GridPane.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        gridPane.add((Node)spacer, 1, ++row, 3, 1);
        return UiUtil.createTitledPane(title, tooltip, (Node)gridPane);
    }

    private TitledPane createFormatterOptionStatisticsPane() {
        String title = this.i18n.getString("FormatterOptionDialog.statistic.title", "Statistic values");
        String tooltip = this.i18n.getString("FormatterOptionDialog.statistic.tooltip", "Preferences for unitless statistics values");
        GridPane gridPane = UiUtil.createGridPane();
        Map<CellValueType, FormatterOptions.FormatterOption> formatterOptions = this.options.getFormatterOptions();
        int row = 0;
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.percentage.label", "Percentages values:"), this.i18n.getString("FormatterOptionDialog.unit.percentage.tooltip.digits", "Set number of fraction digits for type percentage"), this.i18n.getString("FormatterOptionDialog.unit.percentage.tooltip.unit", "Set unit for percentage values"), formatterOptions.get((Object)CellValueType.PERCENTAGE), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.statistic.label", "Statistic (unitless):"), this.i18n.getString("FormatterOptionDialog.unit.statistic.tooltip.digits", "Set number of fraction digits for type statistic"), null, formatterOptions.get((Object)CellValueType.STATISTIC), gridPane, ++row);
        this.addRow(this.i18n.getString("FormatterOptionDialog.unit.floatingpoint.label", "Floating-point:"), this.i18n.getString("FormatterOptionDialog.unit.floatingpoint.tooltip.digits", "Set number of fraction digits for floating-point type"), null, formatterOptions.get((Object)CellValueType.DOUBLE), gridPane, ++row);
        Region spacer = new Region();
        GridPane.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        gridPane.add((Node)spacer, 1, ++row, 3, 1);
        return UiUtil.createTitledPane(title, tooltip, (Node)gridPane);
    }

    private void addRow(String label, String spinnerTooltip, String comboboxTooltip, FormatterOptions.FormatterOption option, GridPane parent, int row) {
        Label unitLabel = new Label(label);
        unitLabel.setWrapText(false);
        unitLabel.setMaxWidth(Double.MAX_VALUE);
        unitLabel.setPrefHeight(-1.0);
        unitLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        CellValueType type = option.getType();
        Spinner<Integer> digitsSpinner = this.createIntegerSpinner(type, 0, 10, 1, spinnerTooltip);
        ComboBox<Unit> unitComboBox = null;
        Unit unit = option.getUnit();
        if (unit != null) {
            if ((type == CellValueType.ANGLE || type == CellValueType.ANGLE_RESIDUAL || type == CellValueType.ANGLE_UNCERTAINTY) && AngleUnit.getUnit(unit.getType()) != null) {
                LinkedHashSet<AngleUnit> angleUnits = new LinkedHashSet<AngleUnit>(AngleUnit.UNITS.values());
                unitComboBox = this.createUnitComboBox(type, comboboxTooltip, angleUnits);
            } else if ((type == CellValueType.SCALE || type == CellValueType.SCALE_RESIDUAL || type == CellValueType.SCALE_UNCERTAINTY) && ScaleUnit.getUnit(unit.getType()) != null) {
                List<ScaleUnit> scaleUnits = null;
                switch (type) {
                    case SCALE: {
                        scaleUnits = List.of(ScaleUnit.getUnit(UnitType.UNITLESS), ScaleUnit.getUnit(UnitType.PARTS_PER_MILLION_WRT_ONE));
                        break;
                    }
                    case SCALE_UNCERTAINTY: 
                    case SCALE_RESIDUAL: {
                        scaleUnits = List.of(ScaleUnit.getUnit(UnitType.UNITLESS), ScaleUnit.getUnit(UnitType.PARTS_PER_MILLION_WRT_ZERO));
                        break;
                    }
                    default: {
                        System.err.println(this.getClass().getSimpleName() + " Error, not a scale type " + String.valueOf((Object)type));
                    }
                }
                if (scaleUnits != null) {
                    unitComboBox = this.createUnitComboBox(type, comboboxTooltip, scaleUnits);
                }
            } else if ((type == CellValueType.LENGTH || type == CellValueType.LENGTH_RESIDUAL || type == CellValueType.LENGTH_UNCERTAINTY || type == CellValueType.VECTOR || type == CellValueType.VECTOR_RESIDUAL || type == CellValueType.VECTOR_UNCERTAINTY) && LengthUnit.getUnit(unit.getType()) != null) {
                unitComboBox = this.createUnitComboBox(type, comboboxTooltip, LengthUnit.UNITS.values());
            } else if (type == CellValueType.PERCENTAGE && PercentUnit.getUnit(unit.getType()) != null) {
                unitComboBox = this.createUnitComboBox(type, comboboxTooltip, PercentUnit.UNITS.values());
            }
        }
        this.digitsSpinners.put(option.getType(), digitsSpinner);
        GridPane.setHgrow((Node)unitLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(digitsSpinner, (Priority)Priority.SOMETIMES);
        GridPane.setMargin((Node)unitLabel, (Insets)new Insets(5.0, 7.0, 5.0, 5.0));
        GridPane.setMargin(digitsSpinner, (Insets)new Insets(5.0, 7.0, 5.0, 7.0));
        parent.add((Node)unitLabel, 0, row);
        parent.add(digitsSpinner, 1, row);
        if (unitComboBox != null) {
            GridPane.setHgrow(unitComboBox, (Priority)Priority.ALWAYS);
            GridPane.setMargin(unitComboBox, (Insets)new Insets(5.0, 5.0, 5.0, 7.0));
            parent.add(unitComboBox, 2, row);
            this.unitComboBoxes.put(option.getType(), unitComboBox);
        } else {
            Region spacer = new Region();
            spacer.setMaxWidth(Double.MAX_VALUE);
            GridPane.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            parent.add((Node)spacer, 2, row);
        }
    }

    private ComboBox<Unit> createUnitComboBox(CellValueType type, String tooltip, Collection<? extends Unit> items) {
        ComboBox unitComboBox = new ComboBox();
        unitComboBox.getItems().setAll(items);
        unitComboBox.setConverter((StringConverter)new StringConverter<Unit>(){

            public String toString(Unit unit) {
                return unit == null ? null : unit.getName();
            }

            public Unit fromString(String string) {
                return null;
            }
        });
        unitComboBox.setTooltip(new Tooltip(tooltip));
        unitComboBox.valueProperty().addListener(new UnitChangeListener(type));
        unitComboBox.setMinWidth(150.0);
        unitComboBox.setMaxWidth(Double.MAX_VALUE);
        return unitComboBox;
    }

    private Spinner<Integer> createIntegerSpinner(CellValueType type, int min, int max, int amountToStepBy, String tooltip) {
        final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setGroupingUsed(false);
        StringConverter<Integer> converter = new StringConverter<Integer>(){

            public Integer fromString(String s) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                try {
                    return numberFormat.parse(s).intValue();
                }
                catch (Exception nfe) {
                    nfe.printStackTrace();
                    return null;
                }
            }

            public String toString(Integer d) {
                return d == null ? "" : numberFormat.format(d);
            }
        };
        final SpinnerValueFactory.IntegerSpinnerValueFactory integerFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max);
        Spinner integerSpinner = new Spinner();
        integerSpinner.setUserData((Object)type);
        integerSpinner.setEditable(true);
        integerSpinner.setValueFactory((SpinnerValueFactory)integerFactory);
        integerFactory.setConverter((StringConverter)converter);
        integerFactory.setAmountToStepBy(amountToStepBy);
        TextFormatter formatter = new TextFormatter(integerFactory.getConverter(), (Object)((Integer)integerFactory.getValue()));
        integerSpinner.getEditor().setTextFormatter(formatter);
        integerSpinner.getEditor().setAlignment(Pos.BOTTOM_RIGHT);
        integerFactory.valueProperty().bindBidirectional((Property)formatter.valueProperty());
        integerFactory.valueProperty().addListener((ChangeListener)new DigitsChangeListener(type));
        integerSpinner.setMinWidth(75.0);
        integerSpinner.setPrefWidth(100.0);
        integerSpinner.setMaxWidth(Double.MAX_VALUE);
        integerSpinner.setTooltip(new Tooltip(tooltip));
        integerFactory.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                if (newValue == null) {
                    integerFactory.setValue((Object)oldValue);
                }
            }
        });
        return integerSpinner;
    }

    private class DigitsChangeListener
    implements ChangeListener<Integer> {
        private CellValueType type;

        private DigitsChangeListener(CellValueType type) {
            this.type = type;
        }

        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (!FormatterOptionDialog.this.ignoreEvent) {
                FormatterOptions.FormatterOption option = FormatterOptionDialog.this.options.getFormatterOptions().get((Object)this.type);
                option.setFractionDigits(newValue);
            }
        }
    }

    private class UnitChangeListener<T extends Unit>
    implements ChangeListener<T> {
        private CellValueType type;

        private UnitChangeListener(CellValueType type) {
            this.type = type;
        }

        public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
            if (!FormatterOptionDialog.this.ignoreEvent) {
                FormatterOptions.FormatterOption option = FormatterOptionDialog.this.options.getFormatterOptions().get((Object)this.type);
                option.setUnit((Unit)newValue);
            }
        }
    }
}

