/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.dialog;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.transformation.TransformationType;
import org.applied_geodesy.coordtrans.ui.CoordTrans;
import org.applied_geodesy.coordtrans.ui.dialog.FrameType;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.io.reader.PositionFileReader;
import org.applied_geodesy.coordtrans.ui.utils.UiUtil;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.io.DefaultFileChooser;

public class FilePathsSelectionDialog {
    private I18N i18n = I18N.getInstance();
    private static FilePathsSelectionDialog filePathsSelectionDialog = new FilePathsSelectionDialog();
    private Dialog<FilePathPair> dialog = null;
    private Window window;
    private TransformationType transformationType = TransformationType.SPATIAL;
    private TextField sourceSystemPathTextField;
    private TextField targetSystemPathTextField;

    public static void setOwner(Window owner) {
        FilePathsSelectionDialog.filePathsSelectionDialog.window = owner;
    }

    public static Optional<FilePathPair> showAndWait() {
        filePathsSelectionDialog.init();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FilePathsSelectionDialog.filePathsSelectionDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)FilePathsSelectionDialog.filePathsSelectionDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return FilePathsSelectionDialog.filePathsSelectionDialog.dialog.showAndWait();
    }

    private void setTransformationType(TransformationType transformationType) {
        this.transformationType = transformationType;
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("FilePathsSelectionDialog.title", "File selection"));
        this.dialog.setHeaderText(String.format(Locale.ENGLISH, this.i18n.getString("FilePathsSelectionDialog.header", "File selection for source and target system"), ""));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, FilePathPair>(){

            public FilePathPair call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    FilePathPair filePathPair = FilePathsSelectionDialog.this.getFilePathPair();
                    return filePathPair;
                }
                return null;
            }
        });
    }

    private Node createPane() {
        GridPane gridPane = UiUtil.createGridPane();
        Label sourceSystemPathLabel = new Label(this.i18n.getString("FilePathsSelectionDialog.frame.source.file.path.label", "Source system:"));
        Label targetSystemPathLabel = new Label(this.i18n.getString("FilePathsSelectionDialog.frame.target.file.path.label", "Target system:"));
        Label transformationTypeLabel = new Label(this.i18n.getString("FilePathsSelectionDialog.transformation.type.label", "Transformation:"));
        sourceSystemPathLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        targetSystemPathLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        transformationTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.sourceSystemPathTextField = UiUtil.createTextField(this.i18n.getString("FilePathsSelectionDialog.frame.source.file.path.tooltip", "Selected path to source system file"), this.i18n.getString("FilePathsSelectionDialog.frame.source.file.path.prompt", "Source system file path"));
        this.targetSystemPathTextField = UiUtil.createTextField(this.i18n.getString("FilePathsSelectionDialog.frame.target.file.path.tooltip", "Selected path to target system file"), this.i18n.getString("FilePathsSelectionDialog.frame.target.file.path.prompt", "Target system file path"));
        Button sourceSystemPathButton = UiUtil.createButton(this.i18n.getString("FilePathsSelectionDialog.frame.source.file.button.label", "Browse"), this.i18n.getString("FilePathsSelectionDialog.frame.source.file.button.tooltip", "Select path to source system file"));
        Button targetSystemPathButton = UiUtil.createButton(this.i18n.getString("FilePathsSelectionDialog.frame.target.file.button.label", "Browse"), this.i18n.getString("FilePathsSelectionDialog.frame.target.file.button.tooltip", "Select path to target system file"));
        ToggleGroup group = new ToggleGroup();
        RadioButton heightTransformationRadioButton = UiUtil.createRadioButton(this.i18n.getString("FilePathsSelectionDialog.transformation.type.height.label", "Height"), this.i18n.getString("FilePathsSelectionDialog.transformation.type.height.tooltip", "If selected, a height transformation using one-dimensional points is performed"), group);
        heightTransformationRadioButton.setUserData((Object)TransformationType.HEIGHT);
        RadioButton planarTransformationRadioButton = UiUtil.createRadioButton(this.i18n.getString("FilePathsSelectionDialog.transformation.type.planar.label", "Planar"), this.i18n.getString("FilePathsSelectionDialog.transformation.type.planar.tooltip", "If selected, a planar transformation using two-dimensional points is performed"), group);
        planarTransformationRadioButton.setUserData((Object)TransformationType.PLANAR);
        RadioButton spatialTransformationRadioButton = UiUtil.createRadioButton(this.i18n.getString("FilePathsSelectionDialog.transformation.type.spatial.label", "Spatial"), this.i18n.getString("FilePathsSelectionDialog.transformation.type.spatial.tooltip", "If selected, a spatial transformation using three-dimensional points is performed"), group);
        spatialTransformationRadioButton.setUserData((Object)TransformationType.SPATIAL);
        spatialTransformationRadioButton.setSelected(true);
        HBox groupBox = new HBox(10.0);
        HBox.setHgrow((Node)heightTransformationRadioButton, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)planarTransformationRadioButton, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)spatialTransformationRadioButton, (Priority)Priority.NEVER);
        groupBox.getChildren().setAll((Object[])new Node[]{heightTransformationRadioButton, planarTransformationRadioButton, spatialTransformationRadioButton});
        group.selectedToggleProperty().addListener((ChangeListener)new TransformationTypeChangeListener());
        sourceSystemPathButton.setUserData((Object)FrameType.SOURCE);
        targetSystemPathButton.setUserData((Object)FrameType.TARGET);
        BrowseActionEventHandler browseActionEventHandler = new BrowseActionEventHandler();
        sourceSystemPathButton.setOnAction((EventHandler)browseActionEventHandler);
        targetSystemPathButton.setOnAction((EventHandler)browseActionEventHandler);
        this.sourceSystemPathTextField.setPrefWidth(250.0);
        this.targetSystemPathTextField.setPrefWidth(250.0);
        sourceSystemPathLabel.setLabelFor((Node)this.sourceSystemPathTextField);
        targetSystemPathLabel.setLabelFor((Node)this.targetSystemPathTextField);
        transformationTypeLabel.setLabelFor((Node)groupBox);
        GridPane.setHgrow((Node)sourceSystemPathLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)targetSystemPathLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)transformationTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.sourceSystemPathTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.targetSystemPathTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)sourceSystemPathButton, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)targetSystemPathButton, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)groupBox, (Priority)Priority.SOMETIMES);
        GridPane.setMargin((Node)sourceSystemPathLabel, (Insets)new Insets(5.0, 5.0, 5.0, 0.0));
        GridPane.setMargin((Node)targetSystemPathLabel, (Insets)new Insets(5.0, 5.0, 5.0, 0.0));
        GridPane.setMargin((Node)transformationTypeLabel, (Insets)new Insets(10.0, 5.0, 5.0, 0.0));
        GridPane.setMargin((Node)this.sourceSystemPathTextField, (Insets)new Insets(5.0, 5.0, 5.0, 5.0));
        GridPane.setMargin((Node)this.targetSystemPathTextField, (Insets)new Insets(5.0, 5.0, 5.0, 5.0));
        GridPane.setMargin((Node)sourceSystemPathButton, (Insets)new Insets(5.0, 0.0, 5.0, 5.0));
        GridPane.setMargin((Node)targetSystemPathButton, (Insets)new Insets(5.0, 0.0, 5.0, 5.0));
        GridPane.setMargin((Node)groupBox, (Insets)new Insets(10.0, 5.0, 5.0, 5.0));
        int row = 0;
        gridPane.add((Node)sourceSystemPathLabel, 0, row);
        gridPane.add((Node)this.sourceSystemPathTextField, 1, row);
        gridPane.add((Node)sourceSystemPathButton, 2, row++);
        gridPane.add((Node)targetSystemPathLabel, 0, row);
        gridPane.add((Node)this.targetSystemPathTextField, 1, row);
        gridPane.add((Node)targetSystemPathButton, 2, row++);
        gridPane.add((Node)transformationTypeLabel, 0, row);
        gridPane.add((Node)groupBox, 1, row++, 2, 1);
        return gridPane;
    }

    private void setSelectedFile(FrameType frameType) {
        String title = "";
        String fileName = "";
        File selectedFile = null;
        switch (frameType) {
            case SOURCE: {
                title = this.i18n.getString("FilePathsSelectionDialog.frame.source.file.selection.title", "Source system file");
                fileName = this.sourceSystemPathTextField.getText();
                break;
            }
            case TARGET: {
                title = this.i18n.getString("FilePathsSelectionDialog.frame.target.file.selection.title", "Target system file");
                fileName = this.targetSystemPathTextField.getText();
            }
        }
        selectedFile = DefaultFileChooser.showOpenDialog((Window)CoordTrans.getStage(), title, fileName, PositionFileReader.getExtensionFilters());
        if (selectedFile != null) {
            switch (frameType) {
                case SOURCE: {
                    this.sourceSystemPathTextField.setText(selectedFile.toPath().toAbsolutePath().normalize().toString());
                    break;
                }
                case TARGET: {
                    this.targetSystemPathTextField.setText(selectedFile.toPath().toAbsolutePath().normalize().toString());
                }
            }
        }
    }

    private FilePathPair getFilePathPair() {
        try {
            Path sourceFilePath = this.convertString2Path(this.sourceSystemPathTextField.getText());
            Path targetFilePath = this.convertString2Path(this.targetSystemPathTextField.getText());
            return new FilePathPair(this.transformationType, sourceFilePath, targetFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(FilePathsSelectionDialog.this.i18n.getString("FilePathsSelectionDialog.message.error.load.exception.title", "I/O-Error"), FilePathsSelectionDialog.this.i18n.getString("FilePathsSelectionDialog.message.error.load.exception.header", "Error, could not read selected files. Please check file paths."), FilePathsSelectionDialog.this.i18n.getString("FilePathsSelectionDialog.message.error.load.exception.message", "An exception has occurred during file import."), e);
                }
            });
            return null;
        }
    }

    private Path convertString2Path(String str) throws IllegalArgumentException, InvalidPathException, SecurityException, IOException {
        if (str == null || str.isBlank()) {
            throw new IllegalArgumentException("Error, selected file is empty!");
        }
        Path path = Paths.get(str, new String[0]);
        if (!(Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path))) {
            throw new IOException("Error, cannot access the selected file " + String.valueOf(path) + "!");
        }
        return path;
    }

    private class BrowseActionEventHandler
    implements EventHandler<ActionEvent> {
        private BrowseActionEventHandler() {
        }

        public void handle(ActionEvent event) {
            if (event.getSource() instanceof Button && ((Button)event.getSource()).getUserData() != null && ((Button)event.getSource()).getUserData() instanceof FrameType) {
                Button button = (Button)event.getSource();
                FrameType frameType = (FrameType)((Object)button.getUserData());
                FilePathsSelectionDialog.this.setSelectedFile(frameType);
            }
        }
    }

    public class FilePathPair {
        private final Path sourceFilePath;
        private final Path targetFilePath;
        private final TransformationType transformationType;

        private FilePathPair(TransformationType transformationType, Path sourceFilePath, Path targetFilePath) {
            this.sourceFilePath = sourceFilePath;
            this.targetFilePath = targetFilePath;
            this.transformationType = transformationType;
        }

        public final Path getSourceFilePath() {
            return this.sourceFilePath;
        }

        public final Path getTargetFilePath() {
            return this.targetFilePath;
        }

        public final TransformationType getTransformationType() {
            return this.transformationType;
        }
    }

    private class TransformationTypeChangeListener
    implements ChangeListener<Toggle> {
        private TransformationTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends Toggle> ov, Toggle oldToggle, Toggle newToggle) {
            if (newToggle.getUserData() != null && newToggle.getUserData() instanceof TransformationType) {
                FilePathsSelectionDialog.this.setTransformationType((TransformationType)((Object)newToggle.getUserData()));
            }
        }
    }
}

