/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.dialog;

import java.util.Optional;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.applied_geodesy.coordtrans.ui.utils.UiUtil;
import org.applied_geodesy.version.VersionType;
import org.applied_geodesy.version.coordtrans.Version;

public class AboutDialog {
    private static AboutDialog aboutDialog = new AboutDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private HostServices hostServices;

    private AboutDialog() {
    }

    public static void setOwner(Window owner) {
        AboutDialog.aboutDialog.window = owner;
    }

    public static void setHostServices(HostServices hostServices) {
        AboutDialog.aboutDialog.hostServices = hostServices;
    }

    public static Optional<Void> showAndWait() {
        aboutDialog.init();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AboutDialog.aboutDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)AboutDialog.aboutDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return AboutDialog.aboutDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle("JUniForm");
        this.dialog.setHeaderText("CoordTrans \u2014 Universal\u00b7Coordinate\u00b7Transformation" + (Version.isReleaseCandidate() ? " (RC)" : ""));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
    }

    private Node createPane() {
        GridPane gridPane = UiUtil.createGridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(15.0);
        gridPane.setVgap(10.0);
        gridPane.setAlignment(Pos.CENTER);
        Text applicationText = new Text("Least Squares-based Coordinate Transformation");
        applicationText.setFont(Font.font((String)"SansSerif", (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)14.0));
        applicationText.setTextAlignment(TextAlignment.CENTER);
        Label authorLabel = this.createLabel("Author:");
        Label licenceLabel = this.createLabel("Licence:");
        Label uiVersionLabel = this.createLabel("UI version:");
        Label coreVersionLabel = this.createLabel("AC version:");
        Label homePageLabel = this.createLabel("Homepage:");
        Label thirdPartyLabel = this.createLabel("3rd Party Libraries:");
        Label author = this.createLabel("Michael L\u00f6sler\r\n\r\nFriedberger Str. 50D\r\nDE-61118 Bad Vilbel");
        Label licence = this.createLabel("GNU General Public License v3.0");
        Label uiVersion = this.createLabel("v" + String.valueOf(Version.get(VersionType.USER_INTERFACE)));
        Label coreVersion = this.createLabel("v" + String.valueOf(Version.get(VersionType.ADJUSTMENT_CORE)));
        final Hyperlink homePageLink = new Hyperlink("software.applied-geodesy.org");
        homePageLink.setTooltip(new Tooltip("Go to software.applied-geodesy.org"));
        homePageLink.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        homePageLink.setPadding(new Insets(0.0));
        homePageLink.setVisited(false);
        homePageLink.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (AboutDialog.this.hostServices != null) {
                    AboutDialog.this.hostServices.showDocument("https://software.applied-geodesy.org");
                }
                homePageLink.setVisited(false);
            }
        });
        Label thirdParty = this.createLabel("\u2219 MTJ: GNU Lesser General Public License v3.0\r\n\u2219 FreeMarker: Apache License v2.0\r\n\u2219 netlib-java: BSD License\r\n\u2219 JLAPACK: BSD License\r\n\u2219 JDistlib: GNU General Public License v2.0\r\n\u2219 Launch4J: BSD/MIT License");
        authorLabel.setLabelFor((Node)author);
        licenceLabel.setLabelFor((Node)licence);
        uiVersionLabel.setLabelFor((Node)uiVersion);
        coreVersionLabel.setLabelFor((Node)coreVersion);
        homePageLabel.setLabelFor((Node)homePageLink);
        thirdPartyLabel.setLabelFor((Node)thirdParty);
        GridPane.setHalignment((Node)applicationText, (HPos)HPos.CENTER);
        int row = 0;
        gridPane.add((Node)applicationText, 0, row++, 2, 1);
        gridPane.add((Node)authorLabel, 0, row);
        gridPane.add((Node)author, 1, row++);
        gridPane.add((Node)licenceLabel, 0, row);
        gridPane.add((Node)licence, 1, row++);
        gridPane.add((Node)uiVersionLabel, 0, row);
        gridPane.add((Node)uiVersion, 1, row++);
        gridPane.add((Node)coreVersionLabel, 0, row);
        gridPane.add((Node)coreVersion, 1, row++);
        gridPane.add((Node)homePageLabel, 0, row);
        gridPane.add((Node)homePageLink, 1, row++);
        gridPane.add((Node)thirdPartyLabel, 0, row);
        gridPane.add((Node)thirdParty, 1, row++);
        ScrollPane scroller = new ScrollPane((Node)gridPane);
        scroller.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        scroller.setFitToHeight(true);
        scroller.setFitToWidth(true);
        return gridPane;
    }

    private Label createLabel(String text) {
        Label label = new Label(text);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
        label.setAlignment(Pos.TOP_LEFT);
        return label;
    }
}

