/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeView;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.applied_geodesy.adjustment.transformation.TransformationAdjustment;
import org.applied_geodesy.adjustment.transformation.TransformationChangeListener;
import org.applied_geodesy.adjustment.transformation.TransformationEvent;
import org.applied_geodesy.coordtrans.ui.dialog.AboutDialog;
import org.applied_geodesy.coordtrans.ui.dialog.FilePathsSelectionDialog;
import org.applied_geodesy.coordtrans.ui.dialog.FormatterOptionDialog;
import org.applied_geodesy.coordtrans.ui.dialog.LeastSquaresSettingDialog;
import org.applied_geodesy.coordtrans.ui.dialog.MatrixDialog;
import org.applied_geodesy.coordtrans.ui.dialog.QuantilesDialog;
import org.applied_geodesy.coordtrans.ui.dialog.ReadFileProgressDialog;
import org.applied_geodesy.coordtrans.ui.dialog.TestStatisticDialog;
import org.applied_geodesy.coordtrans.ui.dialog.TransformationAdjustmentDialog;
import org.applied_geodesy.coordtrans.ui.dialog.VarianceComponentsDialog;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.io.writer.FTLReport;
import org.applied_geodesy.coordtrans.ui.menu.UIMenuBuilder;
import org.applied_geodesy.coordtrans.ui.pane.UIInterpolationPaneBuilder;
import org.applied_geodesy.coordtrans.ui.pane.UIRestrictionPaneBuilder;
import org.applied_geodesy.coordtrans.ui.table.UIFramePositionPairTableBuilder;
import org.applied_geodesy.coordtrans.ui.table.UIHomologousFramePositionPairTableBuilder;
import org.applied_geodesy.coordtrans.ui.table.UIParameterTableBuilder;
import org.applied_geodesy.coordtrans.ui.tabpane.UITabPaneBuilder;
import org.applied_geodesy.coordtrans.ui.tree.TreeItemValue;
import org.applied_geodesy.coordtrans.ui.tree.UITreeBuilder;
import org.applied_geodesy.jag3d.ui.JAG3D;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.util.ImageUtils;
import org.applied_geodesy.version.coordtrans.Version;

public class CoordTrans
extends Application {
    private static I18N i18n = I18N.getInstance();
    private static final String TITLE_TEMPLATE = "%s%sCoordTrans%s \u2014 Least Squares-based Coordinate Transformation";
    private static Stage primaryStage;
    private Button adjustmentButton;

    public static void setTitle(int dim) {
        switch (dim) {
            case 1: {
                CoordTrans.setTitle(i18n.getString("CoordTrans.transformation.type.height.title", "Height transformation"));
                break;
            }
            case 2: {
                CoordTrans.setTitle(i18n.getString("CoordTrans.transformation.type.planar.title", "Planar transformation"));
                break;
            }
            case 3: {
                CoordTrans.setTitle(i18n.getString("CoordTrans.transformation.type.spatial.title", "Spatial transformation"));
                break;
            }
            default: {
                CoordTrans.setTitle(null);
            }
        }
    }

    public static void setTitle(String title) {
        if (primaryStage != null && title != null && !title.trim().isEmpty()) {
            primaryStage.setTitle(String.format(Locale.ENGLISH, TITLE_TEMPLATE, title, " \u2014 ", Version.isReleaseCandidate() ? " (RC)" : ""));
        } else if (primaryStage != null) {
            primaryStage.setTitle(String.format(Locale.ENGLISH, TITLE_TEMPLATE, "", "", Version.isReleaseCandidate() ? " (RC)" : ""));
        }
    }

    public static void close() {
        primaryStage.close();
    }

    public static Stage getStage() {
        return primaryStage;
    }

    private void setHostServices() {
        HostServices hostServices = this.getHostServices();
        FTLReport.setHostServices(hostServices);
        AboutDialog.setHostServices(hostServices);
    }

    private void setStageToDialogs(Stage primaryStage) {
        QuantilesDialog.setOwner((Window)primaryStage);
        VarianceComponentsDialog.setOwner((Window)primaryStage);
        OptionDialog.setOwner((Window)primaryStage);
        MatrixDialog.setOwner((Window)primaryStage);
        FilePathsSelectionDialog.setOwner((Window)primaryStage);
        AboutDialog.setOwner((Window)primaryStage);
        TransformationAdjustmentDialog.setOwner((Window)primaryStage);
        LeastSquaresSettingDialog.setOwner((Window)primaryStage);
        TestStatisticDialog.setOwner((Window)primaryStage);
        FormatterOptionDialog.setOwner((Window)primaryStage);
        ReadFileProgressDialog.setOwner((Window)primaryStage);
    }

    public void start(Stage primaryStage) throws Exception {
        if (CoordTrans.primaryStage != primaryStage) {
            CoordTrans.primaryStage = primaryStage;
            UITabPaneBuilder tabPaneBuilder = UITabPaneBuilder.getInstance();
            UIMenuBuilder menuBuilder = UIMenuBuilder.getInstance();
            UITreeBuilder treeBuilder = UITreeBuilder.getInstance();
            this.adjustmentButton = new Button(i18n.getString("CoordTrans.button.adjust.label", "Adjust transformation"));
            this.adjustmentButton.setTooltip(new Tooltip(i18n.getString("CoordTrans.button.adjust.tooltip", "Adjust transformation parameters")));
            this.adjustmentButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    TransformationAdjustmentDialog.show();
                }
            });
            this.adjustmentButton.setDisable(true);
            final TabPane tabPane = tabPaneBuilder.getTabPane();
            TreeView<TreeItemValue<?>> tree = treeBuilder.getTree();
            SplitPane splitPane = new SplitPane();
            splitPane.setOrientation(Orientation.HORIZONTAL);
            splitPane.getItems().addAll((Object[])new Node[]{tree, tabPane});
            splitPane.setDividerPositions(new double[]{0.3});
            SplitPane.setResizableWithParent(tree, (Boolean)false);
            DropShadow ds = new DropShadow();
            ds.setOffsetY(0.5);
            ds.setColor(Color.gray((double)0.8));
            Text applicationName = new Text();
            applicationName.setEffect((Effect)ds);
            applicationName.setCache(true);
            applicationName.setFill((Paint)Color.GREY);
            applicationName.setText("Universal\u00b7Coordinate\u00b7Transformation");
            applicationName.setFont(Font.font((String)"SansSerif", (FontWeight)FontWeight.NORMAL, (double)17.0));
            Region spacer = new Region();
            HBox hbox = new HBox(10.0);
            hbox.setPadding(new Insets(5.0, 10.0, 5.0, 15.0));
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            hbox.getChildren().addAll((Object[])new Node[]{applicationName, spacer, this.adjustmentButton});
            BorderPane border = new BorderPane();
            border.setPrefSize(900.0, 650.0);
            border.setTop((Node)menuBuilder.getMenuBar());
            border.setCenter((Node)splitPane);
            border.setBottom((Node)hbox);
            Scene scene = new Scene((Parent)border);
            scene.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){
                final KeyCombination adjustKeyComb = new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]);
                final KeyCombination tabOneKeyComb = new KeyCodeCombination(KeyCode.DIGIT1, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabTwoKeyComb = new KeyCodeCombination(KeyCode.DIGIT2, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabThreeKeyComb = new KeyCodeCombination(KeyCode.DIGIT3, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFourKeyComb = new KeyCodeCombination(KeyCode.DIGIT4, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFiveKeyComb = new KeyCodeCombination(KeyCode.DIGIT5, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSixKeyComb = new KeyCodeCombination(KeyCode.DIGIT6, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSevenKeyComb = new KeyCodeCombination(KeyCode.DIGIT7, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabEightKeyComb = new KeyCodeCombination(KeyCode.DIGIT8, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabNineKeyComb = new KeyCodeCombination(KeyCode.DIGIT9, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabOneKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD1, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabTwoKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD2, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabThreeKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD3, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFourKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD4, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFiveKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD5, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSixKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD6, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSevenKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD7, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabEightKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD8, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabNineKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD9, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});

                public void handle(KeyEvent keyEvent) {
                    if (this.adjustKeyComb.match(keyEvent) && !CoordTrans.this.adjustmentButton.isDisabled()) {
                        CoordTrans.this.adjustmentButton.fire();
                        keyEvent.consume();
                    } else if (tabPane.getSelectionModel().getSelectedItem() != null && (this.tabOneKeyComb.match(keyEvent) || this.tabTwoKeyComb.match(keyEvent) || this.tabThreeKeyComb.match(keyEvent) || this.tabFourKeyComb.match(keyEvent) || this.tabFiveKeyComb.match(keyEvent) || this.tabSixKeyComb.match(keyEvent) || this.tabSevenKeyComb.match(keyEvent) || this.tabEightKeyComb.match(keyEvent) || this.tabNineKeyComb.match(keyEvent) || this.tabOneKeyCombNum.match(keyEvent) || this.tabTwoKeyCombNum.match(keyEvent) || this.tabThreeKeyCombNum.match(keyEvent) || this.tabFourKeyCombNum.match(keyEvent) || this.tabFiveKeyCombNum.match(keyEvent) || this.tabSixKeyCombNum.match(keyEvent) || this.tabSevenKeyCombNum.match(keyEvent) || this.tabEightKeyCombNum.match(keyEvent) || this.tabNineKeyCombNum.match(keyEvent))) {
                        int size = tabPane.getTabs().size();
                        if ((this.tabOneKeyComb.match(keyEvent) || this.tabOneKeyCombNum.match(keyEvent)) && size > 0) {
                            tabPane.getSelectionModel().clearAndSelect(0);
                        } else if ((this.tabTwoKeyComb.match(keyEvent) || this.tabTwoKeyCombNum.match(keyEvent)) && size > 1) {
                            tabPane.getSelectionModel().clearAndSelect(1);
                        } else if ((this.tabThreeKeyComb.match(keyEvent) || this.tabThreeKeyCombNum.match(keyEvent)) && size > 2) {
                            tabPane.getSelectionModel().clearAndSelect(2);
                        } else if ((this.tabFourKeyComb.match(keyEvent) || this.tabFourKeyCombNum.match(keyEvent)) && size > 3) {
                            tabPane.getSelectionModel().clearAndSelect(3);
                        } else if ((this.tabFiveKeyComb.match(keyEvent) || this.tabFiveKeyCombNum.match(keyEvent)) && size > 4) {
                            tabPane.getSelectionModel().clearAndSelect(4);
                        } else if ((this.tabSixKeyComb.match(keyEvent) || this.tabSixKeyCombNum.match(keyEvent)) && size > 5) {
                            tabPane.getSelectionModel().clearAndSelect(5);
                        } else if ((this.tabSevenKeyComb.match(keyEvent) || this.tabSevenKeyCombNum.match(keyEvent)) && size > 6) {
                            tabPane.getSelectionModel().clearAndSelect(6);
                        } else if ((this.tabEightKeyComb.match(keyEvent) || this.tabEightKeyCombNum.match(keyEvent)) && size > 7) {
                            tabPane.getSelectionModel().clearAndSelect(7);
                        } else if ((this.tabNineKeyComb.match(keyEvent) || this.tabNineKeyCombNum.match(keyEvent)) && size > 8) {
                            tabPane.getSelectionModel().clearAndSelect(8);
                        }
                        keyEvent.consume();
                    }
                }
            });
            try {
                URL cssURL = null;
                cssURL = JAG3D.class.getClassLoader().getResource("css/");
                if (cssURL != null && Files.exists(Paths.get((cssURL = cssURL.toURI().resolve("coordtrans.css").toURL()).toURI()), new LinkOption[0])) {
                    scene.getStylesheets().add((Object)cssURL.toExternalForm());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                primaryStage.getIcons().addAll((Object[])new Image[]{ImageUtils.getImage("CoordTrans_16x16.png"), ImageUtils.getImage("CoordTrans_32x32.png"), ImageUtils.getImage("CoordTrans_64x64.png")});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            primaryStage.setScene(scene);
            CoordTrans.setTitle(null);
            primaryStage.show();
            primaryStage.toFront();
            this.setHostServices();
            this.setStageToDialogs(primaryStage);
            TransformationAdjustment adjustment = treeBuilder.getTransformationAdjustment();
            adjustment.addTransformationChangeListener(menuBuilder);
            adjustment.addTransformationChangeListener(treeBuilder);
            adjustment.addTransformationChangeListener(UIRestrictionPaneBuilder.getInstance());
            adjustment.addTransformationChangeListener(UIInterpolationPaneBuilder.getInstance());
            adjustment.addTransformationChangeListener(UIParameterTableBuilder.getInstance());
            adjustment.addTransformationChangeListener(UIHomologousFramePositionPairTableBuilder.getInstance());
            adjustment.addTransformationChangeListener(UIFramePositionPairTableBuilder.getInstance());
            adjustment.addTransformationChangeListener(new AdjustmentTransformationChangedListener());
        } else {
            primaryStage.show();
            primaryStage.toFront();
        }
    }

    public static void main(String[] args) {
        try {
            Logger[] loggers;
            Logger[] loggerArray = loggers = new Logger[]{Logger.getLogger("hsqldb.db"), Logger.getLogger("com.github.fommil.netlib.LAPACK"), Logger.getLogger("com.github.fommil.netlib.BLAS")};
            int n = loggers.length;
            int n2 = 0;
            while (n2 < n) {
                Logger logger = loggerArray[n2];
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.OFF);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Application.launch(CoordTrans.class, (String[])args);
    }

    private class AdjustmentTransformationChangedListener
    implements TransformationChangeListener {
        private AdjustmentTransformationChangedListener() {
        }

        @Override
        public void transformationChanged(TransformationEvent evt) {
            CoordTrans.this.adjustmentButton.setDisable(evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_REMOVED);
        }
    }
}

