/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.restriction;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.restriction.EulerAxisType;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;
import org.applied_geodesy.adjustment.transformation.restriction.RestrictionType;

public class ShearAngleRestriction
extends Restriction {
    private ObservableList<UnknownParameter> shearParameters = FXCollections.observableArrayList();
    private ObjectProperty<EulerAxisType> eulerAxisType = new SimpleObjectProperty((Object)this, "eulerAxisType");

    public ShearAngleRestriction() {
        this(false, EulerAxisType.Z_AXIS, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_12, (boolean)Boolean.FALSE, Boolean.FALSE), new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_13, (boolean)Boolean.FALSE, Boolean.FALSE), new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_22, (boolean)Boolean.FALSE, Boolean.FALSE), new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_23, (boolean)Boolean.FALSE, Boolean.FALSE), new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_33, (boolean)Boolean.FALSE, Boolean.FALSE), null);
    }

    public ShearAngleRestriction(boolean indispensable, EulerAxisType eulerAxisType, UnknownParameter s12, UnknownParameter s13, UnknownParameter s22, UnknownParameter s23, UnknownParameter s33, UnknownParameter regressand) {
        super(RestrictionType.SHEAR_ANGLE_EXTRACTION, indispensable);
        this.setRegressand(regressand);
        this.eulerAxisType.set((Object)eulerAxisType);
        this.shearParameters.setAll((Object[])new UnknownParameter[]{s12, s13, s22, s23, s33});
    }

    public ObservableList<UnknownParameter> getShearParameters() {
        return this.shearParameters;
    }

    public EulerAxisType getEulerAngleAxisType() {
        return (EulerAxisType)((Object)this.eulerAxisType.get());
    }

    public void setEulerAxisType(EulerAxisType eulerAxisType) {
        this.eulerAxisType.set((Object)eulerAxisType);
    }

    public ObjectProperty<EulerAxisType> eulerAxisTypeProperty() {
        return this.eulerAxisType;
    }

    @Override
    public double getMisclosure() {
        double s12 = ((UnknownParameter)this.shearParameters.get(0)).getValue();
        double s13 = ((UnknownParameter)this.shearParameters.get(1)).getValue();
        double s22 = ((UnknownParameter)this.shearParameters.get(2)).getValue();
        double s23 = ((UnknownParameter)this.shearParameters.get(3)).getValue();
        double s33 = ((UnknownParameter)this.shearParameters.get(4)).getValue();
        EulerAxisType eulerAxisType = (EulerAxisType)((Object)this.eulerAxisType.get());
        double c = MathExtension.MOD(((UnknownParameter)this.regressand.get()).getValue(), Math.PI);
        double angle = 0.0;
        switch (eulerAxisType) {
            case X_AXIS: {
                angle = MathExtension.MOD(Math.atan2(-s23, s33), Math.PI);
                break;
            }
            case Y_AXIS: {
                angle = MathExtension.MOD(Math.hypot(s23, s33) > 0.0 ? Math.atan2(-s13, Math.hypot(s23, s33)) : 0.0, Math.PI);
                break;
            }
            case Z_AXIS: {
                angle = MathExtension.MOD(Math.atan2(-s12, s22), Math.PI);
                break;
            }
            default: {
                throw new IllegalArgumentException("Error, unsupported angle type " + String.valueOf((Object)this.getEulerAngleAxisType()) + "!");
            }
        }
        return MathExtension.MOD(angle - c, Math.PI);
    }

    @Override
    public void transposedJacobianElements(Matrix JrT) {
        int rowIndex = this.getRow();
        UnknownParameter S12 = (UnknownParameter)this.shearParameters.get(0);
        UnknownParameter S13 = (UnknownParameter)this.shearParameters.get(1);
        UnknownParameter S22 = (UnknownParameter)this.shearParameters.get(2);
        UnknownParameter S23 = (UnknownParameter)this.shearParameters.get(3);
        UnknownParameter S33 = (UnknownParameter)this.shearParameters.get(4);
        double s12 = S12.getValue();
        double s13 = S13.getValue();
        double s22 = S22.getValue();
        double s23 = S23.getValue();
        double s33 = S33.getValue();
        EulerAxisType eulerAxisType = (EulerAxisType)((Object)this.eulerAxisType.get());
        switch (eulerAxisType) {
            case X_AXIS: {
                int columnIndex;
                double dX = s33 * s33 + s23 * s23;
                if (S23.getColumn() >= 0 && dX > 0.0) {
                    columnIndex = S23.getColumn();
                    JrT.add(columnIndex, rowIndex, -s33 / (s33 * s33 + s23 * s23));
                }
                if (S33.getColumn() < 0 || !(dX > 0.0)) break;
                columnIndex = S33.getColumn();
                JrT.add(columnIndex, rowIndex, s23 / (s33 * s33 + s23 * s23));
                break;
            }
            case Y_AXIS: {
                int columnIndex;
                double dY1 = Math.hypot(s23, s33);
                double dY2 = s23 * s23 + s33 * s33 + s13 * s13;
                if (S13.getColumn() >= 0 && dY2 > 0.0) {
                    columnIndex = S13.getColumn();
                    JrT.add(columnIndex, rowIndex, -dY1 / dY2);
                }
                if (S23.getColumn() >= 0 && dY1 > 0.0 && dY2 > 0.0) {
                    columnIndex = S23.getColumn();
                    JrT.add(columnIndex, rowIndex, s13 / dY1 * s23 / dY2);
                }
                if (S33.getColumn() < 0 || !(dY1 > 0.0) || !(dY2 > 0.0)) break;
                columnIndex = S33.getColumn();
                JrT.add(columnIndex, rowIndex, s13 / dY1 * s33 / dY2);
                break;
            }
            case Z_AXIS: {
                int columnIndex;
                double dZ = s22 * s22 + s12 * s12;
                if (S12.getColumn() >= 0 && dZ > 0.0) {
                    columnIndex = S12.getColumn();
                    JrT.add(columnIndex, rowIndex, -s22 / dZ);
                }
                if (S22.getColumn() < 0) break;
                columnIndex = S22.getColumn();
                JrT.add(columnIndex, rowIndex, s12 / dZ);
            }
        }
        if (((UnknownParameter)this.regressand.get()).getColumn() >= 0) {
            JrT.add(((UnknownParameter)this.regressand.get()).getColumn(), rowIndex, -1.0);
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !(object instanceof UnknownParameter)) {
            return false;
        }
        return this.regressand.get() == object || this.shearParameters.contains(object);
    }

    @Override
    public String toLaTex() {
        return null;
    }
}

