/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.restriction;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.restriction.EulerAxisType;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;
import org.applied_geodesy.adjustment.transformation.restriction.RestrictionType;

public class QuaternionEulerAngleRestriction
extends Restriction {
    private ObservableList<UnknownParameter> quaternion = FXCollections.observableArrayList();
    private ObjectProperty<EulerAxisType> eulerAxisType = new SimpleObjectProperty((Object)this, "eulerAxisType");

    public QuaternionEulerAngleRestriction() {
        this(false, EulerAxisType.Z_AXIS, new UnknownParameter(ParameterType.QUATERNION_Q0, (boolean)Boolean.FALSE, Boolean.FALSE), new UnknownParameter(ParameterType.QUATERNION_Q1, (boolean)Boolean.FALSE, Boolean.FALSE), new UnknownParameter(ParameterType.QUATERNION_Q2, (boolean)Boolean.FALSE, Boolean.FALSE), new UnknownParameter(ParameterType.QUATERNION_Q3, (boolean)Boolean.FALSE, Boolean.FALSE), null);
    }

    public QuaternionEulerAngleRestriction(boolean indispensable, EulerAxisType eulerAxisType, UnknownParameter q0, UnknownParameter q1, UnknownParameter q2, UnknownParameter q3, UnknownParameter regressand) {
        super(RestrictionType.QUATERNION_EULER_ANGLE, indispensable);
        this.setRegressand(regressand);
        this.eulerAxisType.set((Object)eulerAxisType);
        this.quaternion.setAll((Object[])new UnknownParameter[]{q0, q1, q2, q3});
    }

    public ObservableList<UnknownParameter> getQuaternion() {
        return this.quaternion;
    }

    public EulerAxisType getEulerAngleAxisType() {
        return (EulerAxisType)((Object)this.eulerAxisType.get());
    }

    public void setEulerAxisType(EulerAxisType eulerAxisType) {
        this.eulerAxisType.set((Object)eulerAxisType);
    }

    public ObjectProperty<EulerAxisType> eulerAxisTypeProperty() {
        return this.eulerAxisType;
    }

    @Override
    public double getMisclosure() {
        double angle;
        double c;
        block11: {
            double cy;
            EulerAxisType eulerAxisType;
            double r22;
            double r21;
            double r13;
            block10: {
                double q0 = ((UnknownParameter)this.quaternion.get(0)).getValue();
                double q1 = ((UnknownParameter)this.quaternion.get(1)).getValue();
                double q2 = ((UnknownParameter)this.quaternion.get(2)).getValue();
                double q3 = ((UnknownParameter)this.quaternion.get(3)).getValue();
                double r11 = 2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1;
                double r12 = 2.0 * (q1 * q2 - q0 * q3);
                r13 = 2.0 * (q1 * q3 + q0 * q2);
                r21 = 2.0 * (q1 * q2 + q0 * q3);
                r22 = 2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2;
                double r23 = 2.0 * (q2 * q3 - q0 * q1);
                double r33 = 2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3;
                eulerAxisType = (EulerAxisType)((Object)this.eulerAxisType.get());
                c = MathExtension.MOD(((UnknownParameter)this.regressand.get()).getValue(), Math.PI * 2);
                angle = 0.0;
                cy = Math.hypot(r33, r23);
                if (!(cy > 16.0 * Constant.EPS)) break block10;
                switch (eulerAxisType) {
                    case X_AXIS: {
                        angle = MathExtension.MOD(-Math.atan2(r23, r33), Math.PI * 2);
                        break block11;
                    }
                    case Y_AXIS: {
                        angle = MathExtension.MOD(-Math.atan2(-r13, cy), Math.PI * 2);
                        break block11;
                    }
                    case Z_AXIS: {
                        angle = MathExtension.MOD(-Math.atan2(r12, r11), Math.PI * 2);
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Error, unsupported angle type " + String.valueOf((Object)this.getEulerAngleAxisType()) + "!");
                    }
                }
            }
            switch (eulerAxisType) {
                case X_AXIS: {
                    angle = 0.0;
                    break;
                }
                case Y_AXIS: {
                    angle = MathExtension.MOD(-Math.atan2(-r13, cy), Math.PI * 2);
                    break;
                }
                case Z_AXIS: {
                    angle = MathExtension.MOD(-Math.atan2(-r21, r22), Math.PI * 2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Error, unsupported angle type " + String.valueOf((Object)this.getEulerAngleAxisType()) + "!");
                }
            }
        }
        return MathExtension.MOD(angle - c, Math.PI * 2);
    }

    @Override
    public void transposedJacobianElements(Matrix JrT) {
        int rowIndex = this.getRow();
        UnknownParameter Q0 = (UnknownParameter)this.quaternion.get(0);
        UnknownParameter Q1 = (UnknownParameter)this.quaternion.get(1);
        UnknownParameter Q2 = (UnknownParameter)this.quaternion.get(2);
        UnknownParameter Q3 = (UnknownParameter)this.quaternion.get(3);
        double q0 = Q0.getValue();
        double q1 = Q1.getValue();
        double q2 = Q2.getValue();
        double q3 = Q3.getValue();
        double r11 = 2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1;
        double r12 = 2.0 * (q1 * q2 - q0 * q3);
        double r13 = 2.0 * (q1 * q3 + q0 * q2);
        double r21 = 2.0 * (q1 * q2 + q0 * q3);
        double r22 = 2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2;
        double r23 = 2.0 * (q2 * q3 - q0 * q1);
        double r33 = 2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3;
        EulerAxisType eulerAxisType = (EulerAxisType)((Object)this.eulerAxisType.get());
        double cy = Math.hypot(r33, r23);
        switch (eulerAxisType) {
            case X_AXIS: {
                int columnIndex;
                if (Q0.getColumn() >= 0) {
                    columnIndex = Q0.getColumn();
                    if (cy > 16.0 * Constant.EPS) {
                        JrT.add(columnIndex, rowIndex, 2.0 * (q1 * r33 + 2.0 * r23 * q0) / (r33 * r33 + r23 * r23));
                    } else {
                        JrT.add(columnIndex, rowIndex, 0.0);
                    }
                }
                if (Q1.getColumn() >= 0) {
                    columnIndex = Q1.getColumn();
                    if (cy > 16.0 * Constant.EPS) {
                        JrT.add(columnIndex, rowIndex, 2.0 * q0 * r33 / (r33 * r33 + r23 * r23));
                    } else {
                        JrT.add(columnIndex, rowIndex, 0.0);
                    }
                }
                if (Q2.getColumn() >= 0) {
                    columnIndex = Q2.getColumn();
                    if (cy > 16.0 * Constant.EPS) {
                        JrT.add(columnIndex, rowIndex, -2.0 * q3 * r33 / (r33 * r33 + r23 * r23));
                    } else {
                        JrT.add(columnIndex, rowIndex, 0.0);
                    }
                }
                if (Q3.getColumn() < 0) break;
                columnIndex = Q3.getColumn();
                if (cy > 16.0 * Constant.EPS) {
                    JrT.add(columnIndex, rowIndex, -2.0 * (q2 * r33 - 2.0 * r23 * q3) / (r33 * r33 + r23 * r23));
                    break;
                }
                JrT.add(columnIndex, rowIndex, 0.0);
                break;
            }
            case Y_AXIS: {
                int columnIndex;
                double tmp = cy * (r13 * r13 + r23 * r23 + r33 * r33);
                if (Q0.getColumn() >= 0) {
                    columnIndex = Q0.getColumn();
                    JrT.add(columnIndex, rowIndex, 2.0 * (q2 * r23 * r23 + q1 * r13 * r23 + q2 * r33 * r33 - 2.0 * q0 * r13 * r33) / tmp);
                }
                if (Q1.getColumn() >= 0) {
                    columnIndex = Q1.getColumn();
                    JrT.add(columnIndex, rowIndex, 2.0 * (q3 * r23 * r23 + q0 * r13 * r23 + q3 * r33 * r33) / tmp);
                }
                if (Q2.getColumn() >= 0) {
                    columnIndex = Q2.getColumn();
                    JrT.add(columnIndex, rowIndex, 2.0 * (q0 * r23 * r23 - q3 * r13 * r23 + q0 * r33 * r33) / tmp);
                }
                if (Q3.getColumn() < 0) break;
                columnIndex = Q3.getColumn();
                JrT.add(columnIndex, rowIndex, 2.0 * (q1 * r23 * r23 - q2 * r13 * r23 + q1 * r33 * r33 - 2.0 * q3 * r13 * r33) / tmp);
                break;
            }
            case Z_AXIS: {
                int columnIndex;
                if (Q0.getColumn() >= 0) {
                    columnIndex = Q0.getColumn();
                    if (cy > 16.0 * Constant.EPS) {
                        JrT.add(columnIndex, rowIndex, 2.0 * (q3 * r11 + 2.0 * r12 * q0) / (r11 * r11 + r12 * r12));
                    } else {
                        JrT.add(columnIndex, rowIndex, (2.0 * q3 * r22 - 4.0 * q0 * r21) / (r21 * r21 + r22 * r22));
                    }
                }
                if (Q1.getColumn() >= 0) {
                    columnIndex = Q1.getColumn();
                    if (cy > 16.0 * Constant.EPS) {
                        JrT.add(columnIndex, rowIndex, -2.0 * (q2 * r11 - 2.0 * r12 * q1) / (r11 * r11 + r12 * r12));
                    } else {
                        JrT.add(columnIndex, rowIndex, 2.0 * q2 * r22 / (r21 * r21 + r22 * r22));
                    }
                }
                if (Q2.getColumn() >= 0) {
                    columnIndex = Q2.getColumn();
                    if (cy > 16.0 * Constant.EPS) {
                        JrT.add(columnIndex, rowIndex, -2.0 * q1 * r11 / (r11 * r11 + r12 * r12));
                    } else {
                        JrT.add(columnIndex, rowIndex, (2.0 * q1 * r22 - 4.0 * q2 * r21) / (r21 * r21 + r22 * r22));
                    }
                }
                if (Q3.getColumn() < 0) break;
                columnIndex = Q3.getColumn();
                if (cy > 16.0 * Constant.EPS) {
                    JrT.add(columnIndex, rowIndex, 2.0 * q0 * r11 / (r11 * r11 + r12 * r12));
                    break;
                }
                JrT.add(columnIndex, rowIndex, 2.0 * q0 * r22 / (r21 * r21 + r22 * r22));
            }
        }
        if (((UnknownParameter)this.regressand.get()).getColumn() >= 0) {
            JrT.add(((UnknownParameter)this.regressand.get()).getColumn(), rowIndex, -1.0);
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !(object instanceof UnknownParameter)) {
            return false;
        }
        return this.regressand.get() == object || this.quaternion.contains(object);
    }

    @Override
    public String toLaTex() {
        return null;
    }
}

