/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.restriction;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;
import org.applied_geodesy.adjustment.transformation.restriction.RestrictionType;

public class InverseTangentRestriction
extends Restriction {
    private ObjectProperty<UnknownParameter> regressorA = new SimpleObjectProperty((Object)this, "regressorA");
    private ObjectProperty<UnknownParameter> regressorB = new SimpleObjectProperty((Object)this, "regressorB");

    public InverseTangentRestriction(boolean indispensable, UnknownParameter regressorsA, UnknownParameter regressorsB, UnknownParameter regressand) {
        super(RestrictionType.INVERSE_TANGENT_TWO, indispensable);
        this.setRegressand(regressand);
        this.setRegressorA(regressorsA);
        this.setRegressorB(regressorsB);
    }

    public void setRegressorA(UnknownParameter regressorA) {
        this.regressorA.set((Object)regressorA);
    }

    public UnknownParameter getRegressorA() {
        return (UnknownParameter)this.regressorA.get();
    }

    public ObjectProperty<UnknownParameter> regressorAProperty() {
        return this.regressorA;
    }

    public void setRegressorB(UnknownParameter regressorB) {
        this.regressorB.set((Object)regressorB);
    }

    public UnknownParameter getRegressorB() {
        return (UnknownParameter)this.regressorB.get();
    }

    public ObjectProperty<UnknownParameter> regressorBProperty() {
        return this.regressorB;
    }

    @Override
    public double getMisclosure() {
        double a = ((UnknownParameter)this.regressorA.get()).getValue();
        double b = ((UnknownParameter)this.regressorB.get()).getValue();
        double c = MathExtension.MOD(((UnknownParameter)this.regressand.get()).getValue(), Math.PI * 2);
        return MathExtension.MOD(Math.atan2(a, b), Math.PI * 2) - c;
    }

    @Override
    public void transposedJacobianElements(Matrix JrT) {
        int rowIndex = this.getRow();
        double a = ((UnknownParameter)this.regressorA.get()).getValue();
        double b = ((UnknownParameter)this.regressorB.get()).getValue();
        double ab = a * a + b * b;
        if (((UnknownParameter)this.regressorA.get()).getColumn() >= 0) {
            JrT.add(((UnknownParameter)this.regressorA.get()).getColumn(), rowIndex, -b / ab);
        }
        if (((UnknownParameter)this.regressorB.get()).getColumn() >= 0) {
            JrT.add(((UnknownParameter)this.regressorB.get()).getColumn(), rowIndex, a / ab);
        }
        if (((UnknownParameter)this.regressand.get()).getColumn() >= 0) {
            JrT.add(((UnknownParameter)this.regressand.get()).getColumn(), rowIndex, -1.0);
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !(object instanceof UnknownParameter)) {
            return false;
        }
        return this.regressand.get() == object || this.regressorA.get() == object || this.regressorB.get() == object;
    }

    @Override
    public String toLaTex() {
        return "$\\arctan_2 \\left( y,x \\right) = c$";
    }
}

