/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.restriction;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;
import org.applied_geodesy.adjustment.transformation.restriction.RestrictionType;

public class AverageRestriction
extends Restriction {
    private ObservableList<UnknownParameter> regressors = FXCollections.observableArrayList();

    public AverageRestriction() {
        this(false, new ArrayList<UnknownParameter>(0), null);
    }

    public AverageRestriction(boolean indispensable, List<UnknownParameter> regressors, UnknownParameter regressand) {
        super(RestrictionType.AVERAGE, indispensable);
        this.setRegressand(regressand);
        this.regressors.setAll(regressors);
    }

    public ObservableList<UnknownParameter> getRegressors() {
        return this.regressors;
    }

    @Override
    public double getMisclosure() {
        double sum = 0.0;
        double length = this.regressors.size();
        int i = 0;
        while ((double)i < length) {
            sum += ((UnknownParameter)this.regressors.get(i)).getValue();
            ++i;
        }
        return sum / length - ((UnknownParameter)this.regressand.get()).getValue();
    }

    @Override
    public void transposedJacobianElements(Matrix JrT) {
        int rowIndex = this.getRow();
        double length = this.regressors.size();
        int i = 0;
        while ((double)i < length) {
            if (((UnknownParameter)this.regressors.get(i)).getColumn() >= 0) {
                JrT.add(((UnknownParameter)this.regressors.get(i)).getColumn(), rowIndex, 1.0 / length);
            }
            ++i;
        }
        if (((UnknownParameter)this.regressand.get()).getColumn() >= 0) {
            JrT.add(((UnknownParameter)this.regressand.get()).getColumn(), rowIndex, -1.0);
        }
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !(object instanceof UnknownParameter)) {
            return false;
        }
        return this.regressand.get() == object || this.regressors.contains(object);
    }

    @Override
    public String toLaTex() {
        return "$\\frac{1}{n} \\left(a_1 + a_i + \\cdots + a_n\\right) = c$";
    }
}

