/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.point;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.applied_geodesy.adjustment.transformation.point.Position;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;

public class SimplePositionPair
extends PositionPair<Position, Position>
implements Iterable<Position> {
    public SimplePositionPair(String name, double zSrc, double zTrg) {
        this(name, new Position(zSrc), new Position(zTrg));
    }

    public SimplePositionPair(String name, double xSrc, double ySrc, double xTrg, double yTrg) {
        this(name, new Position(xSrc, ySrc), new Position(xTrg, yTrg));
    }

    public SimplePositionPair(String name, double xSrc, double ySrc, double zSrc, double xTrg, double yTrg, double zTrg) {
        this(name, new Position(xSrc, ySrc, zSrc), new Position(xTrg, yTrg, zTrg));
    }

    private SimplePositionPair(String name, Position sourcePosition, Position targetPosition) {
        super(name, sourcePosition, targetPosition);
    }

    @Override
    public Iterator<Position> iterator() {
        return new Iterator<Position>(){
            Position currentPosition;
            {
                this.currentPosition = (Position)SimplePositionPair.this.getSourceSystemPosition();
            }

            @Override
            public boolean hasNext() {
                return this.currentPosition != null;
            }

            @Override
            public Position next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.currentPosition == SimplePositionPair.this.getSourceSystemPosition()) {
                    this.currentPosition = (Position)SimplePositionPair.this.getTargetSystemPosition();
                    return (Position)SimplePositionPair.this.getSourceSystemPosition();
                }
                if (this.currentPosition == SimplePositionPair.this.getTargetSystemPosition()) {
                    this.currentPosition = null;
                    return (Position)SimplePositionPair.this.getTargetSystemPosition();
                }
                return null;
            }
        };
    }
}

