/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.point;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import org.applied_geodesy.adjustment.transformation.point.Pairable;
import org.applied_geodesy.adjustment.transformation.point.Positionable;

public abstract class PositionPair<T1 extends Positionable, T2 extends Positionable>
implements Pairable<T1, T2> {
    private ObjectProperty<String> name = new SimpleObjectProperty((Object)this, "name", (Object)"");
    private ObjectProperty<Boolean> enable = new SimpleObjectProperty((Object)this, "enable", (Object)Boolean.TRUE);
    private ReadOnlyObjectProperty<T1> sourcePosition;
    private ReadOnlyObjectProperty<T2> targetPosition;

    PositionPair(String name, T1 sourcePosition, T2 targetPosition) {
        if (sourcePosition.getDimension() != targetPosition.getDimension()) {
            throw new IllegalArgumentException("Error, cannot create point pair from points having different dimensions " + sourcePosition.getDimension() + " vs. " + targetPosition.getDimension());
        }
        this.sourcePosition = new ReadOnlyObjectWrapper((Object)this, "sourcePosition", sourcePosition);
        this.targetPosition = new ReadOnlyObjectWrapper((Object)this, "targetPosition", targetPosition);
        this.setName(name);
    }

    @Override
    public ObservableObjectValue<T1> sourceSystemPositionProperty() {
        return this.sourcePosition;
    }

    @Override
    public ObservableObjectValue<T2> targetSystemPositionProperty() {
        return this.targetPosition;
    }

    @Override
    public T1 getSourceSystemPosition() {
        return (T1)((Positionable)this.sourcePosition.get());
    }

    @Override
    public T2 getTargetSystemPosition() {
        return (T2)((Positionable)this.targetPosition.get());
    }

    public ObservableObjectValue<Double> sourceXProperty() {
        return ((Positionable)this.sourcePosition.get()).xProperty();
    }

    public ObservableObjectValue<Double> sourceYProperty() {
        return ((Positionable)this.sourcePosition.get()).yProperty();
    }

    public ObservableObjectValue<Double> sourceZProperty() {
        return ((Positionable)this.sourcePosition.get()).zProperty();
    }

    public ObservableObjectValue<Double> targetXProperty() {
        return ((Positionable)this.targetPosition.get()).xProperty();
    }

    public ObservableObjectValue<Double> targetYProperty() {
        return ((Positionable)this.targetPosition.get()).yProperty();
    }

    public ObservableObjectValue<Double> targetZProperty() {
        return ((Positionable)this.targetPosition.get()).zProperty();
    }

    @Override
    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public ObjectProperty<String> nameProperty() {
        return this.name;
    }

    @Override
    public boolean equalsCoordinateComponents(PositionPair<?, ?> positionPair) {
        return this.getSourceSystemPosition().equalsPosition((Positionable)positionPair.getSourceSystemPosition()) && this.getTargetSystemPosition().equalsPosition((Positionable)positionPair.getTargetSystemPosition());
    }

    public boolean isEnable() {
        return (Boolean)this.enable.get();
    }

    public void setEnable(boolean enable) {
        this.enable.set((Object)enable);
    }

    public ObjectProperty<Boolean> enableProperty() {
        return this.enable;
    }

    public void reset() {
    }

    public String toString() {
        return "PositionPair {\n\t[ " + ((Positionable)this.sourcePosition.get()).getX() + " / " + ((Positionable)this.sourcePosition.get()).getY() + " / " + ((Positionable)this.sourcePosition.get()).getZ() + " ]\t[ " + ((Positionable)this.targetPosition.get()).getX() + " / " + ((Positionable)this.targetPosition.get()).getY() + " / " + ((Positionable)this.targetPosition.get()).getZ() + " ]}";
    }
}

