/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.point;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import org.applied_geodesy.adjustment.transformation.point.Positionable;

public class Position
implements Positionable {
    private static int ID_CNT = 0;
    private ReadOnlyObjectProperty<Integer> id;
    private ObjectProperty<Double> x = new SimpleObjectProperty((Object)this, "x", (Object)0.0);
    private ObjectProperty<Double> y = new SimpleObjectProperty((Object)this, "y", (Object)0.0);
    private ObjectProperty<Double> z = new SimpleObjectProperty((Object)this, "z", (Object)0.0);
    private ReadOnlyObjectProperty<Integer> dimension;

    Position(Position position) {
        this(position.getX(), position.getY(), position.getZ(), position.getDimension());
    }

    Position(double z) {
        this(0.0, 0.0, z, 1);
    }

    Position(double x, double y) {
        this(x, y, 0.0, 2);
    }

    Position(double x, double y, double z) {
        this(x, y, z, 3);
    }

    private Position(double x, double y, double z, int dimension) {
        this.id = new ReadOnlyObjectWrapper((Object)this, "id", (Object)ID_CNT++);
        this.dimension = new ReadOnlyObjectWrapper((Object)this, "dimension", (Object)dimension);
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public final int getId() {
        return (Integer)this.id.get();
    }

    public ReadOnlyObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Override
    public int getDimension() {
        return (Integer)this.dimension.get();
    }

    public ReadOnlyObjectProperty<Integer> dimensionProperty() {
        return this.dimension;
    }

    @Override
    public double getX() {
        return (Double)this.x.get();
    }

    public void setX(double x) {
        this.x.set((Object)x);
    }

    @Override
    public ObservableObjectValue<Double> xProperty() {
        return this.x;
    }

    @Override
    public double getY() {
        return (Double)this.y.get();
    }

    public void setY(double y) {
        this.y.set((Object)y);
    }

    @Override
    public ObservableObjectValue<Double> yProperty() {
        return this.y;
    }

    @Override
    public double getZ() {
        return (Double)this.z.get();
    }

    public void setZ(double z) {
        this.z.set((Object)z);
    }

    @Override
    public ObservableObjectValue<Double> zProperty() {
        return this.z;
    }

    public void reset() {
    }

    public String toString() {
        return "Point#" + String.valueOf(this.id.get()) + " [x=" + String.valueOf(this.x.get()) + ", y=" + String.valueOf(this.y.get()) + ", z=" + String.valueOf(this.z.get()) + ", dimension=" + String.valueOf(this.dimension.get()) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimension == null ? 0 : ((Integer)this.dimension.get()).hashCode());
        result = 31 * result + (this.id == null ? 0 : ((Integer)this.id.get()).hashCode());
        result = 31 * result + (this.x == null ? 0 : ((Double)this.x.get()).hashCode());
        result = 31 * result + (this.y == null ? 0 : ((Double)this.y.get()).hashCode());
        result = 31 * result + (this.z == null ? 0 : ((Double)this.z.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        if (this.getId() != other.getId()) {
            return false;
        }
        return this.equalsPosition(other);
    }
}

