/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.point;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePosition;
import org.applied_geodesy.adjustment.transformation.point.Position;

public class ObservedFramePosition
extends Position
implements DispersionablePosition {
    private ObjectProperty<Matrix> dispersionApriori = new SimpleObjectProperty((Object)this, "dispersionApriori");

    public ObservedFramePosition(double z0) throws IllegalArgumentException {
        this(z0, MathExtension.identity(1));
    }

    public ObservedFramePosition(double z0, Matrix dispersion) throws IllegalArgumentException {
        super(z0);
        this.setDispersionApriori(dispersion);
    }

    public ObservedFramePosition(double x0, double y0) throws IllegalArgumentException {
        this(x0, y0, MathExtension.identity(2));
    }

    public ObservedFramePosition(double x0, double y0, Matrix dispersion) throws IllegalArgumentException {
        super(x0, y0);
        this.setDispersionApriori(dispersion);
    }

    public ObservedFramePosition(double x0, double y0, double z0) throws IllegalArgumentException {
        this(x0, y0, z0, MathExtension.identity(3));
    }

    public ObservedFramePosition(double x0, double y0, double z0, Matrix dispersion) throws IllegalArgumentException {
        super(x0, y0, z0);
        this.setDispersionApriori(dispersion);
    }

    @Override
    public ObservableObjectValue<Matrix> dispersionAprioriProperty() {
        return this.dispersionApriori;
    }

    @Override
    public Matrix getDispersionApriori() {
        return (Matrix)this.dispersionApriori.get();
    }

    @Override
    public void setDispersionApriori(Matrix dispersion) throws IllegalArgumentException {
        this.checkDispersionMatrix(dispersion);
        this.dispersionApriori.set((Object)dispersion);
    }
}

