/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.point;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.transformation.TestStatistic;
import org.applied_geodesy.adjustment.transformation.VarianceComponent;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePositionPair;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePosition;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;

public class HomologousFramePositionPair
extends PositionPair<HomologousFramePosition, HomologousFramePosition>
implements Iterable<HomologousFramePosition>,
DispersionablePositionPair<HomologousFramePosition, HomologousFramePosition> {
    private ReadOnlyObjectProperty<TestStatistic> testStatistic = new ReadOnlyObjectWrapper((Object)this, "testStatistic", (Object)new TestStatistic());
    private ObjectProperty<Double> grossErrorX = new SimpleObjectProperty((Object)this, "grossErrorX", (Object)0.0);
    private ObjectProperty<Double> grossErrorY = new SimpleObjectProperty((Object)this, "grossErrorY", (Object)0.0);
    private ObjectProperty<Double> grossErrorZ = new SimpleObjectProperty((Object)this, "grossErrorZ", (Object)0.0);
    private ObjectProperty<Double> minimalDetectableBiasX = new SimpleObjectProperty((Object)this, "minimalDetectableBiasX", (Object)0.0);
    private ObjectProperty<Double> minimalDetectableBiasY = new SimpleObjectProperty((Object)this, "minimalDetectableBiasY", (Object)0.0);
    private ObjectProperty<Double> minimalDetectableBiasZ = new SimpleObjectProperty((Object)this, "minimalDetectableBiasZ", (Object)0.0);
    private ObjectProperty<Double> maximumTolerableBiasX = new SimpleObjectProperty((Object)this, "maximumTolerableBiasX", (Object)0.0);
    private ObjectProperty<Double> maximumTolerableBiasY = new SimpleObjectProperty((Object)this, "maximumTolerableBiasY", (Object)0.0);
    private ObjectProperty<Double> maximumTolerableBiasZ = new SimpleObjectProperty((Object)this, "maximumTolerableBiasZ", (Object)0.0);
    private ReadOnlyObjectWrapper<Double> testStatisticApriori = new ReadOnlyObjectWrapper((Object)this, "testStatisticApriori", (Object)0.0);
    private ReadOnlyObjectWrapper<Double> testStatisticAposteriori = new ReadOnlyObjectWrapper((Object)this, "testStatisticAposteriori", (Object)0.0);
    private ReadOnlyObjectWrapper<Double> pValueApriori = new ReadOnlyObjectWrapper((Object)this, "pValueApriori", (Object)0.0);
    private ReadOnlyObjectWrapper<Double> pValueAposteriori = new ReadOnlyObjectWrapper((Object)this, "pValueAposteriori", (Object)0.0);
    private ObjectBinding<Boolean> significant;
    private ObjectProperty<Double> fisherQuantileApriori = new SimpleObjectProperty((Object)this, "fisherQuantileApriori", (Object)Double.MAX_VALUE);
    private ObjectProperty<Double> fisherQuantileAposteriori = new SimpleObjectProperty((Object)this, "fisherQuantileAposteriori", (Object)Double.MAX_VALUE);

    public HomologousFramePositionPair(String name, double zSrc, double zTrg) {
        this(name, new HomologousFramePosition(zSrc), new HomologousFramePosition(zTrg));
    }

    public HomologousFramePositionPair(String name, double xSrc, double ySrc, double xTrg, double yTrg) {
        this(name, new HomologousFramePosition(xSrc, ySrc), new HomologousFramePosition(xTrg, yTrg));
    }

    public HomologousFramePositionPair(String name, double xSrc, double ySrc, double zSrc, double xTrg, double yTrg, double zTrg) {
        this(name, new HomologousFramePosition(xSrc, ySrc, zSrc), new HomologousFramePosition(xTrg, yTrg, zTrg));
    }

    public HomologousFramePositionPair(String name, double zSrc, Matrix dispersionSrc, double zTrg, Matrix dispersionTrg) {
        this(name, new HomologousFramePosition(zSrc, dispersionSrc), new HomologousFramePosition(zTrg, dispersionTrg));
    }

    public HomologousFramePositionPair(String name, double xSrc, double ySrc, Matrix dispersionSrc, double xTrg, double yTrg, Matrix dispersionTrg) {
        this(name, new HomologousFramePosition(xSrc, ySrc, dispersionSrc), new HomologousFramePosition(xTrg, yTrg, dispersionTrg));
    }

    public HomologousFramePositionPair(String name, double xSrc, double ySrc, double zSrc, Matrix dispersionSrc, double xTrg, double yTrg, double zTrg, Matrix dispersionTrg) {
        this(name, new HomologousFramePosition(xSrc, ySrc, zSrc, dispersionSrc), new HomologousFramePosition(xTrg, yTrg, zTrg, dispersionTrg));
    }

    private HomologousFramePositionPair(String name, HomologousFramePosition pointSrc, HomologousFramePosition pointTrg) {
        this(name, pointSrc, pointTrg, Boolean.FALSE);
    }

    private HomologousFramePositionPair(String name, HomologousFramePosition pointSrc, HomologousFramePosition pointTrg, boolean deep) {
        super(name, !deep ? pointSrc : (pointSrc.getDimension() == 1 ? new HomologousFramePosition(pointSrc.getZ0(), pointSrc.getDispersionApriori()) : (pointSrc.getDimension() == 2 ? new HomologousFramePosition(pointSrc.getX0(), pointSrc.getY0(), pointSrc.getDispersionApriori()) : new HomologousFramePosition(pointSrc.getX0(), pointSrc.getY0(), pointSrc.getZ0(), pointSrc.getDispersionApriori()))), !deep ? pointTrg : (pointTrg.getDimension() == 1 ? new HomologousFramePosition(pointTrg.getZ0(), pointTrg.getDispersionApriori()) : (pointTrg.getDimension() == 2 ? new HomologousFramePosition(pointTrg.getX0(), pointTrg.getY0(), pointTrg.getDispersionApriori()) : new HomologousFramePosition(pointTrg.getX0(), pointTrg.getY0(), pointTrg.getZ0(), pointTrg.getDispersionApriori()))));
        this.init();
    }

    private void init() {
        ((HomologousFramePosition)this.getSourceSystemPosition()).varianceComponentProperty().bind(((TestStatistic)this.testStatistic.get()).varianceComponentProperty());
        ((HomologousFramePosition)this.getTargetSystemPosition()).varianceComponentProperty().bind(((TestStatistic)this.testStatistic.get()).varianceComponentProperty());
        this.testStatisticApriori.bind(((TestStatistic)this.testStatistic.get()).testStatisticAprioriProperty());
        this.testStatisticAposteriori.bind(((TestStatistic)this.testStatistic.get()).testStatisticAposterioriProperty());
        this.pValueApriori.bind(((TestStatistic)this.testStatistic.get()).pValueAprioriProperty());
        this.pValueAposteriori.bind(((TestStatistic)this.testStatistic.get()).pValueAposterioriProperty());
        this.significant = new ObjectBinding<Boolean>(){

            protected Boolean computeValue() {
                boolean significant;
                boolean bl = significant = (Double)HomologousFramePositionPair.this.testStatisticApriori.get() > (Double)HomologousFramePositionPair.this.fisherQuantileApriori.get();
                if (((VarianceComponent)((TestStatistic)HomologousFramePositionPair.this.testStatistic.get()).varianceComponentProperty().get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    if (!significant && !((Double)HomologousFramePositionPair.this.testStatisticAposteriori.get() > (Double)HomologousFramePositionPair.this.fisherQuantileAposteriori.get())) {
                        return false;
                    }
                    return true;
                }
                return significant;
            }
        };
    }

    public double getMinimalDetectableBiasX() {
        return (Double)this.minimalDetectableBiasX.get();
    }

    public void setMinimalDetectableBiasX(double minimalDetectableBiasX) {
        this.minimalDetectableBiasX.set((Object)minimalDetectableBiasX);
    }

    public ObjectProperty<Double> minimalDetectableBiasXProperty() {
        return this.minimalDetectableBiasX;
    }

    public double getMinimalDetectableBiasY() {
        return (Double)this.minimalDetectableBiasY.get();
    }

    public void setMinimalDetectableBiasY(double minimalDetectableBiasY) {
        this.minimalDetectableBiasY.set((Object)minimalDetectableBiasY);
    }

    public ObjectProperty<Double> minimalDetectableBiasYProperty() {
        return this.minimalDetectableBiasY;
    }

    public double getMinimalDetectableBiasZ() {
        return (Double)this.minimalDetectableBiasZ.get();
    }

    public void setMinimalDetectableBiasZ(double minimalDetectableBiasZ) {
        this.minimalDetectableBiasZ.set((Object)minimalDetectableBiasZ);
    }

    public ObjectProperty<Double> minimalDetectableBiasZProperty() {
        return this.minimalDetectableBiasZ;
    }

    public double getMaximumTolerableBiasX() {
        return (Double)this.maximumTolerableBiasX.get();
    }

    public void setMaximumTolerableBiasX(double maximumTolerableBiasX) {
        this.maximumTolerableBiasX.set((Object)maximumTolerableBiasX);
    }

    public ObjectProperty<Double> maximumTolerableBiasXProperty() {
        return this.maximumTolerableBiasX;
    }

    public double getMaximumTolerableBiasY() {
        return (Double)this.maximumTolerableBiasY.get();
    }

    public void setMaximumTolerableBiasY(double maximumTolerableBiasY) {
        this.maximumTolerableBiasY.set((Object)maximumTolerableBiasY);
    }

    public ObjectProperty<Double> maximumTolerableBiasYProperty() {
        return this.maximumTolerableBiasY;
    }

    public double getMaximumTolerableBiasZ() {
        return (Double)this.maximumTolerableBiasZ.get();
    }

    public void setMaximumTolerableBiasZ(double maximumTolerableBiasZ) {
        this.maximumTolerableBiasZ.set((Object)maximumTolerableBiasZ);
    }

    public ObjectProperty<Double> maximumTolerableBiasZProperty() {
        return this.maximumTolerableBiasZ;
    }

    public double getGrossErrorX() {
        return (Double)this.grossErrorX.get();
    }

    public void setGrossErrorX(double grossErrorX) {
        this.grossErrorX.set((Object)grossErrorX);
    }

    public ObjectProperty<Double> grossErrorXProperty() {
        return this.grossErrorX;
    }

    public double getGrossErrorY() {
        return (Double)this.grossErrorY.get();
    }

    public void setGrossErrorY(double grossErrorY) {
        this.grossErrorY.set((Object)grossErrorY);
    }

    public ObjectProperty<Double> grossErrorYProperty() {
        return this.grossErrorY;
    }

    public double getGrossErrorZ() {
        return (Double)this.grossErrorZ.get();
    }

    public void setGrossErrorZ(double grossErrorZ) {
        this.grossErrorZ.set((Object)grossErrorZ);
    }

    public ObjectProperty<Double> grossErrorZProperty() {
        return this.grossErrorZ;
    }

    public TestStatistic getTestStatistic() {
        return (TestStatistic)this.testStatistic.get();
    }

    public ReadOnlyObjectProperty<TestStatistic> testStatisticProperty() {
        return this.testStatistic;
    }

    public ReadOnlyObjectWrapper<Double> testStatisticAprioriProperty() {
        return this.testStatisticApriori;
    }

    public ReadOnlyObjectWrapper<Double> testStatisticAposterioriProperty() {
        return this.testStatisticAposteriori;
    }

    public ReadOnlyObjectWrapper<Double> pValueAprioriProperty() {
        return this.pValueApriori;
    }

    public ReadOnlyObjectWrapper<Double> pValueAposterioriProperty() {
        return this.pValueAposteriori;
    }

    public ObjectBinding<Boolean> significantProperty() {
        return this.significant;
    }

    public boolean isSignificant() {
        return (Boolean)this.significant.get();
    }

    public void setFisherQuantileApriori(double fisherQuantileApriori) {
        this.fisherQuantileApriori.set((Object)fisherQuantileApriori);
    }

    public double getFisherQuantileApriori() {
        return (Double)this.fisherQuantileApriori.get();
    }

    public ObjectProperty<Double> fisherQuantileAprioriProperty() {
        return this.fisherQuantileApriori;
    }

    public void setFisherQuantileAposteriori(double fisherQuantileAposteriori) {
        this.fisherQuantileAposteriori.set((Object)fisherQuantileAposteriori);
    }

    public double getFisherQuantileAposteriori() {
        return (Double)this.fisherQuantileAposteriori.get();
    }

    public ObjectProperty<Double> fisherQuantileAposterioriProperty() {
        return this.fisherQuantileAposteriori;
    }

    public ObservableObjectValue<Double> sourceX0Property() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).x0Property();
    }

    public ObservableObjectValue<Double> sourceY0Property() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).y0Property();
    }

    public ObservableObjectValue<Double> sourceZ0Property() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).z0Property();
    }

    public ObservableObjectValue<Double> targetX0Property() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).x0Property();
    }

    public ObservableObjectValue<Double> targetY0Property() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).y0Property();
    }

    public ObservableObjectValue<Double> targetZ0Property() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).z0Property();
    }

    public ObservableObjectValue<Double> sourceUncertaintyXProperty() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).uncertaintyXProperty();
    }

    public ObservableObjectValue<Double> sourceUncertaintyYProperty() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).uncertaintyYProperty();
    }

    public ObservableObjectValue<Double> sourceUncertaintyZProperty() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).uncertaintyZProperty();
    }

    public ObservableObjectValue<Double> targetUncertaintyXProperty() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).uncertaintyXProperty();
    }

    public ObservableObjectValue<Double> targetUncertaintyYProperty() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).uncertaintyYProperty();
    }

    public ObservableObjectValue<Double> targetUncertaintyZProperty() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).uncertaintyZProperty();
    }

    public ObservableObjectValue<Double> sourceRedundancyXProperty() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).redundancyXProperty();
    }

    public ObservableObjectValue<Double> sourceRedundancyYProperty() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).redundancyYProperty();
    }

    public ObservableObjectValue<Double> sourceRedundancyZProperty() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).redundancyZProperty();
    }

    public ObservableObjectValue<Double> targetRedundancyXProperty() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).redundancyXProperty();
    }

    public ObservableObjectValue<Double> targetRedundancyYProperty() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).redundancyYProperty();
    }

    public ObservableObjectValue<Double> targetRedundancyZProperty() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).redundancyZProperty();
    }

    public ObservableObjectValue<Double> sourceResidualXProperty() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).residualXProperty();
    }

    public ObservableObjectValue<Double> sourceResidualYProperty() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).residualYProperty();
    }

    public ObservableObjectValue<Double> sourceResidualZProperty() {
        return ((HomologousFramePosition)this.getSourceSystemPosition()).residualZProperty();
    }

    public ObservableObjectValue<Double> targetResidualXProperty() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).residualXProperty();
    }

    public ObservableObjectValue<Double> targetResidualYProperty() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).residualYProperty();
    }

    public ObservableObjectValue<Double> targetResidualZProperty() {
        return ((HomologousFramePosition)this.getTargetSystemPosition()).residualZProperty();
    }

    @Override
    public void reset() {
        super.reset();
        ((HomologousFramePosition)this.getSourceSystemPosition()).reset();
        ((HomologousFramePosition)this.getTargetSystemPosition()).reset();
        this.setGrossErrorX(0.0);
        this.setGrossErrorY(0.0);
        this.setGrossErrorZ(0.0);
        this.setMaximumTolerableBiasX(0.0);
        this.setMaximumTolerableBiasY(0.0);
        this.setMaximumTolerableBiasZ(0.0);
        this.setMinimalDetectableBiasX(0.0);
        this.setMinimalDetectableBiasY(0.0);
        this.setMinimalDetectableBiasZ(0.0);
        ((TestStatistic)this.testStatistic.get()).setFisherTestNumerator(0.0);
        ((TestStatistic)this.testStatistic.get()).setDegreeOfFreedom(0);
    }

    @Override
    public Iterator<HomologousFramePosition> iterator() {
        return new Iterator<HomologousFramePosition>(){
            HomologousFramePosition currentPosition;
            {
                this.currentPosition = (HomologousFramePosition)HomologousFramePositionPair.this.getSourceSystemPosition();
            }

            @Override
            public boolean hasNext() {
                return this.currentPosition != null;
            }

            @Override
            public HomologousFramePosition next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.currentPosition == HomologousFramePositionPair.this.getSourceSystemPosition()) {
                    this.currentPosition = (HomologousFramePosition)HomologousFramePositionPair.this.getTargetSystemPosition();
                    return (HomologousFramePosition)HomologousFramePositionPair.this.getSourceSystemPosition();
                }
                if (this.currentPosition == HomologousFramePositionPair.this.getTargetSystemPosition()) {
                    this.currentPosition = null;
                    return (HomologousFramePosition)HomologousFramePositionPair.this.getTargetSystemPosition();
                }
                return null;
            }
        };
    }
}

