/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.point;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePosition;
import org.applied_geodesy.adjustment.transformation.point.EstimatedFramePosition;

public class HomologousFramePosition
extends EstimatedFramePosition
implements DispersionablePosition {
    private ObjectProperty<Matrix> dispersionApriori = new SimpleObjectProperty((Object)this, "dispersionApriori");
    private ObjectProperty<Double> redundancyX = new SimpleObjectProperty((Object)this, "redundancyX", (Object)0.0);
    private ObjectProperty<Double> redundancyY = new SimpleObjectProperty((Object)this, "redundancyY", (Object)0.0);
    private ObjectProperty<Double> redundancyZ = new SimpleObjectProperty((Object)this, "redundancyZ", (Object)0.0);

    HomologousFramePosition(double z0) throws IllegalArgumentException {
        this(z0, MathExtension.identity(1));
    }

    HomologousFramePosition(double x0, double y0) throws IllegalArgumentException {
        this(x0, y0, MathExtension.identity(2));
    }

    HomologousFramePosition(double x0, double y0, double z0) throws IllegalArgumentException {
        this(x0, y0, z0, MathExtension.identity(3));
    }

    HomologousFramePosition(double z0, Matrix dispersion) throws IllegalArgumentException {
        super(z0);
        this.setDispersionApriori(dispersion);
    }

    HomologousFramePosition(double x0, double y0, Matrix dispersion) throws IllegalArgumentException {
        super(x0, y0);
        this.setDispersionApriori(dispersion);
    }

    HomologousFramePosition(double x0, double y0, double z0, Matrix dispersion) throws IllegalArgumentException {
        super(x0, y0, z0);
        this.setDispersionApriori(dispersion);
    }

    public double getRedundancyX() {
        return (Double)this.redundancyX.get();
    }

    public void setRedundancyX(double redundancyX) {
        this.redundancyX.set((Object)redundancyX);
    }

    public ObservableObjectValue<Double> redundancyXProperty() {
        return this.redundancyX;
    }

    public double getRedundancyY() {
        return (Double)this.redundancyY.get();
    }

    public void setRedundancyY(double redundancyY) {
        this.redundancyY.set((Object)redundancyY);
    }

    public ObservableObjectValue<Double> redundancyYProperty() {
        return this.redundancyY;
    }

    public double getRedundancyZ() {
        return (Double)this.redundancyZ.get();
    }

    public void setRedundancyZ(double redundancyZ) {
        this.redundancyZ.set((Object)redundancyZ);
    }

    public ObservableObjectValue<Double> redundancyZProperty() {
        return this.redundancyZ;
    }

    @Override
    public ObservableObjectValue<Matrix> dispersionAprioriProperty() {
        return this.dispersionApriori;
    }

    @Override
    public Matrix getDispersionApriori() {
        return (Matrix)this.dispersionApriori.get();
    }

    @Override
    public void setDispersionApriori(Matrix dispersion) throws IllegalArgumentException {
        this.checkDispersionMatrix(dispersion);
        this.dispersionApriori.set((Object)dispersion);
    }

    @Override
    public void reset() {
        super.reset();
        this.setRedundancyX(0.0);
        this.setRedundancyY(0.0);
        this.setRedundancyZ(0.0);
    }
}

