/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.point;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javafx.beans.value.ObservableObjectValue;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePositionPair;
import org.applied_geodesy.adjustment.transformation.point.EstimatedFramePosition;
import org.applied_geodesy.adjustment.transformation.point.ObservedFramePosition;
import org.applied_geodesy.adjustment.transformation.point.Position;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;

public class FramePositionPair
extends PositionPair<ObservedFramePosition, EstimatedFramePosition>
implements Iterable<Position>,
DispersionablePositionPair<ObservedFramePosition, EstimatedFramePosition> {
    public FramePositionPair(String name, double zSrc, double zTrg) {
        this(name, new ObservedFramePosition(zSrc), new EstimatedFramePosition(zTrg));
    }

    public FramePositionPair(String name, double xSrc, double ySrc, double xTrg, double yTrg) {
        this(name, new ObservedFramePosition(xSrc, ySrc), new EstimatedFramePosition(xTrg, yTrg));
    }

    public FramePositionPair(String name, double xSrc, double ySrc, double zSrc, double xTrg, double yTrg, double zTrg) {
        this(name, new ObservedFramePosition(xSrc, ySrc, zSrc), new EstimatedFramePosition(xTrg, yTrg, zTrg));
    }

    public FramePositionPair(String name, double zSrc, Matrix dispersionSrc, double zTrg) {
        this(name, new ObservedFramePosition(zSrc, dispersionSrc), new EstimatedFramePosition(zTrg));
    }

    public FramePositionPair(String name, double xSrc, double ySrc, Matrix dispersionSrc, double xTrg, double yTrg) {
        this(name, new ObservedFramePosition(xSrc, ySrc, dispersionSrc), new EstimatedFramePosition(xTrg, yTrg));
    }

    public FramePositionPair(String name, double xSrc, double ySrc, double zSrc, Matrix dispersionSrc, double xTrg, double yTrg, double zTrg) {
        this(name, new ObservedFramePosition(xSrc, ySrc, zSrc, dispersionSrc), new EstimatedFramePosition(xTrg, yTrg, zTrg));
    }

    public FramePositionPair(String name, ObservedFramePosition pointSrc) {
        super(name, pointSrc, FramePositionPair.defaultEstimatedFramePosition(pointSrc.getDimension()));
    }

    private FramePositionPair(String name, ObservedFramePosition pointSrc, EstimatedFramePosition pointTrg) {
        super(name, pointSrc, pointTrg);
    }

    private static EstimatedFramePosition defaultEstimatedFramePosition(int dim) {
        return EstimatedFramePosition.create(dim);
    }

    @Override
    public Iterator<Position> iterator() {
        return new Iterator<Position>(){
            Position currentPosition;
            {
                this.currentPosition = (Position)FramePositionPair.this.getSourceSystemPosition();
            }

            @Override
            public boolean hasNext() {
                return this.currentPosition != null;
            }

            @Override
            public Position next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.currentPosition == FramePositionPair.this.getSourceSystemPosition()) {
                    this.currentPosition = (Position)FramePositionPair.this.getTargetSystemPosition();
                    return (Position)FramePositionPair.this.getSourceSystemPosition();
                }
                if (this.currentPosition == FramePositionPair.this.getTargetSystemPosition()) {
                    this.currentPosition = null;
                    return (Position)FramePositionPair.this.getTargetSystemPosition();
                }
                return null;
            }
        };
    }

    public ObservableObjectValue<Double> targetUncertaintyXProperty() {
        return ((EstimatedFramePosition)this.getTargetSystemPosition()).uncertaintyXProperty();
    }

    public ObservableObjectValue<Double> targetUncertaintyYProperty() {
        return ((EstimatedFramePosition)this.getTargetSystemPosition()).uncertaintyYProperty();
    }

    public ObservableObjectValue<Double> targetUncertaintyZProperty() {
        return ((EstimatedFramePosition)this.getTargetSystemPosition()).uncertaintyZProperty();
    }

    public ObservableObjectValue<Double> targetResidualXProperty() {
        return ((EstimatedFramePosition)this.getTargetSystemPosition()).residualXProperty();
    }

    public ObservableObjectValue<Double> targetResidualYProperty() {
        return ((EstimatedFramePosition)this.getTargetSystemPosition()).residualYProperty();
    }

    public ObservableObjectValue<Double> targetResidualZProperty() {
        return ((EstimatedFramePosition)this.getTargetSystemPosition()).residualZProperty();
    }

    @Override
    public void reset() {
        super.reset();
        ((ObservedFramePosition)this.getSourceSystemPosition()).reset();
        ((EstimatedFramePosition)this.getTargetSystemPosition()).reset();
    }
}

