/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.point;

import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import org.applied_geodesy.adjustment.transformation.VarianceComponent;
import org.applied_geodesy.adjustment.transformation.VarianceComponentType;
import org.applied_geodesy.adjustment.transformation.point.AdjustablePosition;
import org.applied_geodesy.adjustment.transformation.point.Position;

public class EstimatedFramePosition
extends Position
implements AdjustablePosition {
    private ObjectProperty<VarianceComponent> varianceComponent = new SimpleObjectProperty((Object)this, "varianceComponent", (Object)new VarianceComponent(VarianceComponentType.GLOBAL));
    private ObjectProperty<Double> residualX = new SimpleObjectProperty((Object)this, "residualX", (Object)0.0);
    private ObjectProperty<Double> residualY = new SimpleObjectProperty((Object)this, "residualY", (Object)0.0);
    private ObjectProperty<Double> residualZ = new SimpleObjectProperty((Object)this, "residualZ", (Object)0.0);
    private ObjectProperty<Double> cofactorX = new SimpleObjectProperty((Object)this, "cofactorX", (Object)0.0);
    private ObjectProperty<Double> cofactorY = new SimpleObjectProperty((Object)this, "cofactorY", (Object)0.0);
    private ObjectProperty<Double> cofactorZ = new SimpleObjectProperty((Object)this, "cofactorZ", (Object)0.0);
    private ObjectBinding<Double> x;
    private ObjectBinding<Double> y;
    private ObjectBinding<Double> z;
    private ObjectBinding<Double> uncertaintyX;
    private ObjectBinding<Double> uncertaintyY;
    private ObjectBinding<Double> uncertaintyZ;

    EstimatedFramePosition(double z0) throws IllegalArgumentException {
        super(z0);
        this.init();
    }

    EstimatedFramePosition(double x0, double y0) throws IllegalArgumentException {
        super(x0, y0);
        this.init();
    }

    EstimatedFramePosition(double x0, double y0, double z0) throws IllegalArgumentException {
        super(x0, y0, z0);
        this.init();
    }

    public static EstimatedFramePosition create(int dim) {
        switch (dim) {
            case 1: {
                return new EstimatedFramePosition(0.0);
            }
            case 2: {
                return new EstimatedFramePosition(0.0, 0.0);
            }
        }
        return new EstimatedFramePosition(0.0, 0.0, 0.0);
    }

    private void init() {
        this.setX0(super.getX());
        this.setY0(super.getY());
        this.setZ0(super.getZ());
        this.x = new ObjectBinding<Double>(){

            protected Double computeValue() {
                return (Double)EstimatedFramePosition.this.x0Property().get() + (Double)EstimatedFramePosition.this.residualX.get();
            }
        };
        this.y = new ObjectBinding<Double>(){

            protected Double computeValue() {
                return (Double)EstimatedFramePosition.this.y0Property().get() + (Double)EstimatedFramePosition.this.residualY.get();
            }
        };
        this.z = new ObjectBinding<Double>(){

            protected Double computeValue() {
                return (Double)EstimatedFramePosition.this.z0Property().get() + (Double)EstimatedFramePosition.this.residualZ.get();
            }
        };
        this.uncertaintyX = new ObjectBinding<Double>(){

            protected Double computeValue() {
                if (((VarianceComponent)EstimatedFramePosition.this.varianceComponent.get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    return Math.sqrt(Math.abs((Double)EstimatedFramePosition.this.cofactorX.get() * (Double)((VarianceComponent)EstimatedFramePosition.this.varianceComponent.get()).varianceProperty().get()));
                }
                return Math.sqrt(Math.abs((Double)EstimatedFramePosition.this.cofactorX.get() * (Double)((VarianceComponent)EstimatedFramePosition.this.varianceComponent.get()).variance0Property().get()));
            }
        };
        this.uncertaintyY = new ObjectBinding<Double>(){

            protected Double computeValue() {
                if (((VarianceComponent)EstimatedFramePosition.this.varianceComponent.get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    return Math.sqrt(Math.abs((Double)EstimatedFramePosition.this.cofactorY.get() * (Double)((VarianceComponent)EstimatedFramePosition.this.varianceComponent.get()).varianceProperty().get()));
                }
                return Math.sqrt(Math.abs((Double)EstimatedFramePosition.this.cofactorY.get() * (Double)((VarianceComponent)EstimatedFramePosition.this.varianceComponent.get()).variance0Property().get()));
            }
        };
        this.uncertaintyZ = new ObjectBinding<Double>(){

            protected Double computeValue() {
                if (((VarianceComponent)EstimatedFramePosition.this.varianceComponent.get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    return Math.sqrt(Math.abs((Double)EstimatedFramePosition.this.cofactorZ.get() * (Double)((VarianceComponent)EstimatedFramePosition.this.varianceComponent.get()).varianceProperty().get()));
                }
                return Math.sqrt(Math.abs((Double)EstimatedFramePosition.this.cofactorZ.get() * (Double)((VarianceComponent)EstimatedFramePosition.this.varianceComponent.get()).variance0Property().get()));
            }
        };
    }

    @Override
    public double getX() {
        return (Double)this.x.get();
    }

    @Override
    public ObservableObjectValue<Double> xProperty() {
        return this.x;
    }

    @Override
    public double getY() {
        return (Double)this.y.get();
    }

    @Override
    public ObservableObjectValue<Double> yProperty() {
        return this.y;
    }

    @Override
    public double getZ() {
        return (Double)this.z.get();
    }

    @Override
    public ObservableObjectValue<Double> zProperty() {
        return this.z;
    }

    @Override
    public double getResidualX() {
        return (Double)this.residualX.get();
    }

    @Override
    public void setResidualX(double residualX) {
        this.residualX.set((Object)residualX);
    }

    @Override
    public ObservableObjectValue<Double> residualXProperty() {
        return this.residualX;
    }

    @Override
    public double getResidualY() {
        return (Double)this.residualY.get();
    }

    @Override
    public void setResidualY(double residualY) {
        this.residualY.set((Object)residualY);
    }

    @Override
    public ObservableObjectValue<Double> residualYProperty() {
        return this.residualY;
    }

    @Override
    public double getResidualZ() {
        return (Double)this.residualZ.get();
    }

    @Override
    public void setResidualZ(double residualZ) {
        this.residualZ.set((Object)residualZ);
    }

    @Override
    public ObservableObjectValue<Double> residualZProperty() {
        return this.residualZ;
    }

    @Override
    public double getUncertaintyX() {
        return (Double)this.uncertaintyX.get();
    }

    @Override
    public ObservableObjectValue<Double> uncertaintyXProperty() {
        return this.uncertaintyX;
    }

    @Override
    public double getUncertaintyY() {
        return (Double)this.uncertaintyY.get();
    }

    @Override
    public ObservableObjectValue<Double> uncertaintyYProperty() {
        return this.uncertaintyY;
    }

    @Override
    public double getUncertaintyZ() {
        return (Double)this.uncertaintyZ.get();
    }

    @Override
    public ObservableObjectValue<Double> uncertaintyZProperty() {
        return this.uncertaintyZ;
    }

    @Override
    public double getCofactorX() {
        return (Double)this.cofactorX.get();
    }

    @Override
    public void setCofactorX(double cofactorX) {
        this.cofactorX.set((Object)cofactorX);
    }

    @Override
    public ObservableObjectValue<Double> cofactorXProperty() {
        return this.cofactorX;
    }

    @Override
    public double getCofactorY() {
        return (Double)this.cofactorY.get();
    }

    @Override
    public void setCofactorY(double cofactorY) {
        this.cofactorY.set((Object)cofactorY);
    }

    @Override
    public ObservableObjectValue<Double> cofactorYProperty() {
        return this.cofactorY;
    }

    @Override
    public double getCofactorZ() {
        return (Double)this.cofactorZ.get();
    }

    @Override
    public void setCofactorZ(double cofactorZ) {
        this.cofactorZ.set((Object)cofactorZ);
    }

    @Override
    public ObservableObjectValue<Double> cofactorZProperty() {
        return this.cofactorZ;
    }

    @Override
    public double getX0() {
        return (Double)super.xProperty().get();
    }

    @Override
    public void setX0(double x0) {
        ((ObjectProperty)super.xProperty()).set((Object)x0);
    }

    @Override
    public ObservableObjectValue<Double> x0Property() {
        return super.xProperty();
    }

    @Override
    public double getY0() {
        return (Double)super.yProperty().get();
    }

    @Override
    public void setY0(double y0) {
        ((ObjectProperty)super.yProperty()).set((Object)y0);
    }

    @Override
    public ObservableObjectValue<Double> y0Property() {
        return super.yProperty();
    }

    @Override
    public double getZ0() {
        return (Double)super.zProperty().get();
    }

    @Override
    public void setZ0(double z0) {
        ((ObjectProperty)super.zProperty()).set((Object)z0);
    }

    @Override
    public ObservableObjectValue<Double> z0Property() {
        return super.zProperty();
    }

    ObjectProperty<VarianceComponent> varianceComponentProperty() {
        return this.varianceComponent;
    }

    public VarianceComponent getVarianceComponent() {
        return (VarianceComponent)this.varianceComponent.get();
    }

    public void setVarianceComponent(VarianceComponent varianceComponent) {
        this.varianceComponent.set((Object)varianceComponent);
    }

    @Override
    public void reset() {
        super.reset();
        this.setResidualX(0.0);
        this.setResidualY(0.0);
        this.setResidualZ(0.0);
        this.setCofactorX(0.0);
        this.setCofactorY(0.0);
        this.setCofactorZ(0.0);
    }
}

