/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.point;

import javafx.beans.value.ObservableObjectValue;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.UnitUpperTriangBandMatrix;
import no.uib.cipr.matrix.UpperSymmBandMatrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.point.Positionable;

public interface DispersionablePosition
extends Positionable {
    public ObservableObjectValue<Matrix> dispersionAprioriProperty();

    public Matrix getDispersionApriori();

    public void setDispersionApriori(Matrix var1) throws IllegalArgumentException;

    default public Matrix getInvertedDispersion(boolean inplace) throws MatrixSingularException, IllegalArgumentException {
        Matrix dispersionApriori = this.getDispersionApriori();
        int size = dispersionApriori.numColumns();
        if (dispersionApriori instanceof UnitUpperTriangBandMatrix) {
            return dispersionApriori;
        }
        if (dispersionApriori instanceof UpperSymmBandMatrix) {
            Matrix W = inplace ? dispersionApriori : new UpperSymmBandMatrix(size, 0);
            for (MatrixEntry entry : dispersionApriori) {
                double value = entry.get();
                if (value <= 0.0) {
                    throw new MatrixSingularException("Error, matrix is a singular matrix!");
                }
                W.set(entry.row(), entry.column(), 1.0 / value);
            }
            return W;
        }
        if (dispersionApriori instanceof UpperSymmPackMatrix) {
            UpperSymmPackMatrix W = inplace ? (UpperSymmPackMatrix)dispersionApriori : new UpperSymmPackMatrix(dispersionApriori, true);
            MathExtension.inv(W);
            return W;
        }
        throw new IllegalArgumentException("Error, dispersion matrix must be of type UpperSymmBandMatrix, UnitUpperTriangBandMatrix, or UpperSymmPackMatrix!");
    }

    default public void checkDispersionMatrix(Matrix dispersion) throws IllegalArgumentException {
        if (!dispersion.isSquare() || this.getDimension() != dispersion.numColumns()) {
            throw new IllegalArgumentException("Error, dispersion matrix must be a squared matrix of dimension " + this.getDimension() + " x " + this.getDimension() + "!");
        }
        if (!(dispersion instanceof UpperSymmBandMatrix || dispersion instanceof UnitUpperTriangBandMatrix || dispersion instanceof UpperSymmPackMatrix)) {
            throw new IllegalArgumentException("Error, dispersion matrix must be of type UpperSymmBandMatrix, UnitUpperTriangBandMatrix, or UpperSymmPackMatrix!");
        }
        if (dispersion instanceof UpperSymmBandMatrix && ((UpperSymmBandMatrix)dispersion).numSuperDiagonals() != 0 || dispersion instanceof UnitUpperTriangBandMatrix && ((UnitUpperTriangBandMatrix)dispersion).numSuperDiagonals() != 0) {
            throw new IllegalArgumentException("Error, dispersion matrix must be a diagonal matrix, if BandMatrix type is used!");
        }
        if (dispersion instanceof UpperSymmBandMatrix || dispersion instanceof UpperSymmPackMatrix) {
            int row = 0;
            while (row < dispersion.numRows()) {
                double varI = dispersion.get(row, row);
                if (varI <= 0.0) {
                    throw new IllegalArgumentException("Error, element (" + row + ", " + row + ") on main diagonal of dispersion matrix is less than or equal to zero but must be greater than zero!");
                }
                if (dispersion instanceof UpperSymmPackMatrix) {
                    int col = row + 1;
                    while (col < dispersion.numColumns()) {
                        double varJ = dispersion.get(col, col);
                        double covarIJ = dispersion.get(row, col);
                        if (varJ <= 0.0) {
                            throw new IllegalArgumentException("Error, element (" + col + ", " + col + ": " + varJ + ") on main diagonal of dispersion matrix is less than or equal to zero but must be greater than zero!");
                        }
                        if (Math.abs(covarIJ) >= Math.sqrt(varI * varJ)) {
                            throw new IllegalArgumentException("Error, invalid dispersion matrix, as correlation coefficient of element (" + row + ", " + col + ") is not between -1 and 1!");
                        }
                        ++col;
                    }
                }
                ++row;
            }
        }
    }
}

