/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.parameter;

import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.applied_geodesy.adjustment.transformation.TestStatistic;
import org.applied_geodesy.adjustment.transformation.VarianceComponent;
import org.applied_geodesy.adjustment.transformation.parameter.Parameter;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.ProcessingType;

public class UnknownParameter
extends Parameter {
    private ObjectProperty<ProcessingType> processingType = new SimpleObjectProperty((Object)ProcessingType.ADJUSTMENT);
    private ReadOnlyObjectProperty<TestStatistic> testStatistic = new ReadOnlyObjectWrapper((Object)this, "testStatistic", (Object)new TestStatistic());
    private ObjectProperty<Integer> column = new SimpleObjectProperty((Object)this, "column", (Object)-1);
    private ObjectProperty<Double> value = new SimpleObjectProperty((Object)this, "value", (Object)0.0);
    private ObjectProperty<Double> uncertainty = new SimpleObjectProperty((Object)this, "uncertainty", (Object)0.0);
    private ReadOnlyObjectProperty<Double> expectedValue = null;
    private ReadOnlyObjectWrapper<Double> testStatisticApriori = new ReadOnlyObjectWrapper((Object)this, "testStatisticApriori", (Object)0.0);
    private ReadOnlyObjectWrapper<Double> testStatisticAposteriori = new ReadOnlyObjectWrapper((Object)this, "testStatisticAposteriori", (Object)0.0);
    private ReadOnlyObjectWrapper<Double> pValueApriori = new ReadOnlyObjectWrapper((Object)this, "pValueApriori", (Object)0.0);
    private ReadOnlyObjectWrapper<Double> pValueAposteriori = new ReadOnlyObjectWrapper((Object)this, "pValueAposteriori", (Object)0.0);
    private ObjectBinding<Boolean> significant;
    private ObjectProperty<Double> fisherQuantileApriori = new SimpleObjectProperty((Object)this, "fisherQuantileApriori", (Object)Double.MAX_VALUE);
    private ObjectProperty<Double> fisherQuantileAposteriori = new SimpleObjectProperty((Object)this, "fisherQuantileAposteriori", (Object)Double.MAX_VALUE);
    private ReadOnlyObjectProperty<Boolean> indispensable;

    public UnknownParameter(ParameterType parameterType, boolean indispensable) {
        this(parameterType, indispensable, 0.0, Boolean.TRUE);
    }

    public UnknownParameter(ParameterType parameterType, boolean indispensable, boolean visible) {
        this(parameterType, indispensable, 0.0, visible);
    }

    public UnknownParameter(ParameterType parameterType, boolean indispensable, double value) {
        this(parameterType, indispensable, value, Boolean.TRUE);
    }

    public UnknownParameter(ParameterType parameterType, boolean indispensable, double value, boolean visible) {
        this(parameterType, indispensable, value, value, visible, -1, ProcessingType.ADJUSTMENT);
    }

    public UnknownParameter(ParameterType parameterType, boolean indispensable, double value, double expectedValue, boolean visible) {
        this(parameterType, indispensable, value, expectedValue, visible, -1, ProcessingType.ADJUSTMENT);
    }

    public UnknownParameter(ParameterType parameterType, boolean indispensable, double value, boolean visible, ProcessingType processingType) {
        this(parameterType, indispensable, value, value, visible, -1, processingType);
    }

    public UnknownParameter(ParameterType parameterType, boolean indispensable, double value, double expectedValue, boolean visible, ProcessingType processingType) {
        this(parameterType, indispensable, value, expectedValue, visible, -1, processingType);
    }

    public UnknownParameter(ParameterType parameterType, boolean indispensable, double value, double expectedValue, boolean visible, int column, ProcessingType processingType) {
        super(parameterType);
        this.setValue0(value);
        this.setValue(value);
        this.setColumn(column);
        this.setProcessingType(processingType);
        this.setVisible(visible);
        this.expectedValue = new ReadOnlyObjectWrapper((Object)this, "expectedValue", (Object)expectedValue);
        this.indispensable = new ReadOnlyObjectWrapper((Object)this, "indispensable", (Object)indispensable);
        ((TestStatistic)this.testStatistic.get()).setApplyBiasCorrection(false);
        this.testStatisticApriori.bind(((TestStatistic)this.testStatistic.get()).testStatisticAprioriProperty());
        this.testStatisticAposteriori.bind(((TestStatistic)this.testStatistic.get()).testStatisticAposterioriProperty());
        this.pValueApriori.bind(((TestStatistic)this.testStatistic.get()).pValueAprioriProperty());
        this.pValueAposteriori.bind(((TestStatistic)this.testStatistic.get()).pValueAposterioriProperty());
        this.significant = new ObjectBinding<Boolean>(){

            protected Boolean computeValue() {
                boolean significant;
                boolean bl = significant = (Double)UnknownParameter.this.testStatisticApriori.get() > (Double)UnknownParameter.this.fisherQuantileApriori.get();
                if (((VarianceComponent)((TestStatistic)UnknownParameter.this.testStatistic.get()).varianceComponentProperty().get()).isApplyAposterioriVarianceOfUnitWeight()) {
                    if (!significant && !((Double)UnknownParameter.this.testStatisticAposteriori.get() > (Double)UnknownParameter.this.fisherQuantileAposteriori.get())) {
                        return false;
                    }
                    return true;
                }
                return significant;
            }
        };
    }

    public ReadOnlyObjectProperty<Boolean> indispensableProperty() {
        return this.indispensable;
    }

    public boolean isIndispensable() {
        return (Boolean)this.indispensable.get();
    }

    public void setColumn(int column) {
        this.column.set((Object)column);
    }

    public int getColumn() {
        return (Integer)this.column.get();
    }

    public ObjectProperty<Integer> columnProperty() {
        return this.column;
    }

    public ProcessingType getProcessingType() {
        return (ProcessingType)((Object)this.processingType.get());
    }

    public void setProcessingType(ProcessingType processingType) {
        this.processingType.set((Object)processingType);
        if (processingType != ProcessingType.ADJUSTMENT) {
            this.column.set((Object)-1);
        }
    }

    public ObjectProperty<ProcessingType> processingTypeProperty() {
        return this.processingType;
    }

    public void setValue(double value) {
        this.value.set((Object)value);
    }

    public double getValue() {
        return (Double)this.value.get();
    }

    public ObjectProperty<Double> valueProperty() {
        return this.value;
    }

    public double getExpectedValue() {
        return (Double)this.expectedValue.get();
    }

    public ObservableValue<Double> expectedValueProperty() {
        return this.expectedValue;
    }

    public void setUncertainty(double uncertainty) {
        this.uncertainty.set((Object)uncertainty);
    }

    public double getUncertainty() {
        return (Double)this.uncertainty.get();
    }

    public ObjectProperty<Double> uncertaintyProperty() {
        return this.uncertainty;
    }

    public ObjectBinding<Boolean> significantProperty() {
        return this.significant;
    }

    public boolean isSignificant() {
        return (Boolean)this.significant.get();
    }

    public TestStatistic getTestStatistic() {
        return (TestStatistic)this.testStatistic.get();
    }

    public ReadOnlyObjectProperty<TestStatistic> testStatisticProperty() {
        return this.testStatistic;
    }

    public void setFisherQuantileApriori(double fisherQuantileApriori) {
        this.fisherQuantileApriori.set((Object)fisherQuantileApriori);
    }

    public double getFisherQuantileApriori() {
        return (Double)this.fisherQuantileApriori.get();
    }

    public ObjectProperty<Double> fisherQuantileAprioriProperty() {
        return this.fisherQuantileApriori;
    }

    public void setFisherQuantileAposteriori(double fisherQuantileAposteriori) {
        this.fisherQuantileAposteriori.set((Object)fisherQuantileAposteriori);
    }

    public double getFisherQuantileAposteriori() {
        return (Double)this.fisherQuantileAposteriori.get();
    }

    public ObjectProperty<Double> fisherQuantileAposterioriProperty() {
        return this.fisherQuantileAposteriori;
    }

    @Override
    public String toString() {
        return "UnknownParameter [Name=" + this.getName() + ", ParameterType=" + String.valueOf((Object)this.getParameterType()) + ", Value0=" + this.getValue0() + ", ExpectedValue=" + this.getExpectedValue() + ", Column=" + this.getColumn() + ", ProcessingType=" + String.valueOf((Object)this.getProcessingType()) + ", Value=" + this.getValue() + "]";
    }
}

