/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.interpolation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.TransformationAdjustment;
import org.applied_geodesy.adjustment.transformation.interpolation.Interpolation;
import org.applied_geodesy.adjustment.transformation.interpolation.InterpolationType;
import org.applied_geodesy.adjustment.transformation.interpolation.SectorElement;
import org.applied_geodesy.adjustment.transformation.point.EstimatedFramePosition;
import org.applied_geodesy.adjustment.transformation.point.FramePositionPair;

public class SectorInterpolation
extends Interpolation {
    private ObjectProperty<Double> numeratorExponent = new SimpleObjectProperty((Object)this, "numeratorExponent", (Object)10.0);
    private ObjectProperty<Double> denominatorExponent = new SimpleObjectProperty((Object)this, "exponentDenominator", (Object)4.0);

    public SectorInterpolation() {
        super(InterpolationType.SECTOR);
    }

    public void setNumeratorExponent(double exponent) {
        this.numeratorExponent.set((Object)exponent);
    }

    public double getNumeratorExponent() {
        return (Double)this.numeratorExponent.get();
    }

    public ObjectProperty<Double> numeratorExponentProperty() {
        return this.numeratorExponent;
    }

    public void setDenominatorExponent(double exponent) {
        this.denominatorExponent.set((Object)exponent);
    }

    public double getDenominatorExponent() {
        return (Double)this.denominatorExponent.get();
    }

    public ObjectProperty<Double> denominatorExponentProperty() {
        return this.denominatorExponent;
    }

    @Override
    public void interpolate(Collection<EstimatedFramePosition> estimatedFramePositions, Collection<FramePositionPair> framePositionPairs, TransformationAdjustment.Interrupt interrupt) {
        double a = this.getNumeratorExponent();
        double b = this.getDenominatorExponent();
        int numberOfEstimatedFramePositions = estimatedFramePositions.size();
        for (FramePositionPair framePositionPair : framePositionPairs) {
            double sumWeights;
            if (interrupt.isInterrupted()) {
                return;
            }
            if (!framePositionPair.isEnable()) continue;
            ArrayList<SectorElement> sectorElements = new ArrayList<SectorElement>(estimatedFramePositions.size());
            ArrayList<SectorElement> adaptedSectorElements = new ArrayList<SectorElement>(estimatedFramePositions.size());
            EstimatedFramePosition targetSystemPosition = (EstimatedFramePosition)framePositionPair.getTargetSystemPosition();
            for (EstimatedFramePosition estimatedFramePosition : estimatedFramePositions) {
                if (interrupt.isInterrupted()) {
                    return;
                }
                double dx = estimatedFramePosition.getX0() - targetSystemPosition.getX();
                double dy = estimatedFramePosition.getY0() - targetSystemPosition.getY();
                double dz = estimatedFramePosition.getZ0() - targetSystemPosition.getZ();
                double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                double azimuth = Math.atan2(dy, dx);
                if (distance < SQRT_EPS) {
                    distance = SQRT_EPS;
                }
                sectorElements.add(new SectorElement(azimuth, distance /= 1000.0, -estimatedFramePosition.getResidualX(), -estimatedFramePosition.getResidualY(), -estimatedFramePosition.getResidualZ()));
            }
            Collections.sort(sectorElements);
            for (SectorElement sectorElementA : sectorElements) {
                if (interrupt.isInterrupted()) {
                    return;
                }
                double azimuthA = sectorElementA.getAzimuth();
                double distanceA = sectorElementA.getDistance();
                sumWeights = 0.0;
                double maxWeight = 0.0;
                double ux = 0.0;
                double uy = 0.0;
                double uz = 0.0;
                for (SectorElement sectorElementB : sectorElements) {
                    if (interrupt.isInterrupted()) {
                        return;
                    }
                    double azimuthB = sectorElementB.getAzimuth();
                    double distanceB = sectorElementB.getDistance();
                    double angle = MathExtension.MOD(azimuthB - azimuthA, Math.PI * 2);
                    double weight = Math.pow((Math.PI - angle) / Math.PI, a) / Math.pow(distanceB, b);
                    if (Double.isInfinite(weight) || Double.isNaN(weight)) {
                        weight = 0.0;
                    }
                    maxWeight = Math.max(maxWeight, weight);
                    sumWeights += weight;
                    ux += weight * sectorElementB.getResidualX();
                    uy += weight * sectorElementB.getResidualY();
                    uz += weight * sectorElementB.getResidualZ();
                }
                if (sumWeights != 0.0) {
                    ux /= sumWeights;
                    uy /= sumWeights;
                    uz /= sumWeights;
                } else {
                    uz = 0.0;
                    uy = 0.0;
                    ux = 0.0;
                }
                double weight = maxWeight != 0.0 ? Math.pow(maxWeight, 1.0 / b) : 0.0;
                adaptedSectorElements.add(new SectorElement(azimuthA, distanceA, ux, uy, uz, weight));
            }
            sectorElements.clear();
            double ux = 0.0;
            double uy = 0.0;
            double uz = 0.0;
            sumWeights = 0.0;
            int i = 0;
            int j = i + 1;
            while (i < numberOfEstimatedFramePositions) {
                if (interrupt.isInterrupted()) {
                    return;
                }
                if (j == numberOfEstimatedFramePositions) {
                    j = 0;
                }
                SectorElement sectorElementA = (SectorElement)adaptedSectorElements.get(i);
                SectorElement sectorElementB = (SectorElement)adaptedSectorElements.get(j);
                double uxA = sectorElementA.getResidualX();
                double uyA = sectorElementA.getResidualY();
                double uzA = sectorElementA.getResidualZ();
                double weightA = sectorElementA.getWeight();
                double azimuthA = sectorElementA.getAzimuth();
                double uxB = sectorElementB.getResidualX();
                double uyB = sectorElementB.getResidualY();
                double uzB = sectorElementB.getResidualZ();
                double weightB = sectorElementB.getWeight();
                double azimuthB = sectorElementB.getAzimuth();
                double angle = MathExtension.MOD(azimuthB - azimuthA, Math.PI * 2);
                ux += (uxB * weightB + uxA * weightA) * angle;
                uy += (uyB * weightB + uyA * weightA) * angle;
                uz += (uzB * weightB + uzA * weightA) * angle;
                sumWeights += (weightB + weightA) * angle;
                ++i;
                ++j;
            }
            if (sumWeights != 0.0) {
                ux /= sumWeights;
                uy /= sumWeights;
                uz /= sumWeights;
            } else {
                uz = 0.0;
                uy = 0.0;
                ux = 0.0;
            }
            targetSystemPosition.setResidualX(ux);
            targetSystemPosition.setResidualY(uy);
            targetSystemPosition.setResidualZ(uz);
        }
    }
}

