/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.interpolation;

import org.applied_geodesy.adjustment.MathExtension;

class SectorElement
implements Comparable<SectorElement> {
    private final double distance;
    private final double azimuth;
    private final double residualX;
    private final double residualY;
    private final double residualZ;
    private final double weight;

    SectorElement(double azimuth, double distance, double residualX, double residualY, double residualZ) {
        this(azimuth, distance, residualX, residualY, residualZ, 0.0);
    }

    SectorElement(double azimuth, double distance, double residualX, double residualY, double residualZ, double weight) {
        this.distance = distance;
        this.azimuth = MathExtension.MOD(azimuth, Math.PI * 2);
        this.residualX = residualX;
        this.residualY = residualY;
        this.residualZ = residualZ;
        this.weight = weight;
    }

    public double getResidualX() {
        return this.residualX;
    }

    public double getResidualY() {
        return this.residualY;
    }

    public double getResidualZ() {
        return this.residualZ;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(SectorElement compareObject) {
        if (this.getAzimuth() < compareObject.getAzimuth()) {
            return -1;
        }
        if (this.getAzimuth() > compareObject.getAzimuth()) {
            return 1;
        }
        return 0;
    }
}

