/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.interpolation;

import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.TransformationAdjustment;
import org.applied_geodesy.adjustment.transformation.interpolation.Interpolation;
import org.applied_geodesy.adjustment.transformation.interpolation.InterpolationType;
import org.applied_geodesy.adjustment.transformation.point.EstimatedFramePosition;
import org.applied_geodesy.adjustment.transformation.point.FramePositionPair;

public class MultiQuadraticInterpolation
extends Interpolation {
    private ObjectProperty<Double> exponent = new SimpleObjectProperty((Object)this, "exponent", (Object)0.5);
    private ObjectProperty<Double> smoothing = new SimpleObjectProperty((Object)this, "smoothing", (Object)0.0);

    public MultiQuadraticInterpolation() {
        super(InterpolationType.MULTI_QUADRATIC);
    }

    public void setSmoothing(double smoothing) {
        this.smoothing.set((Object)smoothing);
    }

    public double getSmoothing() {
        return (Double)this.smoothing.get();
    }

    public ObjectProperty<Double> smoothingProperty() {
        return this.smoothing;
    }

    public void setExponent(double exponent) {
        this.exponent.set((Object)exponent);
    }

    public double getExponent() {
        return (Double)this.exponent.get();
    }

    public ObjectProperty<Double> exponentProperty() {
        return this.exponent;
    }

    @Override
    public void interpolate(Collection<EstimatedFramePosition> estimatedFramePositionsCollection, Collection<FramePositionPair> framePositionPairs, TransformationAdjustment.Interrupt interrupt) {
        double k = this.getExponent();
        double m = this.getSmoothing();
        ArrayList<EstimatedFramePosition> estimatedFramePositions = new ArrayList<EstimatedFramePosition>(estimatedFramePositionsCollection);
        int numberOfEstimatedFramePosition = estimatedFramePositions.size();
        UpperSymmPackMatrix S = new UpperSymmPackMatrix(numberOfEstimatedFramePosition);
        DenseVector vx = new DenseVector(numberOfEstimatedFramePosition);
        DenseVector vy = new DenseVector(numberOfEstimatedFramePosition);
        DenseVector vz = new DenseVector(numberOfEstimatedFramePosition);
        int i = 0;
        while (i < numberOfEstimatedFramePosition) {
            if (interrupt.isInterrupted()) {
                return;
            }
            EstimatedFramePosition estimatedFramePositionA = (EstimatedFramePosition)estimatedFramePositions.get(i);
            int j = i;
            while (j < numberOfEstimatedFramePosition) {
                double dz;
                double dy;
                if (interrupt.isInterrupted()) {
                    return;
                }
                EstimatedFramePosition estimatedFramePositionB = (EstimatedFramePosition)estimatedFramePositions.get(j);
                double dx = estimatedFramePositionB.getX0() - estimatedFramePositionA.getX0();
                double weight = dx * dx + (dy = estimatedFramePositionB.getY0() - estimatedFramePositionA.getY0()) * dy + (dz = estimatedFramePositionB.getZ0() - estimatedFramePositionA.getZ0()) * dz + m;
                if (weight != 0.0) {
                    weight = Math.pow(weight, k);
                }
                S.set(i, j, weight);
                ++j;
            }
            vx.set(i, -estimatedFramePositionA.getResidualX());
            vy.set(i, -estimatedFramePositionA.getResidualY());
            vz.set(i, -estimatedFramePositionA.getResidualZ());
            ++i;
        }
        MathExtension.solve(S, vx, true);
        DenseVector tmp = new DenseVector((Vector)vy, true);
        S.mult((Vector)tmp, (Vector)vy);
        tmp = new DenseVector((Vector)vz, true);
        S.mult((Vector)tmp, (Vector)vz);
        for (FramePositionPair framePositionPair : framePositionPairs) {
            if (interrupt.isInterrupted()) {
                return;
            }
            if (!framePositionPair.isEnable()) continue;
            double ux = 0.0;
            double uy = 0.0;
            double uz = 0.0;
            EstimatedFramePosition targetSystemPosition = (EstimatedFramePosition)framePositionPair.getTargetSystemPosition();
            int i2 = 0;
            while (i2 < numberOfEstimatedFramePosition) {
                double dz;
                double dy;
                EstimatedFramePosition estimatedFramePosition = (EstimatedFramePosition)estimatedFramePositions.get(i2);
                double dx = targetSystemPosition.getX() - estimatedFramePosition.getX0();
                double weight = dx * dx + (dy = targetSystemPosition.getY() - estimatedFramePosition.getY0()) * dy + (dz = targetSystemPosition.getZ() - estimatedFramePosition.getZ0()) * dz + m;
                if (weight != 0.0) {
                    weight = Math.pow(weight, k);
                }
                ux += weight * vx.get(i2);
                uy += weight * vy.get(i2);
                uz += weight * vz.get(i2);
                ++i2;
            }
            targetSystemPosition.setResidualX(ux);
            targetSystemPosition.setResidualY(uy);
            targetSystemPosition.setResidualZ(uz);
        }
    }
}

