/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.interpolation;

import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.applied_geodesy.adjustment.transformation.TransformationAdjustment;
import org.applied_geodesy.adjustment.transformation.interpolation.Interpolation;
import org.applied_geodesy.adjustment.transformation.interpolation.InterpolationType;
import org.applied_geodesy.adjustment.transformation.point.EstimatedFramePosition;
import org.applied_geodesy.adjustment.transformation.point.FramePositionPair;

public class InverseDistanceWeighting
extends Interpolation {
    private ObjectProperty<Double> exponent = new SimpleObjectProperty((Object)this, "exponent", (Object)2.0);
    private ObjectProperty<Double> smoothing = new SimpleObjectProperty((Object)this, "smoothing", (Object)0.0);

    public InverseDistanceWeighting() {
        super(InterpolationType.INVERSE_DISTANCE_WEIGHTING);
    }

    public void setSmoothing(double smoothing) {
        this.smoothing.set((Object)smoothing);
    }

    public double getSmoothing() {
        return (Double)this.smoothing.get();
    }

    public ObjectProperty<Double> smoothingProperty() {
        return this.smoothing;
    }

    public void setExponent(double exponent) {
        this.exponent.set((Object)exponent);
    }

    public double getExponent() {
        return (Double)this.exponent.get();
    }

    public ObjectProperty<Double> exponentProperty() {
        return this.exponent;
    }

    @Override
    public void interpolate(Collection<EstimatedFramePosition> estimatedFramePositions, Collection<FramePositionPair> framePositionPairs, TransformationAdjustment.Interrupt interrupt) {
        double k = this.getExponent();
        double m = this.getSmoothing();
        for (FramePositionPair framePositionPair : framePositionPairs) {
            if (interrupt.isInterrupted()) {
                return;
            }
            if (!framePositionPair.isEnable()) continue;
            double sumWeight = 0.0;
            double ux = 0.0;
            double uy = 0.0;
            double uz = 0.0;
            EstimatedFramePosition targetSystemPosition = (EstimatedFramePosition)framePositionPair.getTargetSystemPosition();
            for (EstimatedFramePosition estimatedFramePosition : estimatedFramePositions) {
                double dz;
                double dy;
                double dx = targetSystemPosition.getX() - estimatedFramePosition.getX0();
                double weight = Math.sqrt(dx * dx + (dy = targetSystemPosition.getY() - estimatedFramePosition.getY0()) * dy + (dz = targetSystemPosition.getZ() - estimatedFramePosition.getZ0()) * dz);
                weight = weight > SQRT_EPS ? Math.pow(weight + m, -k) : 1.0 / SQRT_EPS;
                sumWeight += weight;
                ux += weight * estimatedFramePosition.getResidualX();
                uy += weight * estimatedFramePosition.getResidualY();
                uz += weight * estimatedFramePosition.getResidualZ();
            }
            if (sumWeight == 0.0) continue;
            targetSystemPosition.setResidualX(-(ux /= sumWeight));
            targetSystemPosition.setResidualY(-(uy /= sumWeight));
            targetSystemPosition.setResidualZ(-(uz /= sumWeight));
        }
    }
}

