/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.equation;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.transformation.TransformationType;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.AdjustablePosition;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;
import org.applied_geodesy.adjustment.transformation.point.SimplePositionPair;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;
import org.applied_geodesy.util.ObservableUniqueList;

public abstract class TransformationEquations
implements Iterable<HomologousFramePositionPair> {
    private ObservableUniqueList<HomologousFramePositionPair> homologousPositionPairs = new ObservableUniqueList();
    private SimplePositionPair centerOfMasses = null;
    private ObjectProperty<String> name = new SimpleObjectProperty((Object)this, "name");
    private static int ID_CNT = 0;
    private ReadOnlyObjectProperty<Integer> id = new ReadOnlyObjectWrapper((Object)this, "id", (Object)ID_CNT++);

    public boolean contains(Object object) {
        return this.getUnknownParameters().contains(object);
    }

    public abstract void reverseCenterOfMasses(UpperSymmPackMatrix var1);

    public abstract void normalEquationElements(PositionPair<? extends DispersionablePosition, ? extends AdjustablePosition> var1, Matrix var2, Matrix var3, Matrix var4, Vector var5);

    public abstract TransformationType getTransformationType();

    public abstract Matrix getHomogeneousCoordinateTransformationMatrix();

    public abstract Matrix getRotationMatrix();

    public abstract Collection<UnknownParameter> getUnknownParameters();

    public abstract UnknownParameter getUnknownParameter(ParameterType var1);

    public final int getId() {
        return (Integer)this.id.get();
    }

    public ReadOnlyObjectProperty<Integer> idProperty() {
        return this.id;
    }

    public ObservableUniqueList<HomologousFramePositionPair> getHomologousFramePositionPairs() {
        return this.homologousPositionPairs;
    }

    public void setCenterOfMasses(SimplePositionPair centerOfMasses) {
        this.centerOfMasses = centerOfMasses;
    }

    public SimplePositionPair getCenterOfMasses() {
        if (this.centerOfMasses == null) {
            switch (this.getTransformationType()) {
                case HEIGHT: {
                    this.centerOfMasses = new SimplePositionPair("CENTER_OF_MASSES", 0.0, 0.0);
                    break;
                }
                case PLANAR: {
                    this.centerOfMasses = new SimplePositionPair("CENTER_OF_MASSES", 0.0, 0.0, 0.0, 0.0);
                    break;
                }
                case SPATIAL: {
                    this.centerOfMasses = new SimplePositionPair("CENTER_OF_MASSES", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return this.centerOfMasses;
    }

    public Collection<Restriction> getRestrictions() {
        return Collections.emptySet();
    }

    public int getNumberOfPoints() {
        return this.homologousPositionPairs.size();
    }

    @Override
    public Iterator<HomologousFramePositionPair> iterator() {
        return this.homologousPositionPairs.iterator();
    }

    public ObjectProperty<String> nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public String toString() {
        return this.getName();
    }

    public void transform(PositionPair<? extends DispersionablePosition, ? extends AdjustablePosition> positionPair, UpperSymmPackMatrix Dp) {
        DispersionablePosition pointSrc = positionPair.getSourceSystemPosition();
        AdjustablePosition pointTrg = positionPair.getTargetSystemPosition();
        int dim = this.getTransformationType().getDimension();
        int nop = Dp.numColumns();
        DenseMatrix Jx = new DenseMatrix(dim, nop);
        DenseMatrix Jv = new DenseMatrix(dim, dim);
        DenseVector w = new DenseVector(dim);
        this.normalEquationElements(positionPair, (Matrix)Jx, (Matrix)Jv, null, (Vector)w);
        DenseMatrix DpJxT = new DenseMatrix(nop, dim);
        Dp.transBmult((Matrix)Jx, (Matrix)DpJxT);
        UpperSymmPackMatrix JDJT = new UpperSymmPackMatrix(dim);
        Jx.mult((Matrix)DpJxT, (Matrix)JDJT);
        DpJxT = null;
        Matrix Dsrc = pointSrc.getDispersionApriori();
        DenseMatrix DsrcJvT = new DenseMatrix(dim, dim);
        Dsrc.transBmult((Matrix)Jv, (Matrix)DsrcJvT);
        Jv.multAdd((Matrix)DsrcJvT, (Matrix)JDJT);
        if (dim != 1) {
            pointTrg.setX0(w.get(0));
            pointTrg.setY0(w.get(1));
            pointTrg.setCofactorX(JDJT.get(0, 0));
            pointTrg.setCofactorY(JDJT.get(1, 1));
        }
        if (dim != 2) {
            pointTrg.setZ0(w.get(dim - 1));
            pointTrg.setCofactorZ(JDJT.get(dim - 1, dim - 1));
        }
    }
}

