/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.equation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.transformation.TransformationType;
import org.applied_geodesy.adjustment.transformation.equation.TransformationEquations;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.ProcessingType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.AdjustablePosition;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.Position;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;
import org.applied_geodesy.adjustment.transformation.point.SimplePositionPair;
import org.applied_geodesy.adjustment.transformation.restriction.ProductSumRestriction;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;

public class SpatialAffineEquations
extends TransformationEquations {
    private Map<ParameterType, UnknownParameter> parameters = null;
    private ProductSumRestriction quaternionLengthRestriction;

    public SpatialAffineEquations() {
        this.init();
    }

    public void setInitialGuess(double tx, double ty, double tz, double q0, double q1, double q2, double q3, double s11, double s12, double s13, double s22, double s23, double s33) throws IllegalArgumentException {
        this.parameters.get((Object)ParameterType.SHIFT_X).setValue0(tx);
        this.parameters.get((Object)ParameterType.SHIFT_Y).setValue0(ty);
        this.parameters.get((Object)ParameterType.SHIFT_Z).setValue0(tz);
        this.parameters.get((Object)ParameterType.QUATERNION_Q0).setValue0(q0);
        this.parameters.get((Object)ParameterType.QUATERNION_Q1).setValue0(q1);
        this.parameters.get((Object)ParameterType.QUATERNION_Q2).setValue0(q2);
        this.parameters.get((Object)ParameterType.QUATERNION_Q3).setValue0(q3);
        this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_11).setValue0(s11);
        this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_12).setValue0(s12);
        this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_13).setValue0(s13);
        this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_22).setValue0(s22);
        this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_23).setValue0(s23);
        this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_33).setValue0(s33);
    }

    @Override
    public void setCenterOfMasses(SimplePositionPair centerOfMasses) {
        SimplePositionPair prevCenterOfMasses = this.getCenterOfMasses();
        boolean equalComponents = centerOfMasses.equalsCoordinateComponents(prevCenterOfMasses);
        super.setCenterOfMasses(centerOfMasses);
        if (equalComponents) {
            return;
        }
        UnknownParameter Tx = this.parameters.get((Object)ParameterType.SHIFT_X);
        UnknownParameter Ty = this.parameters.get((Object)ParameterType.SHIFT_Y);
        UnknownParameter Tz = this.parameters.get((Object)ParameterType.SHIFT_Z);
        UnknownParameter Q0 = this.parameters.get((Object)ParameterType.QUATERNION_Q0);
        UnknownParameter Q1 = this.parameters.get((Object)ParameterType.QUATERNION_Q1);
        UnknownParameter Q2 = this.parameters.get((Object)ParameterType.QUATERNION_Q2);
        UnknownParameter Q3 = this.parameters.get((Object)ParameterType.QUATERNION_Q3);
        UnknownParameter S11 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_11);
        UnknownParameter S12 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_12);
        UnknownParameter S13 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_13);
        UnknownParameter S22 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_22);
        UnknownParameter S23 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_23);
        UnknownParameter S33 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_33);
        double tx = Tx.getValue();
        double ty = Ty.getValue();
        double tz = Tz.getValue();
        double q0 = Q0.getValue();
        double q1 = Q1.getValue();
        double q2 = Q2.getValue();
        double q3 = Q3.getValue();
        double s11 = S11.getValue();
        double s12 = S12.getValue();
        double s13 = S13.getValue();
        double s22 = S22.getValue();
        double s23 = S23.getValue();
        double s33 = S33.getValue();
        double r11 = 2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1;
        double r12 = 2.0 * (q1 * q2 - q0 * q3);
        double r13 = 2.0 * (q1 * q3 + q0 * q2);
        double r21 = 2.0 * (q1 * q2 + q0 * q3);
        double r22 = 2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2;
        double r23 = 2.0 * (q2 * q3 - q0 * q1);
        double r31 = 2.0 * (q1 * q3 - q0 * q2);
        double r32 = 2.0 * (q2 * q3 + q0 * q1);
        double r33 = 2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3;
        double dxi = -(((Position)prevCenterOfMasses.getSourceSystemPosition()).getX() - ((Position)centerOfMasses.getSourceSystemPosition()).getX());
        double dyi = -(((Position)prevCenterOfMasses.getSourceSystemPosition()).getY() - ((Position)centerOfMasses.getSourceSystemPosition()).getY());
        double dzi = -(((Position)prevCenterOfMasses.getSourceSystemPosition()).getZ() - ((Position)centerOfMasses.getSourceSystemPosition()).getZ());
        double dXi = ((Position)prevCenterOfMasses.getTargetSystemPosition()).getX() - ((Position)centerOfMasses.getTargetSystemPosition()).getX();
        double dYi = ((Position)prevCenterOfMasses.getTargetSystemPosition()).getY() - ((Position)centerOfMasses.getTargetSystemPosition()).getY();
        double dZi = ((Position)prevCenterOfMasses.getTargetSystemPosition()).getZ() - ((Position)centerOfMasses.getTargetSystemPosition()).getZ();
        double smxP = s11 * dxi + s12 * dyi + s13 * dzi;
        double smyP = s22 * dyi + s23 * dzi;
        double smzP = s33 * dzi;
        Tx.setValue(tx + dXi + (r11 * smxP + r12 * smyP + r13 * smzP));
        Ty.setValue(ty + dYi + (r21 * smxP + r22 * smyP + r23 * smzP));
        Tz.setValue(tz + dZi + (r31 * smxP + r32 * smyP + r33 * smzP));
    }

    @Override
    public void reverseCenterOfMasses(UpperSymmPackMatrix Dp) {
        SimplePositionPair centerOfMasses = this.getCenterOfMasses();
        double xi = -((Position)centerOfMasses.getSourceSystemPosition()).getX();
        double yi = -((Position)centerOfMasses.getSourceSystemPosition()).getY();
        double zi = -((Position)centerOfMasses.getSourceSystemPosition()).getZ();
        double Xi = ((Position)centerOfMasses.getTargetSystemPosition()).getX();
        double Yi = ((Position)centerOfMasses.getTargetSystemPosition()).getY();
        double Zi = ((Position)centerOfMasses.getTargetSystemPosition()).getZ();
        UnknownParameter Tx = this.parameters.get((Object)ParameterType.SHIFT_X);
        UnknownParameter Ty = this.parameters.get((Object)ParameterType.SHIFT_Y);
        UnknownParameter Tz = this.parameters.get((Object)ParameterType.SHIFT_Z);
        UnknownParameter Q0 = this.parameters.get((Object)ParameterType.QUATERNION_Q0);
        UnknownParameter Q1 = this.parameters.get((Object)ParameterType.QUATERNION_Q1);
        UnknownParameter Q2 = this.parameters.get((Object)ParameterType.QUATERNION_Q2);
        UnknownParameter Q3 = this.parameters.get((Object)ParameterType.QUATERNION_Q3);
        UnknownParameter S11 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_11);
        UnknownParameter S12 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_12);
        UnknownParameter S13 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_13);
        UnknownParameter S22 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_22);
        UnknownParameter S23 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_23);
        UnknownParameter S33 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_33);
        double tx = Tx.getValue();
        double ty = Ty.getValue();
        double tz = Tz.getValue();
        double q0 = Q0.getValue();
        double q1 = Q1.getValue();
        double q2 = Q2.getValue();
        double q3 = Q3.getValue();
        double s11 = S11.getValue();
        double s12 = S12.getValue();
        double s13 = S13.getValue();
        double s22 = S22.getValue();
        double s23 = S23.getValue();
        double s33 = S33.getValue();
        double r11 = 2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1;
        double r12 = 2.0 * (q1 * q2 - q0 * q3);
        double r13 = 2.0 * (q1 * q3 + q0 * q2);
        double r21 = 2.0 * (q1 * q2 + q0 * q3);
        double r22 = 2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2;
        double r23 = 2.0 * (q2 * q3 - q0 * q1);
        double r31 = 2.0 * (q1 * q3 - q0 * q2);
        double r32 = 2.0 * (q2 * q3 + q0 * q1);
        double r33 = 2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3;
        double smxP = s11 * xi + s12 * yi + s13 * zi;
        double smyP = s22 * yi + s23 * zi;
        double smzP = s33 * zi;
        Tx.setValue(tx + Xi + (r11 * smxP + r12 * smyP + r13 * smzP));
        Ty.setValue(ty + Yi + (r21 * smxP + r22 * smyP + r23 * smzP));
        Tz.setValue(tz + Zi + (r31 * smxP + r32 * smyP + r33 * smzP));
        ((Position)centerOfMasses.getSourceSystemPosition()).setX(0.0);
        ((Position)centerOfMasses.getSourceSystemPosition()).setY(0.0);
        ((Position)centerOfMasses.getSourceSystemPosition()).setZ(0.0);
        ((Position)centerOfMasses.getTargetSystemPosition()).setX(0.0);
        ((Position)centerOfMasses.getTargetSystemPosition()).setY(0.0);
        ((Position)centerOfMasses.getTargetSystemPosition()).setZ(0.0);
        int nou = Dp.numColumns();
        DenseMatrix Jx = Matrices.identity((int)nou);
        this.normalEquationElements(new HomologousFramePositionPair(centerOfMasses.getName(), xi, yi, zi, Xi, Yi, Zi), (Matrix)Jx, null, null, null);
        DenseMatrix DpJxT = new DenseMatrix(nou, nou);
        Dp.transBmult((Matrix)Jx, (Matrix)DpJxT);
        Jx.mult((Matrix)DpJxT, (Matrix)Dp);
    }

    @Override
    public void normalEquationElements(PositionPair<? extends DispersionablePosition, ? extends AdjustablePosition> positionPair, Matrix Jx, Matrix JvSrc, Matrix JvTrg, Vector w) {
        int rowIndex;
        SimplePositionPair centerOfMasses = this.getCenterOfMasses();
        DispersionablePosition pointSourceCRS = positionPair.getSourceSystemPosition();
        AdjustablePosition pointTargetCRS = positionPair.getTargetSystemPosition();
        double xi = pointSourceCRS.getX() - ((Position)centerOfMasses.getSourceSystemPosition()).getX();
        double yi = pointSourceCRS.getY() - ((Position)centerOfMasses.getSourceSystemPosition()).getY();
        double zi = pointSourceCRS.getZ() - ((Position)centerOfMasses.getSourceSystemPosition()).getZ();
        double Xi = pointTargetCRS.getX() - ((Position)centerOfMasses.getTargetSystemPosition()).getX();
        double Yi = pointTargetCRS.getY() - ((Position)centerOfMasses.getTargetSystemPosition()).getY();
        double Zi = pointTargetCRS.getZ() - ((Position)centerOfMasses.getTargetSystemPosition()).getZ();
        UnknownParameter Tx = this.getUnknownParameter(ParameterType.SHIFT_X);
        UnknownParameter Ty = this.getUnknownParameter(ParameterType.SHIFT_Y);
        UnknownParameter Tz = this.getUnknownParameter(ParameterType.SHIFT_Z);
        UnknownParameter Q0 = this.getUnknownParameter(ParameterType.QUATERNION_Q0);
        UnknownParameter Q1 = this.getUnknownParameter(ParameterType.QUATERNION_Q1);
        UnknownParameter Q2 = this.getUnknownParameter(ParameterType.QUATERNION_Q2);
        UnknownParameter Q3 = this.getUnknownParameter(ParameterType.QUATERNION_Q3);
        UnknownParameter S11 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_11);
        UnknownParameter S12 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_12);
        UnknownParameter S13 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_13);
        UnknownParameter S22 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_22);
        UnknownParameter S23 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_23);
        UnknownParameter S33 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_33);
        double tx = Tx.getValue();
        double ty = Ty.getValue();
        double tz = Tz.getValue();
        double q0 = Q0.getValue();
        double q1 = Q1.getValue();
        double q2 = Q2.getValue();
        double q3 = Q3.getValue();
        double s11 = S11.getValue();
        double s12 = S12.getValue();
        double s13 = S13.getValue();
        double s22 = S22.getValue();
        double s23 = S23.getValue();
        double s33 = S33.getValue();
        double r11 = 2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1;
        double r12 = 2.0 * (q1 * q2 - q0 * q3);
        double r13 = 2.0 * (q1 * q3 + q0 * q2);
        double r21 = 2.0 * (q1 * q2 + q0 * q3);
        double r22 = 2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2;
        double r23 = 2.0 * (q2 * q3 - q0 * q1);
        double r31 = 2.0 * (q1 * q3 - q0 * q2);
        double r32 = 2.0 * (q2 * q3 + q0 * q1);
        double r33 = 2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3;
        double smxP = s11 * xi + s12 * yi + s13 * zi;
        double smyP = s22 * yi + s23 * zi;
        double smzP = s33 * zi;
        if (Jx != null) {
            rowIndex = 0;
            if (Tx.getColumn() >= 0) {
                Jx.set(rowIndex, Tx.getColumn(), 1.0);
            }
            if (Ty.getColumn() >= 0) {
                Jx.set(rowIndex, Ty.getColumn(), 0.0);
            }
            if (Tz.getColumn() >= 0) {
                Jx.set(rowIndex, Tz.getColumn(), 0.0);
            }
            if (Q0.getColumn() >= 0) {
                Jx.set(rowIndex, Q0.getColumn(), 2.0 * (2.0 * q0 * smxP - q3 * smyP + q2 * smzP));
            }
            if (Q1.getColumn() >= 0) {
                Jx.set(rowIndex, Q1.getColumn(), 2.0 * (2.0 * q1 * smxP + q2 * smyP + q3 * smzP));
            }
            if (Q2.getColumn() >= 0) {
                Jx.set(rowIndex, Q2.getColumn(), 2.0 * (q1 * smyP + q0 * smzP));
            }
            if (Q3.getColumn() >= 0) {
                Jx.set(rowIndex, Q3.getColumn(), 2.0 * (q1 * smzP - q0 * smyP));
            }
            if (S11.getColumn() >= 0) {
                Jx.set(rowIndex, S11.getColumn(), r11 * xi);
            }
            if (S12.getColumn() >= 0) {
                Jx.set(rowIndex, S12.getColumn(), r11 * yi);
            }
            if (S13.getColumn() >= 0) {
                Jx.set(rowIndex, S13.getColumn(), r11 * zi);
            }
            if (S22.getColumn() >= 0) {
                Jx.set(rowIndex, S22.getColumn(), r12 * yi);
            }
            if (S23.getColumn() >= 0) {
                Jx.set(rowIndex, S23.getColumn(), r12 * zi);
            }
            if (S33.getColumn() >= 0) {
                Jx.set(rowIndex, S33.getColumn(), r13 * zi);
            }
            ++rowIndex;
            if (Tx.getColumn() >= 0) {
                Jx.set(rowIndex, Tx.getColumn(), 0.0);
            }
            if (Ty.getColumn() >= 0) {
                Jx.set(rowIndex, Ty.getColumn(), 1.0);
            }
            if (Tz.getColumn() >= 0) {
                Jx.set(rowIndex, Tz.getColumn(), 0.0);
            }
            if (Q0.getColumn() >= 0) {
                Jx.set(rowIndex, Q0.getColumn(), 2.0 * (q3 * smxP + 2.0 * q0 * smyP - q1 * smzP));
            }
            if (Q1.getColumn() >= 0) {
                Jx.set(rowIndex, Q1.getColumn(), 2.0 * (q2 * smxP - q0 * smzP));
            }
            if (Q2.getColumn() >= 0) {
                Jx.set(rowIndex, Q2.getColumn(), 2.0 * (q1 * smxP + 2.0 * q2 * smyP + q3 * smzP));
            }
            if (Q3.getColumn() >= 0) {
                Jx.set(rowIndex, Q3.getColumn(), 2.0 * (q0 * smxP + q2 * smzP));
            }
            if (S11.getColumn() >= 0) {
                Jx.set(rowIndex, S11.getColumn(), r21 * xi);
            }
            if (S12.getColumn() >= 0) {
                Jx.set(rowIndex, S12.getColumn(), r21 * yi);
            }
            if (S13.getColumn() >= 0) {
                Jx.set(rowIndex, S13.getColumn(), r21 * zi);
            }
            if (S22.getColumn() >= 0) {
                Jx.set(rowIndex, S22.getColumn(), r22 * yi);
            }
            if (S23.getColumn() >= 0) {
                Jx.set(rowIndex, S23.getColumn(), r22 * zi);
            }
            if (S33.getColumn() >= 0) {
                Jx.set(rowIndex, S33.getColumn(), r23 * zi);
            }
            ++rowIndex;
            if (Tx.getColumn() >= 0) {
                Jx.set(rowIndex, Tx.getColumn(), 0.0);
            }
            if (Ty.getColumn() >= 0) {
                Jx.set(rowIndex, Ty.getColumn(), 0.0);
            }
            if (Tz.getColumn() >= 0) {
                Jx.set(rowIndex, Tz.getColumn(), 1.0);
            }
            if (Q0.getColumn() >= 0) {
                Jx.set(rowIndex, Q0.getColumn(), 2.0 * (q1 * smyP - q2 * smxP + 2.0 * q0 * smzP));
            }
            if (Q1.getColumn() >= 0) {
                Jx.set(rowIndex, Q1.getColumn(), 2.0 * (q3 * smxP + q0 * smyP));
            }
            if (Q2.getColumn() >= 0) {
                Jx.set(rowIndex, Q2.getColumn(), 2.0 * (q3 * smyP - q0 * smxP));
            }
            if (Q3.getColumn() >= 0) {
                Jx.set(rowIndex, Q3.getColumn(), 2.0 * (q1 * smxP + q2 * smyP + 2.0 * q3 * smzP));
            }
            if (S11.getColumn() >= 0) {
                Jx.set(rowIndex, S11.getColumn(), r31 * xi);
            }
            if (S12.getColumn() >= 0) {
                Jx.set(rowIndex, S12.getColumn(), r31 * yi);
            }
            if (S13.getColumn() >= 0) {
                Jx.set(rowIndex, S13.getColumn(), r31 * zi);
            }
            if (S22.getColumn() >= 0) {
                Jx.set(rowIndex, S22.getColumn(), r32 * yi);
            }
            if (S23.getColumn() >= 0) {
                Jx.set(rowIndex, S23.getColumn(), r32 * zi);
            }
            if (S33.getColumn() >= 0) {
                Jx.set(rowIndex, S33.getColumn(), r33 * zi);
            }
        }
        if (JvSrc != null) {
            rowIndex = 0;
            JvSrc.set(rowIndex, 0, r11 * s11);
            JvSrc.set(rowIndex, 1, r11 * s12 + r12 * s22);
            JvSrc.set(rowIndex, 2, r11 * s13 + r12 * s23 + r13 * s33);
            JvSrc.set(++rowIndex, 0, r21 * s11);
            JvSrc.set(rowIndex, 1, r21 * s12 + r22 * s22);
            JvSrc.set(rowIndex, 2, r21 * s13 + r22 * s23 + r23 * s33);
            JvSrc.set(++rowIndex, 0, r31 * s11);
            JvSrc.set(rowIndex, 1, r31 * s12 + r32 * s22);
            JvSrc.set(rowIndex, 2, r31 * s13 + r32 * s23 + r33 * s33);
        }
        if (JvTrg != null) {
            rowIndex = 0;
            JvTrg.set(rowIndex, 0, -1.0);
            JvTrg.set(rowIndex, 1, 0.0);
            JvTrg.set(rowIndex, 2, 0.0);
            JvTrg.set(++rowIndex, 0, 0.0);
            JvTrg.set(rowIndex, 1, -1.0);
            JvTrg.set(rowIndex, 2, 0.0);
            JvTrg.set(++rowIndex, 0, 0.0);
            JvTrg.set(rowIndex, 1, 0.0);
            JvTrg.set(rowIndex, 2, -1.0);
        }
        if (w != null) {
            rowIndex = 0;
            w.set(rowIndex++, tx + (r11 * smxP + r12 * smyP + r13 * smzP) - Xi);
            w.set(rowIndex++, ty + (r21 * smxP + r22 * smyP + r23 * smzP) - Yi);
            w.set(rowIndex++, tz + (r31 * smxP + r32 * smyP + r33 * smzP) - Zi);
        }
    }

    private void init() {
        this.parameters = new LinkedHashMap<ParameterType, UnknownParameter>();
        this.parameters.put(ParameterType.SHIFT_X, new UnknownParameter(ParameterType.SHIFT_X, true, 0.0));
        this.parameters.put(ParameterType.SHIFT_Y, new UnknownParameter(ParameterType.SHIFT_Y, true, 0.0));
        this.parameters.put(ParameterType.SHIFT_Z, new UnknownParameter(ParameterType.SHIFT_Z, true, 0.0));
        this.parameters.put(ParameterType.QUATERNION_Q0, new UnknownParameter(ParameterType.QUATERNION_Q0, true, 1.0));
        this.parameters.put(ParameterType.QUATERNION_Q1, new UnknownParameter(ParameterType.QUATERNION_Q1, true, 0.0));
        this.parameters.put(ParameterType.QUATERNION_Q2, new UnknownParameter(ParameterType.QUATERNION_Q2, true, 0.0));
        this.parameters.put(ParameterType.QUATERNION_Q3, new UnknownParameter(ParameterType.QUATERNION_Q3, true, 0.0));
        this.parameters.put(ParameterType.AUXILIARY_ELEMENT_11, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_11, true, 1.0));
        this.parameters.put(ParameterType.AUXILIARY_ELEMENT_12, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_12, true, 0.0));
        this.parameters.put(ParameterType.AUXILIARY_ELEMENT_13, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_13, true, 0.0));
        this.parameters.put(ParameterType.AUXILIARY_ELEMENT_22, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_22, true, 1.0));
        this.parameters.put(ParameterType.AUXILIARY_ELEMENT_23, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_23, true, 0.0));
        this.parameters.put(ParameterType.AUXILIARY_ELEMENT_33, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_33, true, 1.0));
        this.parameters.put(ParameterType.VECTOR_LENGTH, new UnknownParameter(ParameterType.VECTOR_LENGTH, true, 1.0, false, ProcessingType.FIXED));
        UnknownParameter q0 = this.parameters.get((Object)ParameterType.QUATERNION_Q0);
        UnknownParameter q1 = this.parameters.get((Object)ParameterType.QUATERNION_Q1);
        UnknownParameter q2 = this.parameters.get((Object)ParameterType.QUATERNION_Q2);
        UnknownParameter q3 = this.parameters.get((Object)ParameterType.QUATERNION_Q3);
        UnknownParameter quaternionLength = this.parameters.get((Object)ParameterType.VECTOR_LENGTH);
        List<UnknownParameter> unitQuaternion = List.of(q0, q1, q2, q3);
        this.quaternionLengthRestriction = new ProductSumRestriction(true, unitQuaternion, unitQuaternion, List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), quaternionLength);
    }

    @Override
    public Collection<Restriction> getRestrictions() {
        return List.of(this.quaternionLengthRestriction);
    }

    @Override
    public Collection<UnknownParameter> getUnknownParameters() {
        return this.parameters.values();
    }

    @Override
    public UnknownParameter getUnknownParameter(ParameterType parameterType) {
        return this.parameters.get((Object)parameterType);
    }

    @Override
    public TransformationType getTransformationType() {
        return TransformationType.SPATIAL;
    }

    @Override
    public Matrix getHomogeneousCoordinateTransformationMatrix() {
        double tx = this.getUnknownParameter(ParameterType.SHIFT_X).getValue();
        double ty = this.getUnknownParameter(ParameterType.SHIFT_Y).getValue();
        double tz = this.getUnknownParameter(ParameterType.SHIFT_Z).getValue();
        double q0 = this.getUnknownParameter(ParameterType.QUATERNION_Q0).getValue();
        double q1 = this.getUnknownParameter(ParameterType.QUATERNION_Q1).getValue();
        double q2 = this.getUnknownParameter(ParameterType.QUATERNION_Q2).getValue();
        double q3 = this.getUnknownParameter(ParameterType.QUATERNION_Q3).getValue();
        double s11 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_11).getValue();
        double s12 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_12).getValue();
        double s13 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_13).getValue();
        double s22 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_22).getValue();
        double s23 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_23).getValue();
        double s33 = this.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_33).getValue();
        double r11 = 2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1;
        double r12 = 2.0 * (q1 * q2 - q0 * q3);
        double r13 = 2.0 * (q1 * q3 + q0 * q2);
        double r21 = 2.0 * (q1 * q2 + q0 * q3);
        double r22 = 2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2;
        double r23 = 2.0 * (q2 * q3 - q0 * q1);
        double r31 = 2.0 * (q1 * q3 - q0 * q2);
        double r32 = 2.0 * (q2 * q3 + q0 * q1);
        double r33 = 2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3;
        return new DenseMatrix((double[][])new double[][]{{r11 * s11, r11 * s12 + r12 * s22, r11 * s13 + r12 * s23 + r13 * s33, tx}, {r21 * s11, r21 * s12 + r22 * s22, r21 * s13 + r22 * s23 + r23 * s33, ty}, {r31 * s11, r31 * s12 + r32 * s22, r31 * s13 + r32 * s23 + r33 * s33, tz}, {0.0, 0.0, 0.0, 1.0}});
    }

    @Override
    public Matrix getRotationMatrix() {
        double q0 = this.getUnknownParameter(ParameterType.QUATERNION_Q0).getValue();
        double q1 = this.getUnknownParameter(ParameterType.QUATERNION_Q1).getValue();
        double q2 = this.getUnknownParameter(ParameterType.QUATERNION_Q2).getValue();
        double q3 = this.getUnknownParameter(ParameterType.QUATERNION_Q3).getValue();
        double r11 = 2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1;
        double r12 = 2.0 * (q1 * q2 - q0 * q3);
        double r13 = 2.0 * (q1 * q3 + q0 * q2);
        double r21 = 2.0 * (q1 * q2 + q0 * q3);
        double r22 = 2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2;
        double r23 = 2.0 * (q2 * q3 - q0 * q1);
        double r31 = 2.0 * (q1 * q3 - q0 * q2);
        double r32 = 2.0 * (q2 * q3 + q0 * q1);
        double r33 = 2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3;
        return new DenseMatrix((double[][])new double[][]{{r11, r12, r13}, {r21, r22, r23}, {r31, r32, r33}});
    }
}

