/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.equation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.transformation.TransformationType;
import org.applied_geodesy.adjustment.transformation.equation.TransformationEquations;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.AdjustablePosition;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.Position;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;
import org.applied_geodesy.adjustment.transformation.point.SimplePositionPair;

public class PlanarAffineEquations
extends TransformationEquations {
    private Map<ParameterType, UnknownParameter> parameters = null;

    public PlanarAffineEquations() {
        this.init();
    }

    public void setInitialGuess(double tx, double ty, double a11, double a12, double a21, double a22) throws IllegalArgumentException {
        this.parameters.get((Object)ParameterType.SHIFT_X).setValue0(tx);
        this.parameters.get((Object)ParameterType.SHIFT_Y).setValue0(ty);
        this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_11).setValue0(a11);
        this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_12).setValue0(a12);
        this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_21).setValue0(a21);
        this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_22).setValue0(a22);
    }

    @Override
    public void setCenterOfMasses(SimplePositionPair centerOfMasses) {
        SimplePositionPair prevCenterOfMasses = this.getCenterOfMasses();
        boolean equalComponents = centerOfMasses.equalsCoordinateComponents(prevCenterOfMasses);
        super.setCenterOfMasses(centerOfMasses);
        if (equalComponents) {
            return;
        }
        UnknownParameter Tx = this.parameters.get((Object)ParameterType.SHIFT_X);
        UnknownParameter Ty = this.parameters.get((Object)ParameterType.SHIFT_Y);
        UnknownParameter A11 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_11);
        UnknownParameter A12 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_12);
        UnknownParameter A21 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_21);
        UnknownParameter A22 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_22);
        double tx = Tx.getValue();
        double ty = Ty.getValue();
        double a11 = A11.getValue();
        double a12 = A12.getValue();
        double a21 = A21.getValue();
        double a22 = A22.getValue();
        double dxi = -(((Position)prevCenterOfMasses.getSourceSystemPosition()).getX() - ((Position)centerOfMasses.getSourceSystemPosition()).getX());
        double dyi = -(((Position)prevCenterOfMasses.getSourceSystemPosition()).getY() - ((Position)centerOfMasses.getSourceSystemPosition()).getY());
        double dXi = ((Position)prevCenterOfMasses.getTargetSystemPosition()).getX() - ((Position)centerOfMasses.getTargetSystemPosition()).getX();
        double dYi = ((Position)prevCenterOfMasses.getTargetSystemPosition()).getY() - ((Position)centerOfMasses.getTargetSystemPosition()).getY();
        Tx.setValue(tx + dXi + a11 * dxi - a12 * dyi);
        Ty.setValue(ty + dYi + a21 * dxi + a22 * dyi);
    }

    @Override
    public void reverseCenterOfMasses(UpperSymmPackMatrix Dp) {
        SimplePositionPair centerOfMasses = this.getCenterOfMasses();
        double xi = -((Position)centerOfMasses.getSourceSystemPosition()).getX();
        double yi = -((Position)centerOfMasses.getSourceSystemPosition()).getY();
        double Xi = ((Position)centerOfMasses.getTargetSystemPosition()).getX();
        double Yi = ((Position)centerOfMasses.getTargetSystemPosition()).getY();
        UnknownParameter Tx = this.parameters.get((Object)ParameterType.SHIFT_X);
        UnknownParameter Ty = this.parameters.get((Object)ParameterType.SHIFT_Y);
        UnknownParameter A11 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_11);
        UnknownParameter A12 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_12);
        UnknownParameter A21 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_21);
        UnknownParameter A22 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_22);
        double tx = Tx.getValue();
        double ty = Ty.getValue();
        double a11 = A11.getValue();
        double a12 = A12.getValue();
        double a21 = A21.getValue();
        double a22 = A22.getValue();
        Tx.setValue(tx + Xi + a11 * xi - a12 * yi);
        Ty.setValue(ty + Yi + a21 * xi + a22 * yi);
        ((Position)centerOfMasses.getSourceSystemPosition()).setX(0.0);
        ((Position)centerOfMasses.getSourceSystemPosition()).setY(0.0);
        ((Position)centerOfMasses.getTargetSystemPosition()).setX(0.0);
        ((Position)centerOfMasses.getTargetSystemPosition()).setY(0.0);
        int nou = Dp.numColumns();
        DenseMatrix Jx = Matrices.identity((int)nou);
        this.normalEquationElements(new HomologousFramePositionPair(centerOfMasses.getName(), xi, yi, Xi, Yi), (Matrix)Jx, null, null, null);
        DenseMatrix DpJxT = new DenseMatrix(nou, nou);
        Dp.transBmult((Matrix)Jx, (Matrix)DpJxT);
        Jx.mult((Matrix)DpJxT, (Matrix)Dp);
    }

    @Override
    public void normalEquationElements(PositionPair<? extends DispersionablePosition, ? extends AdjustablePosition> positionPair, Matrix Jx, Matrix JvSrc, Matrix JvTrg, Vector w) {
        int rowIndex;
        SimplePositionPair centerOfMasses = this.getCenterOfMasses();
        DispersionablePosition pointSourceCRS = positionPair.getSourceSystemPosition();
        AdjustablePosition pointTargetCRS = positionPair.getTargetSystemPosition();
        double xi = pointSourceCRS.getX() - ((Position)centerOfMasses.getSourceSystemPosition()).getX();
        double yi = pointSourceCRS.getY() - ((Position)centerOfMasses.getSourceSystemPosition()).getY();
        double Xi = pointTargetCRS.getX() - ((Position)centerOfMasses.getTargetSystemPosition()).getX();
        double Yi = pointTargetCRS.getY() - ((Position)centerOfMasses.getTargetSystemPosition()).getY();
        UnknownParameter Tx = this.parameters.get((Object)ParameterType.SHIFT_X);
        UnknownParameter Ty = this.parameters.get((Object)ParameterType.SHIFT_Y);
        UnknownParameter A11 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_11);
        UnknownParameter A12 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_12);
        UnknownParameter A21 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_21);
        UnknownParameter A22 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_22);
        double tx = Tx.getValue();
        double ty = Ty.getValue();
        double a11 = A11.getValue();
        double a12 = A12.getValue();
        double a21 = A21.getValue();
        double a22 = A22.getValue();
        if (Jx != null) {
            rowIndex = 0;
            if (Tx.getColumn() >= 0) {
                Jx.set(rowIndex, Tx.getColumn(), 1.0);
            }
            if (Ty.getColumn() >= 0) {
                Jx.set(rowIndex, Ty.getColumn(), 0.0);
            }
            if (A11.getColumn() >= 0) {
                Jx.set(rowIndex, A11.getColumn(), xi);
            }
            if (A12.getColumn() >= 0) {
                Jx.set(rowIndex, A12.getColumn(), -yi);
            }
            ++rowIndex;
            if (Tx.getColumn() >= 0) {
                Jx.set(rowIndex, Tx.getColumn(), 0.0);
            }
            if (Ty.getColumn() >= 0) {
                Jx.set(rowIndex, Ty.getColumn(), 1.0);
            }
            if (A21.getColumn() >= 0) {
                Jx.set(rowIndex, A21.getColumn(), xi);
            }
            if (A22.getColumn() >= 0) {
                Jx.set(rowIndex, A22.getColumn(), yi);
            }
        }
        if (JvSrc != null) {
            rowIndex = 0;
            JvSrc.set(rowIndex, 0, a11);
            JvSrc.set(rowIndex, 1, -a12);
            JvSrc.set(++rowIndex, 0, a21);
            JvSrc.set(rowIndex, 1, a22);
        }
        if (JvTrg != null) {
            rowIndex = 0;
            JvTrg.set(rowIndex, 0, -1.0);
            JvTrg.set(rowIndex, 1, 0.0);
            JvTrg.set(++rowIndex, 0, 0.0);
            JvTrg.set(rowIndex, 1, -1.0);
        }
        if (w != null) {
            rowIndex = 0;
            w.set(rowIndex++, tx + a11 * xi - a12 * yi - Xi);
            w.set(rowIndex++, ty + a21 * xi + a22 * yi - Yi);
        }
    }

    private void init() {
        this.parameters = new LinkedHashMap<ParameterType, UnknownParameter>();
        this.parameters.put(ParameterType.SHIFT_X, new UnknownParameter(ParameterType.SHIFT_X, true, 0.0));
        this.parameters.put(ParameterType.SHIFT_Y, new UnknownParameter(ParameterType.SHIFT_Y, true, 0.0));
        this.parameters.put(ParameterType.AUXILIARY_ELEMENT_11, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_11, true, 1.0));
        this.parameters.put(ParameterType.AUXILIARY_ELEMENT_12, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_12, true, 0.0));
        this.parameters.put(ParameterType.AUXILIARY_ELEMENT_21, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_21, true, 1.0));
        this.parameters.put(ParameterType.AUXILIARY_ELEMENT_22, new UnknownParameter(ParameterType.AUXILIARY_ELEMENT_22, true, 1.0));
    }

    @Override
    public Collection<UnknownParameter> getUnknownParameters() {
        return this.parameters.values();
    }

    @Override
    public UnknownParameter getUnknownParameter(ParameterType parameterType) {
        return this.parameters.get((Object)parameterType);
    }

    @Override
    public TransformationType getTransformationType() {
        return TransformationType.PLANAR;
    }

    @Override
    public Matrix getHomogeneousCoordinateTransformationMatrix() {
        double tx = this.parameters.get((Object)ParameterType.SHIFT_X).getValue();
        double ty = this.parameters.get((Object)ParameterType.SHIFT_Y).getValue();
        double a11 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_11).getValue();
        double a12 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_12).getValue();
        double a21 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_21).getValue();
        double a22 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_22).getValue();
        return new DenseMatrix((double[][])new double[][]{{a11, -a12, tx}, {a21, a22, ty}, {0.0, 0.0, 1.0}});
    }

    @Override
    public Matrix getRotationMatrix() {
        double a11 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_11).getValue();
        double a21 = this.parameters.get((Object)ParameterType.AUXILIARY_ELEMENT_21).getValue();
        double r = Math.atan2(a21, a11);
        return new DenseMatrix((double[][])new double[][]{{Math.cos(r), -Math.sin(r)}, {Math.sin(r), Math.cos(r)}});
    }
}

