/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation.equation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.TransformationType;
import org.applied_geodesy.adjustment.transformation.equation.TransformationEquations;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.AdjustablePosition;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.Position;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;
import org.applied_geodesy.adjustment.transformation.point.SimplePositionPair;

public class HeightEquations
extends TransformationEquations {
    private Map<ParameterType, UnknownParameter> parameters = null;

    public HeightEquations() {
        this.init();
    }

    public void setInitialGuess(double tz, double scale) throws IllegalArgumentException {
        this.parameters.get((Object)ParameterType.SHIFT_Z).setValue0(tz);
        this.parameters.get((Object)ParameterType.SCALE_Z).setValue0(scale);
    }

    @Override
    public void setCenterOfMasses(SimplePositionPair centerOfMasses) {
        SimplePositionPair prevCenterOfMasses = this.getCenterOfMasses();
        boolean equalComponents = centerOfMasses.equalsCoordinateComponents(prevCenterOfMasses);
        super.setCenterOfMasses(centerOfMasses);
        if (equalComponents) {
            return;
        }
        UnknownParameter Tz = this.parameters.get((Object)ParameterType.SHIFT_Z);
        UnknownParameter Mz = this.parameters.get((Object)ParameterType.SCALE_Z);
        double tz = Tz.getValue();
        double mz = Mz.getValue();
        double dzi = -(((Position)prevCenterOfMasses.getSourceSystemPosition()).getZ() - ((Position)centerOfMasses.getSourceSystemPosition()).getZ());
        double dZi = ((Position)prevCenterOfMasses.getTargetSystemPosition()).getZ() - ((Position)centerOfMasses.getTargetSystemPosition()).getZ();
        Tz.setValue(tz + dZi + mz * dzi);
    }

    @Override
    public void reverseCenterOfMasses(UpperSymmPackMatrix Dp) {
        SimplePositionPair centerOfMasses = this.getCenterOfMasses();
        double zi = -((Position)centerOfMasses.getSourceSystemPosition()).getZ();
        double Zi = ((Position)centerOfMasses.getTargetSystemPosition()).getZ();
        UnknownParameter Tz = this.parameters.get((Object)ParameterType.SHIFT_Z);
        UnknownParameter Mz = this.parameters.get((Object)ParameterType.SCALE_Z);
        double tz = Tz.getValue();
        double mz = Mz.getValue();
        Tz.setValue(tz + Zi + mz * zi);
        ((Position)centerOfMasses.getSourceSystemPosition()).setZ(0.0);
        ((Position)centerOfMasses.getTargetSystemPosition()).setZ(0.0);
        int nou = Dp.numColumns();
        DenseMatrix Jx = Matrices.identity((int)nou);
        this.normalEquationElements(new HomologousFramePositionPair(centerOfMasses.getName(), zi, Zi), (Matrix)Jx, null, null, null);
        DenseMatrix DpJxT = new DenseMatrix(nou, nou);
        Dp.transBmult((Matrix)Jx, (Matrix)DpJxT);
        Jx.mult((Matrix)DpJxT, (Matrix)Dp);
    }

    @Override
    public void normalEquationElements(PositionPair<? extends DispersionablePosition, ? extends AdjustablePosition> positionPair, Matrix Jx, Matrix JvSrc, Matrix JvTrg, Vector w) {
        int rowIndex;
        SimplePositionPair centerOfMasses = this.getCenterOfMasses();
        DispersionablePosition pointSourceCRS = positionPair.getSourceSystemPosition();
        AdjustablePosition pointTargetCRS = positionPair.getTargetSystemPosition();
        double zi = pointSourceCRS.getZ() - ((Position)centerOfMasses.getSourceSystemPosition()).getZ();
        double Zi = pointTargetCRS.getZ() - ((Position)centerOfMasses.getTargetSystemPosition()).getZ();
        UnknownParameter Tz = this.parameters.get((Object)ParameterType.SHIFT_Z);
        UnknownParameter Mz = this.parameters.get((Object)ParameterType.SCALE_Z);
        double tz = Tz.getValue();
        double mz = Mz.getValue();
        if (Jx != null) {
            rowIndex = 0;
            if (Tz.getColumn() >= 0) {
                Jx.set(rowIndex, Tz.getColumn(), 1.0);
            }
            if (Mz.getColumn() >= 0) {
                Jx.set(rowIndex, Mz.getColumn(), zi);
            }
        }
        if (JvSrc != null) {
            rowIndex = 0;
            JvSrc.set(rowIndex, 0, mz);
        }
        if (JvTrg != null) {
            rowIndex = 0;
            JvTrg.set(rowIndex, 0, -1.0);
        }
        if (w != null) {
            rowIndex = 0;
            w.set(rowIndex, tz + mz * zi - Zi);
        }
    }

    private void init() {
        this.parameters = new LinkedHashMap<ParameterType, UnknownParameter>();
        this.parameters.put(ParameterType.SHIFT_Z, new UnknownParameter(ParameterType.SHIFT_Z, true, 0.0));
        this.parameters.put(ParameterType.SCALE_Z, new UnknownParameter(ParameterType.SCALE_Z, true, 1.0));
    }

    @Override
    public Collection<UnknownParameter> getUnknownParameters() {
        return this.parameters.values();
    }

    @Override
    public UnknownParameter getUnknownParameter(ParameterType parameterType) {
        return this.parameters.get((Object)parameterType);
    }

    @Override
    public TransformationType getTransformationType() {
        return TransformationType.HEIGHT;
    }

    @Override
    public Matrix getHomogeneousCoordinateTransformationMatrix() {
        double tz = this.parameters.get((Object)ParameterType.SHIFT_Z).getValue();
        double mz = this.parameters.get((Object)ParameterType.SCALE_Z).getValue();
        return new DenseMatrix((double[][])new double[][]{{mz, tz}, {0.0, 1.0}});
    }

    @Override
    public Matrix getRotationMatrix() {
        return MathExtension.identity(1);
    }
}

