/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.UpperSymmBandMatrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.DefaultValue;
import org.applied_geodesy.adjustment.EstimationStateType;
import org.applied_geodesy.adjustment.EstimationType;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.NormalEquationSystem;
import org.applied_geodesy.adjustment.statistic.BaardaMethodTestStatistic;
import org.applied_geodesy.adjustment.statistic.SidakTestStatistic;
import org.applied_geodesy.adjustment.statistic.TestStatisticDefinition;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameters;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;
import org.applied_geodesy.adjustment.statistic.UnadjustedTestStatitic;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.TransformationChangeListener;
import org.applied_geodesy.adjustment.transformation.TransformationEvent;
import org.applied_geodesy.adjustment.transformation.VarianceComponent;
import org.applied_geodesy.adjustment.transformation.VarianceComponentType;
import org.applied_geodesy.adjustment.transformation.equation.TransformationEquations;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.ProcessingType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.EstimatedFramePosition;
import org.applied_geodesy.adjustment.transformation.point.FramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.Position;
import org.applied_geodesy.adjustment.transformation.point.SimplePositionPair;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;
import org.applied_geodesy.util.ObservableUniqueList;

public class TransformationAdjustment {
    private final PropertyChangeSupport change = new PropertyChangeSupport(this);
    private List<EventListener> listenerList = new ArrayList<EventListener>();
    private Transformation transformation;
    private List<HomologousFramePositionPair> homologousPointPairs = new ArrayList<HomologousFramePositionPair>();
    private List<UnknownParameter> parameters = new ArrayList<UnknownParameter>();
    private List<Restriction> restrictions = new ArrayList<Restriction>();
    private TransformationEquations transformationEquations;
    private TestStatisticDefinition testStatisticDefinition = new TestStatisticDefinition();
    private TestStatisticParameters testStatisticParameters = null;
    private EstimationStateType currentEstimationStatus = EstimationStateType.BUSY;
    private EstimationType estimationType = EstimationType.L2NORM;
    private final Interrupt interrupt = new Interrupt();
    private boolean calculateStochasticParameters = false;
    private boolean adjustModelParametersOnly = false;
    private boolean preconditioning = true;
    private boolean deriveFirstAdaptedDampingValue = false;
    private int maximalNumberOfIterations = DefaultValue.getMaximumNumberOfIterations();
    private int iterationStep = 0;
    private int numberOfModelEquations = 0;
    private int numberOfUnknownParameters = 0;
    private double maxAbsDx = 0.0;
    private double maxAbsRestriction = 0.0;
    private double lastValidmaxAbsDx = 0.0;
    private double dampingValue = 0.0;
    private double adaptedDampingValue = 0.0;
    private static double SQRT_EPS = Math.sqrt(Constant.EPS);
    private VarianceComponent varianceComponentOfUnitWeight = new VarianceComponent(VarianceComponentType.GLOBAL);
    private VarianceComponent varianceComponentSourceSystem = new VarianceComponent(VarianceComponentType.SOURCE);
    private VarianceComponent varianceComponentTargetSystem = new VarianceComponent(VarianceComponentType.TARGET);
    private UpperSymmPackMatrix Qxx = null;

    public void init() {
        int dim = this.transformationEquations.getTransformationType().getDimension();
        ArrayList<HomologousFramePositionPair> nonUniqueHomologousFramePositionPairs = new ArrayList<HomologousFramePositionPair>((Collection<HomologousFramePositionPair>)((Object)this.transformationEquations.getHomologousFramePositionPairs()));
        LinkedHashSet<HomologousFramePositionPair> uniqueHomologousFramePositionPairs = new LinkedHashSet<HomologousFramePositionPair>(nonUniqueHomologousFramePositionPairs);
        nonUniqueHomologousFramePositionPairs.clear();
        for (HomologousFramePositionPair homologousPointPair : uniqueHomologousFramePositionPairs) {
            homologousPointPair.reset();
            homologousPointPair.getTestStatistic().setVarianceComponent(this.varianceComponentOfUnitWeight);
        }
        Iterator<Object> iterator = this.transformation.getFramePositionPairs().iterator();
        while (iterator.hasNext()) {
            FramePositionPair framePositionPair = (FramePositionPair)iterator.next();
            framePositionPair.reset();
            EstimatedFramePosition targetPosition = (EstimatedFramePosition)framePositionPair.getTargetSystemPosition();
            targetPosition.setX0(0.0);
            targetPosition.setY0(0.0);
            targetPosition.setZ0(0.0);
            targetPosition.setVarianceComponent(this.varianceComponentOfUnitWeight);
        }
        FilteredList enabledUniqueHomologousFramePositionPairs = new FilteredList(FXCollections.observableArrayList(uniqueHomologousFramePositionPairs));
        enabledUniqueHomologousFramePositionPairs.setPredicate((Predicate)new Predicate<HomologousFramePositionPair>(){

            @Override
            public boolean test(HomologousFramePositionPair homologousPointPair) {
                return homologousPointPair.isEnable();
            }
        });
        uniqueHomologousFramePositionPairs.clear();
        this.homologousPointPairs = new ArrayList<HomologousFramePositionPair>((Collection<HomologousFramePositionPair>)enabledUniqueHomologousFramePositionPairs);
        this.numberOfModelEquations = dim * this.homologousPointPairs.size();
        for (UnknownParameter unknownParameter : this.parameters) {
            unknownParameter.getTestStatistic().setVarianceComponent(this.varianceComponentOfUnitWeight);
        }
        this.testStatisticParameters = this.getTestStatisticParameters(this.testStatisticDefinition);
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation transformation) {
        if (this.transformation != null) {
            this.fireTransformationChanged(this.transformation, TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_REMOVED);
        }
        this.reset();
        this.transformation = transformation;
        if (this.transformation != null) {
            this.parameters = this.transformation.getUnknownParameters();
            this.restrictions = this.transformation.getRestrictions();
            this.transformationEquations = this.transformation.getTransformationEquations();
            this.fireTransformationChanged(this.transformation, TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_ADDED);
        }
    }

    private void reset() {
        this.varianceComponentOfUnitWeight.setVariance0(1.0);
        this.varianceComponentOfUnitWeight.setOmega(0.0);
        this.varianceComponentOfUnitWeight.setRedundancy(0.0);
        this.varianceComponentOfUnitWeight.setNumberOfObservations(0);
        this.varianceComponentOfUnitWeight.setSignificant(false);
        this.varianceComponentSourceSystem.setVariance0(1.0);
        this.varianceComponentSourceSystem.setOmega(0.0);
        this.varianceComponentSourceSystem.setRedundancy(0.0);
        this.varianceComponentSourceSystem.setNumberOfObservations(0);
        this.varianceComponentSourceSystem.setSignificant(false);
        this.varianceComponentSourceSystem.setApplyAposterioriVarianceOfUnitWeight(this.varianceComponentOfUnitWeight.isApplyAposterioriVarianceOfUnitWeight());
        this.varianceComponentTargetSystem.setVariance0(1.0);
        this.varianceComponentTargetSystem.setOmega(0.0);
        this.varianceComponentTargetSystem.setRedundancy(0.0);
        this.varianceComponentTargetSystem.setNumberOfObservations(0);
        this.varianceComponentTargetSystem.setSignificant(false);
        this.varianceComponentTargetSystem.setApplyAposterioriVarianceOfUnitWeight(this.varianceComponentOfUnitWeight.isApplyAposterioriVarianceOfUnitWeight());
        this.testStatisticParameters = null;
        this.transformationEquations = null;
        this.parameters.clear();
        this.restrictions.clear();
        this.homologousPointPairs.clear();
        this.Qxx = null;
    }

    private void prepareIterationProcess(SimplePositionPair centerOfMasses) throws MatrixSingularException, IllegalArgumentException, NotConvergedException {
        this.transformation.applyInitialGuess();
        ((Position)this.transformationEquations.getCenterOfMasses().getSourceSystemPosition()).setX(0.0);
        ((Position)this.transformationEquations.getCenterOfMasses().getSourceSystemPosition()).setY(0.0);
        ((Position)this.transformationEquations.getCenterOfMasses().getSourceSystemPosition()).setZ(0.0);
        ((Position)this.transformationEquations.getCenterOfMasses().getTargetSystemPosition()).setX(0.0);
        ((Position)this.transformationEquations.getCenterOfMasses().getTargetSystemPosition()).setY(0.0);
        ((Position)this.transformationEquations.getCenterOfMasses().getTargetSystemPosition()).setZ(0.0);
        if (this.transformation.isEstimateCenterOfMasses()) {
            this.transformationEquations.setCenterOfMasses(centerOfMasses);
        }
        this.numberOfUnknownParameters = 0;
        int parColumn = 0;
        for (UnknownParameter unknownParameter : this.parameters) {
            if (unknownParameter.getProcessingType() == ProcessingType.ADJUSTMENT) {
                unknownParameter.setColumn(parColumn++);
                ++this.numberOfUnknownParameters;
                continue;
            }
            unknownParameter.setColumn(-1);
        }
        for (Restriction restriction : this.restrictions) {
            restriction.setRow(parColumn++);
        }
        ObservableUniqueList<Restriction> calculations = this.transformation.getPostProcessingCalculations();
        Iterator<Object> iterator = calculations.iterator();
        while (iterator.hasNext()) {
            Restriction restriction = (Restriction)iterator.next();
            restriction.setRow(-1);
        }
        for (HomologousFramePositionPair homologousPointPair : this.homologousPointPairs) {
            homologousPointPair.reset();
        }
        this.updateResiduals((Vector)new DenseVector(this.numberOfUnknownParameters), false);
    }

    /*
     * Exception decompiling
     */
    public EstimationStateType estimateModel() throws NotConvergedException, MatrixSingularException, OutOfMemoryError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateModel(Vector dxk, boolean estimateCompleteModel) throws MatrixSingularException, IllegalArgumentException, NotConvergedException {
        Vector dx;
        Vector vector = dx = dxk.size() == this.numberOfUnknownParameters ? dxk : Matrices.getSubVector((Vector)dxk, (int[])Matrices.index((int)0, (int)this.numberOfUnknownParameters));
        if (this.adaptedDampingValue > 0.0) {
            if (this.adaptedDampingValue != 0.0) {
                double alpha = 0.25 * Math.pow(this.adaptedDampingValue, -0.05);
                alpha = Math.min(alpha, 0.75);
                dxk.scale(alpha);
            }
            double prevOmega = this.varianceComponentOfUnitWeight.getOmega();
            double curOmega = this.getOmega(dx);
            prevOmega = prevOmega <= 0.0 ? Double.MAX_VALUE : prevOmega;
            boolean lmaConverge = prevOmega >= curOmega;
            this.varianceComponentOfUnitWeight.setOmega(curOmega);
            double lastAdaptedDampingValue = this.adaptedDampingValue;
            if (lmaConverge) {
                this.adaptedDampingValue *= 0.2;
            } else {
                this.adaptedDampingValue *= 5.0;
                if (this.adaptedDampingValue > 1.0 / SQRT_EPS) {
                    this.adaptedDampingValue = 1.0 / SQRT_EPS;
                    this.varianceComponentOfUnitWeight.setOmega(0.0);
                }
            }
            this.currentEstimationStatus = EstimationStateType.LEVENBERG_MARQUARDT_STEP;
            this.change.firePropertyChange(this.currentEstimationStatus.name(), lastAdaptedDampingValue, this.adaptedDampingValue);
            if (!lmaConverge) {
                this.maxAbsDx = this.lastValidmaxAbsDx;
                dx.zero();
                return;
            }
        }
        if (this.interrupt.isInterrupted()) {
            return;
        }
        double omega = this.updateResiduals(dx, !this.adjustModelParametersOnly && (estimateCompleteModel || this.estimationType == EstimationType.L1NORM) && this.Qxx != null && this.adaptedDampingValue == 0.0);
        this.varianceComponentOfUnitWeight.setOmega(omega);
        this.lastValidmaxAbsDx = this.maxAbsDx = this.updateUnknownParameters(dx);
        if (this.interrupt.isInterrupted()) {
            return;
        }
        if (estimateCompleteModel) {
            this.reverseCenterOfMass();
            this.postProcessing();
            double varianceOfUnitWeight = this.varianceComponentOfUnitWeight.isApplyAposterioriVarianceOfUnitWeight() ? this.varianceComponentOfUnitWeight.getVariance() : this.varianceComponentOfUnitWeight.getVariance0();
            TestStatisticParameterSet vceTestStatistic = this.testStatisticParameters.getTestStatisticParameter(this.varianceComponentOfUnitWeight.getRedundancy(), Double.POSITIVE_INFINITY, Boolean.TRUE);
            double quantil = Math.max(vceTestStatistic.getQuantile(), 1.0 + Math.sqrt(Constant.EPS));
            boolean significant = this.varianceComponentOfUnitWeight.getVariance() / this.varianceComponentOfUnitWeight.getVariance0() > quantil;
            this.varianceComponentOfUnitWeight.setSignificant(significant);
            vceTestStatistic = this.testStatisticParameters.getTestStatisticParameter(this.varianceComponentSourceSystem.getRedundancy(), Double.POSITIVE_INFINITY, Boolean.TRUE);
            quantil = Math.max(vceTestStatistic.getQuantile(), 1.0 + Math.sqrt(Constant.EPS));
            significant = this.varianceComponentSourceSystem.getVariance() / this.varianceComponentSourceSystem.getVariance0() > quantil;
            this.varianceComponentSourceSystem.setSignificant(significant);
            vceTestStatistic = this.testStatisticParameters.getTestStatisticParameter(this.varianceComponentTargetSystem.getRedundancy(), Double.POSITIVE_INFINITY, Boolean.TRUE);
            quantil = Math.max(vceTestStatistic.getQuantile(), 1.0 + Math.sqrt(Constant.EPS));
            significant = this.varianceComponentTargetSystem.getVariance() / this.varianceComponentTargetSystem.getVariance0() > quantil;
            this.varianceComponentTargetSystem.setSignificant(significant);
            if (this.Qxx != null) {
                int dim = 1;
                int dof = (int)this.varianceComponentOfUnitWeight.getRedundancy();
                TestStatisticParameterSet testStatisticParametersAprio = this.testStatisticParameters.getTestStatisticParameter(dim, Double.POSITIVE_INFINITY);
                TestStatisticParameterSet testStatisticParametersApost = this.testStatisticParameters.getTestStatisticParameter(dim, dof - dim);
                for (UnknownParameter unknownParameter : this.parameters) {
                    double uncertainty;
                    double dVal;
                    ParameterType parameterType = unknownParameter.getParameterType();
                    boolean isFixedParameter = this.transformation.isFixedParameter(unknownParameter);
                    int column = unknownParameter.getColumn();
                    double expValue = unknownParameter.getExpectedValue();
                    double value = !isFixedParameter && column >= 0 ? unknownParameter.getValue() : expValue;
                    double cofactor = !isFixedParameter && column >= 0 ? Math.max(0.0, this.Qxx.get(column, column)) : 0.0;
                    double d = dVal = !isFixedParameter ? value - expValue : 0.0;
                    if (!isFixedParameter && (parameterType == ParameterType.EULER_ANGLE_X || parameterType == ParameterType.EULER_ANGLE_Y || parameterType == ParameterType.EULER_ANGLE_Z) && Math.abs(Math.PI * 2 - dVal) < Math.abs(dVal)) {
                        dVal = Math.PI * 2 - dVal;
                    }
                    if (!isFixedParameter && (parameterType == ParameterType.SHEAR_X || parameterType == ParameterType.SHEAR_Y || parameterType == ParameterType.SHEAR_Z) && Math.abs(Math.PI - dVal) < Math.abs(dVal)) {
                        dVal = Math.PI - dVal;
                    }
                    double d2 = uncertainty = !isFixedParameter && column >= 0 ? Math.sqrt(Math.abs(varianceOfUnitWeight * cofactor)) : 0.0;
                    double T = !isFixedParameter && uncertainty > SQRT_EPS & Math.abs(dVal) > SQRT_EPS ? dVal * dVal / cofactor : 0.0;
                    unknownParameter.setValue(value);
                    unknownParameter.setUncertainty(uncertainty);
                    unknownParameter.getTestStatistic().setFisherTestNumerator(T);
                    unknownParameter.getTestStatistic().setDegreeOfFreedom(dim);
                    unknownParameter.setFisherQuantileApriori(testStatisticParametersAprio.getQuantile());
                    unknownParameter.setFisherQuantileAposteriori(testStatisticParametersApost.getQuantile());
                }
                if (!this.adjustModelParametersOnly) {
                    this.transformFramePositionPairs();
                }
            }
        }
    }

    private void transformFramePositionPairs() {
        this.transformation.transformFramePositionPairs(this.Qxx, this.interrupt);
    }

    private double getEstimateVarianceOfUnitWeightApriori() {
        int dim = this.transformationEquations.getTransformationType().getDimension();
        double vari = 0.0;
        int cnt = 0;
        for (HomologousFramePositionPair homologousPointPair : this.homologousPointPairs) {
            if (this.interrupt.isInterrupted()) {
                return 1.0;
            }
            for (HomologousFramePosition point : homologousPointPair) {
                Matrix D = point.getDispersionApriori();
                int rowD = 0;
                while (rowD < dim) {
                    double var = D.get(rowD, rowD);
                    vari += var;
                    ++cnt;
                    ++rowD;
                }
            }
        }
        return vari / (double)cnt;
    }

    private void reverseCenterOfMass() {
        this.transformationEquations.reverseCenterOfMasses(this.Qxx);
        Position centerOfMaasSrc = (Position)this.transformationEquations.getCenterOfMasses().getSourceSystemPosition();
        Position centerOfMaasTrg = (Position)this.transformationEquations.getCenterOfMasses().getTargetSystemPosition();
        centerOfMaasSrc.setX(0.0);
        centerOfMaasSrc.setY(0.0);
        centerOfMaasSrc.setZ(0.0);
        centerOfMaasTrg.setX(0.0);
        centerOfMaasTrg.setY(0.0);
        centerOfMaasTrg.setZ(0.0);
    }

    private void postProcessing() {
        ObservableUniqueList<Restriction> calculations = this.transformation.getPostProcessingCalculations();
        int numberOfUnknownParameters = this.numberOfUnknownParameters;
        Iterator iterator = calculations.iterator();
        while (iterator.hasNext()) {
            Restriction restriction = (Restriction)iterator.next();
            UnknownParameter parameter = restriction.getRegressand();
            if (parameter.getProcessingType() != ProcessingType.POSTPROCESSING) continue;
            if (this.Qxx != null) {
                int rows = this.Qxx.numRows();
                int columns = this.Qxx.numColumns();
                int column = -1;
                column = parameter.getColumn() < 0 ? columns++ : parameter.getColumn();
                restriction.setRow(column);
                DenseMatrix JrT = new DenseMatrix(rows, columns);
                int i = 0;
                while (i < rows) {
                    if (i != column) {
                        JrT.set(i, i, 1.0);
                    }
                    ++i;
                }
                restriction.transposedJacobianElements((Matrix)JrT);
                DenseMatrix DpJrT = new DenseMatrix(rows, columns);
                this.Qxx.mult((Matrix)JrT, (Matrix)DpJrT);
                this.Qxx = new UpperSymmPackMatrix(columns);
                JrT.transAmult((Matrix)DpJrT, (Matrix)this.Qxx);
                parameter.setColumn(column);
            } else if (parameter.getColumn() < 0) {
                parameter.setColumn(numberOfUnknownParameters++);
            }
            double estimate = restriction.getMisclosure();
            parameter.setValue(estimate);
        }
    }

    private double updateUnknownParameters(Vector dx) {
        double maxAbsDx = 0.0;
        for (UnknownParameter unknownParameter : this.parameters) {
            if (this.interrupt.isInterrupted()) {
                return 0.0;
            }
            int column = unknownParameter.getColumn();
            if (column < 0) continue;
            double value = unknownParameter.getValue();
            double dvalue = dx.get(column);
            maxAbsDx = Math.max(Math.abs(dvalue), maxAbsDx);
            unknownParameter.setValue(value + dvalue);
        }
        return maxAbsDx;
    }

    private double getOmega(Vector dx) throws MatrixSingularException, IllegalArgumentException, NotConvergedException {
        double omega = 0.0;
        for (HomologousFramePositionPair homologousPointPair : this.homologousPointPairs) {
            if (this.interrupt.isInterrupted()) {
                return 0.0;
            }
            int dim = this.transformationEquations.getTransformationType().getDimension();
            DenseMatrix Jx = new DenseMatrix(dim, this.numberOfUnknownParameters);
            DenseMatrix JvSrc = new DenseMatrix(dim, dim);
            DenseMatrix JvTrg = new DenseMatrix(dim, dim);
            DenseVector misclosures = new DenseVector(dim);
            this.transformationEquations.normalEquationElements(homologousPointPair, (Matrix)Jx, (Matrix)JvSrc, (Matrix)JvTrg, (Vector)misclosures);
            boolean isSourcePoint = true;
            for (HomologousFramePosition point : homologousPointPair) {
                DenseMatrix Jv = isSourcePoint ? JvSrc : JvTrg;
                isSourcePoint = false;
                DenseVector residuals = new DenseVector(dim);
                if (dim != 1) {
                    residuals.set(0, point.getResidualX());
                    residuals.set(1, point.getResidualY());
                }
                if (dim != 2) {
                    residuals.set(dim - 1, point.getResidualZ());
                }
                Jv.multAdd(-1.0, (Vector)residuals, (Vector)misclosures);
            }
            Jx.multAdd(dx, (Vector)misclosures);
            UpperSymmPackMatrix Ww = this.getWeightedMatrixOfMisclosures(homologousPointPair, (Matrix)JvSrc, (Matrix)JvTrg);
            DenseVector Wv = new DenseVector(dim);
            Ww.mult((Vector)misclosures, (Vector)Wv);
            omega += misclosures.dot((Vector)Wv);
        }
        return omega;
    }

    private double updateResiduals(Vector dx, boolean estimateStochasticParameters) throws MatrixSingularException, IllegalArgumentException, NotConvergedException {
        double omega = 0.0;
        double omegaSrc = 0.0;
        double omegaTrg = 0.0;
        double redundancySrc = 0.0;
        double redundancyTrg = 0.0;
        int nou = this.numberOfUnknownParameters;
        for (HomologousFramePositionPair homologousPointPair : this.homologousPointPairs) {
            if (this.interrupt.isInterrupted()) {
                return 0.0;
            }
            int dim = this.transformationEquations.getTransformationType().getDimension();
            DenseMatrix Jx = new DenseMatrix(dim, nou);
            DenseMatrix JvSrc = new DenseMatrix(dim, dim);
            DenseMatrix JvTrg = new DenseMatrix(dim, dim);
            DenseVector misclosures = new DenseVector(dim);
            this.transformationEquations.normalEquationElements(homologousPointPair, (Matrix)Jx, (Matrix)JvSrc, (Matrix)JvTrg, (Vector)misclosures);
            boolean isSourcePoint = true;
            for (HomologousFramePosition point : homologousPointPair) {
                DenseMatrix Jv = isSourcePoint ? JvSrc : JvTrg;
                isSourcePoint = false;
                DenseVector residuals = new DenseVector(dim);
                if (dim != 1) {
                    residuals.set(0, point.getResidualX());
                    residuals.set(1, point.getResidualY());
                }
                if (dim != 2) {
                    residuals.set(dim - 1, point.getResidualZ());
                }
                Jv.multAdd(-1.0, (Vector)residuals, (Vector)misclosures);
            }
            UpperSymmPackMatrix Ww = null;
            UpperSymmPackMatrix Dw = null;
            Jx.multAdd(dx, (Vector)misclosures);
            if (!estimateStochasticParameters) {
                Jx = null;
                Ww = this.getWeightedMatrixOfMisclosures(homologousPointPair, (Matrix)JvSrc, (Matrix)JvTrg);
            } else {
                Dw = this.getDispersionOfMisclosures(homologousPointPair, (Matrix)JvSrc, (Matrix)JvTrg);
                Ww = this.inv(Dw, false);
            }
            DenseVector Wv = new DenseVector(dim);
            Ww.mult((Vector)misclosures, (Vector)Wv);
            if (!estimateStochasticParameters) {
                Ww = null;
            } else {
                isSourcePoint = true;
                int i = 0;
                while (i < 2) {
                    UpperSymmPackMatrix Dvce = this.getDispersionOfMisclosures(homologousPointPair, (Matrix)(isSourcePoint ? JvSrc : null), (Matrix)(isSourcePoint ? null : JvTrg));
                    DenseVector DvceWv = new DenseVector(dim);
                    Dvce.mult((Vector)Wv, (Vector)DvceWv);
                    if (isSourcePoint) {
                        omegaSrc += DvceWv.dot((Vector)Wv);
                    } else {
                        omegaTrg += DvceWv.dot((Vector)Wv);
                    }
                    isSourcePoint = false;
                    ++i;
                }
            }
            omega += misclosures.dot((Vector)Wv);
            isSourcePoint = true;
            for (HomologousFramePosition point : homologousPointPair) {
                DenseMatrix Jv = isSourcePoint ? JvSrc : JvTrg;
                isSourcePoint = false;
                DenseVector residuals = new DenseVector(dim);
                DenseVector JvTWv = new DenseVector(dim);
                Jv.transMult((Vector)Wv, (Vector)JvTWv);
                Matrix D = point.getDispersionApriori();
                D.mult(-1.0 / this.varianceComponentOfUnitWeight.getVariance0(), (Vector)JvTWv, (Vector)residuals);
                if (dim != 1) {
                    point.setResidualX(residuals.get(0));
                    point.setResidualY(residuals.get(1));
                }
                if (dim == 2) continue;
                point.setResidualZ(residuals.get(dim - 1));
            }
            if (!estimateStochasticParameters) {
                Wv = null;
                JvSrc = null;
                JvTrg = null;
            }
            if (!estimateStochasticParameters) continue;
            int dof = (int)this.varianceComponentOfUnitWeight.getRedundancy();
            TestStatisticParameterSet testStatisticParametersAprio = this.testStatisticParameters.getTestStatisticParameter(dim, Double.POSITIVE_INFINITY);
            TestStatisticParameterSet testStatisticParametersApost = this.testStatisticParameters.getTestStatisticParameter(dim, dof - dim);
            double noncentralityParameter = Math.sqrt(Math.abs(testStatisticParametersAprio.getNoncentralityParameter()));
            homologousPointPair.setFisherQuantileApriori(testStatisticParametersAprio.getQuantile());
            homologousPointPair.setFisherQuantileAposteriori(testStatisticParametersApost.getQuantile());
            double[] reduncancies = this.addStochasticParameters(homologousPointPair, (Matrix)Jx, (Matrix)JvSrc, (Matrix)JvTrg, Dw, Ww, (Vector)Wv, noncentralityParameter);
            redundancySrc += reduncancies[0];
            redundancyTrg += reduncancies[1];
        }
        if (estimateStochasticParameters) {
            this.varianceComponentSourceSystem.setOmega(omegaSrc);
            this.varianceComponentTargetSystem.setOmega(omegaTrg);
            this.varianceComponentSourceSystem.setRedundancy(redundancySrc);
            this.varianceComponentTargetSystem.setRedundancy(redundancyTrg);
        }
        return omega;
    }

    private double[] addStochasticParameters(HomologousFramePositionPair homologousPointPair, Matrix Jx, Matrix JvSrc, Matrix JvTrg, UpperSymmPackMatrix Dw, UpperSymmPackMatrix Ww, Vector weightedResidualsOfMisclosures, double nonCentralityParameter) throws NotConvergedException, MatrixSingularException, IllegalArgumentException {
        int nou = this.numberOfUnknownParameters;
        int dim = this.transformationEquations.getTransformationType().getDimension();
        int dof = (int)this.varianceComponentOfUnitWeight.getRedundancy();
        DenseMatrix QxxJxT = new DenseMatrix(nou, dim);
        this.Qxx.transBmult(Jx, (Matrix)QxxJxT);
        UpperSymmPackMatrix JxQxxJxT = new UpperSymmPackMatrix(dim);
        Jx.mult((Matrix)QxxJxT, (Matrix)JxQxxJxT);
        QxxJxT = null;
        DenseMatrix JxQxxJxTW = new DenseMatrix(dim, dim);
        JxQxxJxT.mult((Matrix)Ww, (Matrix)JxQxxJxTW);
        UpperSymmPackMatrix WJxQxxJxTW = new UpperSymmPackMatrix(dim);
        Ww.mult((Matrix)JxQxxJxTW, (Matrix)WJxQxxJxTW);
        JxQxxJxTW = null;
        int row = 0;
        while (row < dim) {
            int column = row;
            while (column < dim) {
                WJxQxxJxTW.set(row, column, Ww.get(row, column) - WJxQxxJxTW.get(row, column));
                ++column;
            }
            ++row;
        }
        boolean isSourcePoint = true;
        double redundancySrc = 0.0;
        double redundancyTrg = 0.0;
        for (HomologousFramePosition point : homologousPointPair) {
            int row2;
            Matrix Jv = isSourcePoint ? JvSrc : JvTrg;
            Matrix Qll = point.getDispersionApriori();
            DenseMatrix JvQll = new DenseMatrix(dim, dim);
            Jv.mult(1.0 / this.varianceComponentOfUnitWeight.getVariance0(), Qll, (Matrix)JvQll);
            DenseMatrix WJxQxxJxTWJvQll = new DenseMatrix(dim, dim);
            WJxQxxJxTW.mult((Matrix)JvQll, (Matrix)WJxQxxJxTWJvQll);
            UpperSymmPackMatrix QllJvTWJxQxxJxTWJvQll = new UpperSymmPackMatrix(dim);
            JvQll.transAmult((Matrix)WJxQxxJxTWJvQll, (Matrix)QllJvTWJxQxxJxTWJvQll);
            WJxQxxJxTWJvQll = null;
            Matrix P = point.getInvertedDispersion(false);
            DenseMatrix R = new DenseMatrix(dim, dim);
            if (dof > 0) {
                P.mult(this.varianceComponentOfUnitWeight.getVariance0(), (Matrix)QllJvTWJxQxxJxTWJvQll, (Matrix)R);
                row2 = 0;
                while (row2 < dim) {
                    double r = R.get(row2, row2);
                    if (r > 0.0) {
                        if (row2 == 0 && dim != 1) {
                            point.setRedundancyX(r);
                        } else if (row2 == 1 && dim != 1) {
                            point.setRedundancyY(r);
                        } else if (dim != 2) {
                            point.setRedundancyZ(r);
                        }
                        if (isSourcePoint) {
                            redundancySrc += r;
                        } else {
                            redundancyTrg += r;
                        }
                    }
                    ++row2;
                }
            }
            row2 = 0;
            while (row2 < dim) {
                if (row2 == 0 && dim != 1) {
                    point.setCofactorX(Qll.get(row2, row2) / this.varianceComponentOfUnitWeight.getVariance0() - QllJvTWJxQxxJxTWJvQll.get(row2, row2));
                } else if (row2 == 1 && dim != 1) {
                    point.setCofactorY(Qll.get(row2, row2) / this.varianceComponentOfUnitWeight.getVariance0() - QllJvTWJxQxxJxTWJvQll.get(row2, row2));
                } else if (dim != 2) {
                    point.setCofactorZ(Qll.get(row2, row2) / this.varianceComponentOfUnitWeight.getVariance0() - QllJvTWJxQxxJxTWJvQll.get(row2, row2));
                }
                ++row2;
            }
            QllJvTWJxQxxJxTWJvQll = null;
            isSourcePoint = false;
        }
        WJxQxxJxTW = null;
        if (dof > 0 && redundancySrc + redundancyTrg > Math.sqrt(Constant.EPS)) {
            Dw.add(-1.0, (Matrix)JxQxxJxT);
            JxQxxJxT = null;
            DenseMatrix QvvWw = new DenseMatrix(dim, dim);
            Dw.mult((Matrix)Ww, (Matrix)QvvWw);
            UpperSymmPackMatrix WwQvvWw = new UpperSymmPackMatrix(dim);
            QvvWw.mult((Matrix)Ww, (Matrix)WwQvvWw);
            QvvWw = null;
            DenseVector grossErrorsOfMisclosures = new DenseVector(dim);
            Matrix invWwQvvWw = MathExtension.pinv((Matrix)WwQvvWw, -1.0);
            invWwQvvWw.mult(-1.0, weightedResidualsOfMisclosures, (Vector)grossErrorsOfMisclosures);
            if (dim != 1) {
                homologousPointPair.setGrossErrorX(grossErrorsOfMisclosures.get(0));
                homologousPointPair.setGrossErrorY(grossErrorsOfMisclosures.get(1));
            }
            if (dim != 2) {
                homologousPointPair.setGrossErrorZ(grossErrorsOfMisclosures.get(dim - 1));
            }
            DenseVector minimalDetectableBias = new DenseVector((Vector)grossErrorsOfMisclosures, true);
            DenseVector weightedMinimalDetectableBias = new DenseVector(dim);
            WwQvvWw.mult(1.0 / this.varianceComponentOfUnitWeight.getVariance0(), (Vector)minimalDetectableBias, (Vector)weightedMinimalDetectableBias);
            double nQn0 = minimalDetectableBias.dot((Vector)weightedMinimalDetectableBias);
            int j = 0;
            while (j < dim) {
                if (nQn0 > 0.0) {
                    minimalDetectableBias.set(j, minimalDetectableBias.get(j) / Math.sqrt(nQn0));
                }
                ++j;
            }
            if (dim != 1) {
                homologousPointPair.setMinimalDetectableBiasX(nonCentralityParameter * minimalDetectableBias.get(0));
                homologousPointPair.setMinimalDetectableBiasY(nonCentralityParameter * minimalDetectableBias.get(1));
                homologousPointPair.setMaximumTolerableBiasX(minimalDetectableBias.get(0));
                homologousPointPair.setMaximumTolerableBiasY(minimalDetectableBias.get(1));
            }
            if (dim != 2) {
                homologousPointPair.setMinimalDetectableBiasZ(nonCentralityParameter * minimalDetectableBias.get(dim - 1));
                homologousPointPair.setMaximumTolerableBiasZ(minimalDetectableBias.get(dim - 1));
            }
            double T = -weightedResidualsOfMisclosures.dot((Vector)grossErrorsOfMisclosures);
            homologousPointPair.getTestStatistic().setFisherTestNumerator(T);
            homologousPointPair.getTestStatistic().setDegreeOfFreedom(dim);
        }
        return new double[]{redundancySrc, redundancyTrg};
    }

    private NormalEquationSystem createNormalEquation() {
        int nou = this.numberOfUnknownParameters;
        int nor = this.restrictions.size();
        UpperSymmPackMatrix N = new UpperSymmPackMatrix(nou + nor);
        UpperSymmBandMatrix V = this.preconditioning ? new UpperSymmBandMatrix(nou + nor, 0) : null;
        DenseVector n = new DenseVector(nou + nor);
        int dim = this.transformationEquations.getTransformationType().getDimension();
        for (HomologousFramePositionPair homologousPointPair : this.homologousPointPairs) {
            if (this.interrupt.isInterrupted()) {
                return null;
            }
            DenseMatrix Jx = new DenseMatrix(dim, nou);
            DenseMatrix JvSrc = new DenseMatrix(dim, dim);
            DenseMatrix JvTrg = new DenseMatrix(dim, dim);
            DenseVector misclosures = new DenseVector(dim);
            this.transformationEquations.normalEquationElements(homologousPointPair, (Matrix)Jx, (Matrix)JvSrc, (Matrix)JvTrg, (Vector)misclosures);
            boolean isSourcePoint = true;
            for (HomologousFramePosition point : homologousPointPair) {
                if (this.interrupt.isInterrupted()) {
                    return null;
                }
                DenseMatrix Jv = isSourcePoint ? JvSrc : JvTrg;
                isSourcePoint = false;
                DenseVector residuals = new DenseVector(dim);
                if (dim != 1) {
                    residuals.set(0, point.getResidualX());
                    residuals.set(1, point.getResidualY());
                }
                if (dim != 2) {
                    residuals.set(dim - 1, point.getResidualZ());
                }
                Jv.multAdd(-1.0, (Vector)residuals, (Vector)misclosures);
            }
            UpperSymmPackMatrix W = this.getWeightedMatrixOfMisclosures(homologousPointPair, (Matrix)JvSrc, (Matrix)JvTrg);
            JvSrc = null;
            JvTrg = null;
            DenseMatrix WJx = new DenseMatrix(dim, nou);
            W.mult((Matrix)Jx, (Matrix)WJx);
            W = null;
            int rowJxT = 0;
            while (rowJxT < this.parameters.size()) {
                if (this.interrupt.isInterrupted()) {
                    return null;
                }
                int rowN = this.parameters.get(rowJxT).getColumn();
                if (rowN >= 0) {
                    int colWJx = rowJxT;
                    while (colWJx < this.parameters.size()) {
                        int colN = this.parameters.get(colWJx).getColumn();
                        if (colN >= 0) {
                            double mat = 0.0;
                            double vec = 0.0;
                            int colJxT = 0;
                            while (colJxT < dim) {
                                mat += Jx.get(colJxT, colN) * WJx.get(colJxT, rowN);
                                if (colWJx == rowJxT) {
                                    vec += -WJx.get(colJxT, rowN) * misclosures.get(colJxT);
                                }
                                ++colJxT;
                            }
                            N.add(rowN, colN, mat);
                            if (colWJx == rowJxT) {
                                n.add(rowN, vec);
                            }
                        }
                        ++colWJx;
                    }
                }
                ++rowJxT;
            }
        }
        for (Restriction restriction : this.restrictions) {
            if (this.interrupt.isInterrupted()) {
                return null;
            }
            restriction.transposedJacobianElements((Matrix)N);
            double misclosure = restriction.getMisclosure();
            this.maxAbsRestriction = Math.max(Math.abs(misclosure), this.maxAbsRestriction);
            n.set(restriction.getRow(), -misclosure);
        }
        if (this.deriveFirstAdaptedDampingValue) {
            double maxElement = 0.0;
            for (UnknownParameter unknownParameter : this.parameters) {
                int column = unknownParameter.getColumn();
                if (column < 0) continue;
                maxElement = Math.max(maxElement, N.get(column, column));
            }
            this.adaptedDampingValue = this.dampingValue * maxElement;
            this.deriveFirstAdaptedDampingValue = false;
        }
        if (this.adaptedDampingValue > 0.0) {
            for (UnknownParameter unknownParameter : this.parameters) {
                int column = unknownParameter.getColumn();
                if (column < 0) continue;
                N.add(column, column, this.adaptedDampingValue);
            }
        }
        if (this.preconditioning) {
            int column = 0;
            while (column < N.numColumns()) {
                if (this.interrupt.isInterrupted()) {
                    return null;
                }
                double value = N.get(column, column);
                V.set(column, column, value > Constant.EPS ? 1.0 / Math.sqrt(value) : 1.0);
                ++column;
            }
        }
        if (this.estimationType == EstimationType.SIMULATION) {
            n.zero();
        }
        return new NormalEquationSystem(N, n, V);
    }

    private void applyPrecondition(NormalEquationSystem neq) {
        this.applyPrecondition(neq.getPreconditioner(), neq.getMatrix(), (Vector)neq.getVector());
    }

    private void applyPrecondition(UpperSymmBandMatrix V, UpperSymmPackMatrix M, Vector m) {
        if (V == null) {
            return;
        }
        int row = 0;
        while (row < V.numRows()) {
            if (m != null) {
                m.set(row, V.get(row, row) * m.get(row));
            }
            if (M != null) {
                int column = row;
                while (column < V.numColumns()) {
                    M.set(row, column, V.get(column, column) * M.get(row, column) * V.get(row, row));
                    ++column;
                }
            }
            ++row;
        }
    }

    private UpperSymmPackMatrix getDispersionOfMisclosures(HomologousFramePositionPair homologousPositionPair, Matrix JvSrc, Matrix JvTrg) {
        int dim = this.transformationEquations.getTransformationType().getDimension();
        UpperSymmPackMatrix Dw = new UpperSymmPackMatrix(dim);
        boolean isSourcePoint = true;
        for (HomologousFramePosition point : homologousPositionPair) {
            if (this.interrupt.isInterrupted()) {
                return null;
            }
            Matrix Jv = isSourcePoint ? JvSrc : JvTrg;
            isSourcePoint = false;
            if (Jv == null) continue;
            Matrix D = point.getDispersionApriori();
            DenseMatrix JvD = new DenseMatrix(dim, dim);
            Jv.mult(1.0 / this.varianceComponentOfUnitWeight.getVariance0(), D, (Matrix)JvD);
            JvD.transBmultAdd(Jv, (Matrix)Dw);
        }
        return Dw;
    }

    private UpperSymmPackMatrix inv(UpperSymmPackMatrix D, boolean inplace) throws MatrixSingularException, IllegalArgumentException {
        UpperSymmPackMatrix W;
        UpperSymmPackMatrix upperSymmPackMatrix = W = inplace ? D : new UpperSymmPackMatrix((Matrix)D, true);
        if (D.numColumns() == 1) {
            double variance = W.get(0, 0);
            if (variance <= 0.0) {
                throw new MatrixSingularException("Error, dispersion matrix is singular!");
            }
            W.set(0, 0, 1.0 / variance);
        } else {
            MathExtension.inv(W);
        }
        return W;
    }

    private UpperSymmPackMatrix getWeightedMatrixOfMisclosures(HomologousFramePositionPair homologousPointPair, Matrix JvSrc, Matrix JvTrg) throws MatrixSingularException, IllegalArgumentException {
        UpperSymmPackMatrix D = this.getDispersionOfMisclosures(homologousPointPair, JvSrc, JvTrg);
        return this.inv(D, true);
    }

    public UpperSymmPackMatrix getDispersionMatrix() {
        return this.Qxx;
    }

    public UpperSymmPackMatrix getCorrelationMatrix() {
        if (this.Qxx == null) {
            return null;
        }
        int size = this.Qxx.numColumns();
        UpperSymmPackMatrix corr = new UpperSymmPackMatrix(size);
        int r = 0;
        while (r < size) {
            UnknownParameter parameterR = this.parameters.get(r);
            int row = parameterR.getColumn();
            if (row >= 0) {
                corr.set(row, row, 1.0);
                double varR = Math.abs(this.Qxx.get(row, row));
                if (!(varR < SQRT_EPS)) {
                    int c = r + 1;
                    while (c < size) {
                        double varC;
                        UnknownParameter parameterC = this.parameters.get(c);
                        int column = parameterC.getColumn();
                        if (column >= 0 && !((varC = this.Qxx.get(column, column)) < SQRT_EPS)) {
                            corr.set(row, column, this.Qxx.get(row, column) / Math.sqrt(varR) / Math.sqrt(varC));
                        }
                        ++c;
                    }
                }
            }
            ++r;
        }
        return corr;
    }

    public TestStatisticParameters getTestStatisticParameters() {
        return this.testStatisticParameters;
    }

    public TestStatisticDefinition getTestStatisticDefinition() {
        return this.testStatisticDefinition;
    }

    TestStatisticParameters getTestStatisticParameters(TestStatisticDefinition testStatisticDefinition) {
        double alpha = testStatisticDefinition.getProbabilityValue();
        double beta = testStatisticDefinition.getPowerOfTest();
        int dof = (int)this.varianceComponentOfUnitWeight.getRedundancy();
        int dim = this.transformationEquations.getTransformationType().getDimension();
        int numberOfHypotesis = this.homologousPointPairs.size() + (dof > 0 ? 1 : 0);
        return new TestStatisticParameters(switch (testStatisticDefinition.getTestStatisticType()) {
            case TestStatisticType.SIDAK -> new SidakTestStatistic(numberOfHypotesis, alpha, beta, testStatisticDefinition.isFamilywiseErrorRate());
            case TestStatisticType.BAARDA_METHOD -> new BaardaMethodTestStatistic(testStatisticDefinition.isFamilywiseErrorRate() ? dof : dim, alpha, beta);
            case TestStatisticType.NONE -> new UnadjustedTestStatitic(alpha, beta);
            default -> throw new IllegalArgumentException(this.getClass().getSimpleName() + " Error, unknown test statistic method " + String.valueOf((Object)testStatisticDefinition.getTestStatisticType()));
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.change.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.change.removePropertyChangeListener(listener);
    }

    public void addTransformationChangeListener(TransformationChangeListener l) {
        this.listenerList.add(l);
    }

    public void removeTransformationChangeListener(TransformationChangeListener l) {
        this.listenerList.remove(l);
    }

    private void fireTransformationChanged(Transformation transformation, TransformationEvent.TransformationEventType eventType) {
        TransformationEvent evt = new TransformationEvent(transformation, eventType);
        Object[] listeners = this.listenerList.toArray();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof TransformationChangeListener) {
                ((TransformationChangeListener)listeners[i]).transformationChanged(evt);
            }
            ++i;
        }
    }

    public VarianceComponent getVarianceComponent(VarianceComponentType varianceComponentType) {
        switch (varianceComponentType) {
            case SOURCE: {
                return this.varianceComponentSourceSystem;
            }
            case TARGET: {
                return this.varianceComponentTargetSystem;
            }
        }
        return this.varianceComponentOfUnitWeight;
    }

    public void setLevenbergMarquardtDampingValue(double lambda) {
        this.dampingValue = Math.abs(lambda);
    }

    public double getLevenbergMarquardtDampingValue() {
        return this.dampingValue;
    }

    public int getMaximalNumberOfIterations() {
        return this.maximalNumberOfIterations;
    }

    public void setMaximalNumberOfIterations(int maximalNumberOfIterations) {
        this.maximalNumberOfIterations = maximalNumberOfIterations;
    }

    public boolean isAdjustModelParametersOnly() {
        return this.adjustModelParametersOnly;
    }

    public void setAdjustModelParametersOnly(boolean adjustModelParametersOnly) {
        this.adjustModelParametersOnly = adjustModelParametersOnly;
    }

    public boolean isPreconditioning() {
        return this.preconditioning;
    }

    public void setPreconditioning(boolean preconditioning) {
        this.preconditioning = preconditioning;
    }

    public void interrupt() {
        this.interrupt.interrupt();
    }

    public EstimationType getEstimationType() {
        return this.estimationType;
    }

    public void setEstimationType(EstimationType estimationType) throws IllegalArgumentException {
        if (estimationType != EstimationType.L2NORM) {
            throw new IllegalArgumentException("Error, unsupported estimation type " + String.valueOf((Object)estimationType) + "!");
        }
        this.estimationType = estimationType;
    }

    public class Interrupt {
        private boolean interrupt = false;

        public boolean isInterrupted() {
            return this.interrupt;
        }

        public void interrupt() {
            this.interrupt = true;
        }

        private void setInterrupted(boolean interrupt) {
            this.interrupt = interrupt;
        }
    }
}

