/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.transformation.ParameterRestrictionType;
import org.applied_geodesy.adjustment.transformation.TransformationAdjustment;
import org.applied_geodesy.adjustment.transformation.equation.TransformationEquations;
import org.applied_geodesy.adjustment.transformation.interpolation.Interpolation;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.ProcessingType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.EstimatedFramePosition;
import org.applied_geodesy.adjustment.transformation.point.FramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;
import org.applied_geodesy.adjustment.transformation.point.SimplePositionPair;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;
import org.applied_geodesy.util.ObservableUniqueList;

public abstract class Transformation {
    private Map<ParameterRestrictionType, Restriction> supportedParameterRestrictions = new HashMap<ParameterRestrictionType, Restriction>();
    private TransformationEquations transformationEquations;
    private ObservableUniqueList<UnknownParameter> unknownParameters = null;
    private ObservableUniqueList<Restriction> restrictions = null;
    private ObservableUniqueList<Restriction> postprocessingCalculations = new ObservableUniqueList();
    private ObjectProperty<Boolean> estimateInitialGuess = new SimpleObjectProperty((Object)this, "estimateInitialGuess", (Object)Boolean.TRUE);
    private ObjectProperty<Boolean> estimateCenterOfMasses = new SimpleObjectProperty((Object)this, "estimateCenterOfMasses", (Object)Boolean.TRUE);
    private ObjectProperty<Interpolation> interpolation = new SimpleObjectProperty((Object)this, "interpolation");
    private ObservableUniqueList<FramePositionPair> framePositionPairs = new ObservableUniqueList();
    private Set<ParameterType> fixedUnknownParameterTypes = new HashSet<ParameterType>();

    Transformation() {
    }

    public void prepareIteration() {
    }

    public final Map<ParameterRestrictionType, Restriction> getSupportedParameterRestrictions() {
        return this.supportedParameterRestrictions;
    }

    public final ObservableUniqueList<Restriction> getPostProcessingCalculations() {
        return this.postprocessingCalculations;
    }

    public ObjectProperty<Boolean> estimateCenterOfMassesProperty() {
        return this.estimateCenterOfMasses;
    }

    public void setEstimateCenterOfMasses(boolean estimateCenterOfMasses) {
        this.estimateCenterOfMasses.set((Object)estimateCenterOfMasses);
    }

    public Interpolation getInterpolation() {
        return (Interpolation)this.interpolation.get();
    }

    public ObjectProperty<Interpolation> interpolationProperty() {
        return this.interpolation;
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation.set((Object)interpolation);
    }

    public boolean isEstimateCenterOfMasses() {
        return (Boolean)this.estimateCenterOfMasses.get();
    }

    public ObjectProperty<Boolean> estimateInitialGuessProperty() {
        return this.estimateInitialGuess;
    }

    public void setEstimateInitialGuess(boolean estimateInitialGuess) {
        this.estimateInitialGuess.set((Object)estimateInitialGuess);
    }

    public boolean isEstimateInitialGuess() {
        return (Boolean)this.estimateInitialGuess.get();
    }

    public final ObservableUniqueList<UnknownParameter> getUnknownParameters() {
        if (this.unknownParameters == null) {
            this.unknownParameters = new ObservableUniqueList();
            this.unknownParameters.addAll(this.transformationEquations.getUnknownParameters());
        }
        return this.unknownParameters;
    }

    public final ObservableUniqueList<Restriction> getRestrictions() {
        if (this.restrictions == null) {
            this.restrictions = new ObservableUniqueList();
            this.restrictions.addAll(this.transformationEquations.getRestrictions());
        }
        return this.restrictions;
    }

    void set(TransformationEquations equationSet) throws IllegalArgumentException {
        this.transformationEquations = equationSet;
    }

    public TransformationEquations getTransformationEquations() {
        return this.transformationEquations;
    }

    public ObservableUniqueList<FramePositionPair> getFramePositionPairs() {
        return this.framePositionPairs;
    }

    public void transformFramePositionPairs(UpperSymmPackMatrix Dp, TransformationAdjustment.Interrupt interrupt) {
        TransformationEquations transformationEquations = this.getTransformationEquations();
        if (transformationEquations != null) {
            EstimatedFramePosition estimatedTargetPosition;
            Iterator<PositionPair> iterator;
            int dim = transformationEquations.getTransformationType().getDimension();
            HashMap<String, EstimatedFramePosition> estimatedTargetPositions = new HashMap<String, EstimatedFramePosition>();
            ObservableUniqueList<HomologousFramePositionPair> homologousFramePositionPairs = transformationEquations.getHomologousFramePositionPairs();
            if (this.interpolation.get() != null) {
                iterator = homologousFramePositionPairs.iterator();
                while (iterator.hasNext()) {
                    HomologousFramePositionPair homologousFramePositionPair = (HomologousFramePositionPair)iterator.next();
                    if (interrupt.isInterrupted()) {
                        return;
                    }
                    if (!homologousFramePositionPair.isEnable()) continue;
                    estimatedTargetPosition = EstimatedFramePosition.create(dim);
                    estimatedTargetPosition.setX0(((HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition()).getX0());
                    estimatedTargetPosition.setY0(((HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition()).getY0());
                    estimatedTargetPosition.setZ0(((HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition()).getZ0());
                    estimatedTargetPositions.put(homologousFramePositionPair.getName(), estimatedTargetPosition);
                }
            }
            iterator = this.framePositionPairs.iterator();
            while (iterator.hasNext()) {
                FramePositionPair framePositionPair = (FramePositionPair)iterator.next();
                if (!framePositionPair.isEnable()) continue;
                if (interrupt.isInterrupted()) {
                    return;
                }
                transformationEquations.transform(framePositionPair, Dp);
                if (this.interpolation.get() == null || !estimatedTargetPositions.containsKey(framePositionPair.getName())) continue;
                estimatedTargetPosition = (EstimatedFramePosition)estimatedTargetPositions.get(framePositionPair.getName());
                estimatedTargetPosition.setResidualX(((EstimatedFramePosition)framePositionPair.getTargetSystemPosition()).getX() - estimatedTargetPosition.getX());
                estimatedTargetPosition.setResidualY(((EstimatedFramePosition)framePositionPair.getTargetSystemPosition()).getY() - estimatedTargetPosition.getY());
                estimatedTargetPosition.setResidualZ(((EstimatedFramePosition)framePositionPair.getTargetSystemPosition()).getZ() - estimatedTargetPosition.getZ());
            }
            if (this.interpolation.get() != null) {
                ((Interpolation)this.interpolation.get()).interpolate(estimatedTargetPositions.values(), (Collection<FramePositionPair>)((Object)this.framePositionPairs), interrupt);
            }
        }
    }

    public List<HomologousFramePositionPair> getHomologousFramePositionPairs() {
        ObservableList nonUniquePoints = FXCollections.observableArrayList();
        nonUniquePoints.addAll(this.transformationEquations.getHomologousFramePositionPairs());
        FilteredList enabledNonUniquePoints = new FilteredList(nonUniquePoints);
        enabledNonUniquePoints.setPredicate((Predicate)new Predicate<HomologousFramePositionPair>(){

            @Override
            public boolean test(HomologousFramePositionPair HomologousFramePositionPair2) {
                return HomologousFramePositionPair2.isEnable();
            }
        });
        return new ArrayList<HomologousFramePositionPair>(new LinkedHashSet(enabledNonUniquePoints));
    }

    public abstract void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException;

    public void applyInitialGuess() {
        Iterator<UnknownParameter> iterator = this.unknownParameters.iterator();
        while (iterator.hasNext()) {
            UnknownParameter unknownParameter = iterator.next();
            unknownParameter.setValue(unknownParameter.getValue0());
        }
    }

    public static SimplePositionPair deriveCenterOfMasses(Collection<? extends PositionPair<?, ?>> positionPairs, Collection<Restriction> restrictions, Map<ParameterRestrictionType, Restriction> supportedRestrictions) {
        int nop = 0;
        double x0 = 0.0;
        double y0 = 0.0;
        double z0 = 0.0;
        double X0 = 0.0;
        double Y0 = 0.0;
        double Z0 = 0.0;
        for (PositionPair<?, ?> positionPair : positionPairs) {
            if (!positionPair.isEnable()) continue;
            Object source = positionPair.getSourceSystemPosition();
            Object target = positionPair.getTargetSystemPosition();
            ++nop;
            x0 += source.getX();
            y0 += source.getY();
            z0 += source.getZ();
            X0 += target.getX();
            Y0 += target.getY();
            Z0 += target.getZ();
        }
        if (nop == 0) {
            throw new IllegalArgumentException("Error, could not estimate center of mass because of an empty point list!");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        z0 /= (double)nop;
        X0 /= (double)nop;
        Y0 /= (double)nop;
        Z0 /= (double)nop;
        if (restrictions != null && supportedRestrictions != null && (restrictions.contains(supportedRestrictions.get((Object)ParameterRestrictionType.FIXED_SHIFT_X)) || restrictions.contains(supportedRestrictions.get((Object)ParameterRestrictionType.FIXED_SHIFT_Y)) || restrictions.contains(supportedRestrictions.get((Object)ParameterRestrictionType.FIXED_SHIFT_Z)))) {
            x0 = 0.0;
            X0 = 0.0;
            y0 = 0.0;
            Y0 = 0.0;
            z0 = 0.0;
            Z0 = 0.0;
        }
        return new SimplePositionPair("CENTER_OF_MASSES", x0, y0, z0, X0, Y0, Z0);
    }

    public boolean addRestriction(ParameterRestrictionType parameterRestrictionType) {
        Map<ParameterRestrictionType, Restriction> supportedRestrictions = this.getSupportedParameterRestrictions();
        if (!supportedRestrictions.containsKey((Object)parameterRestrictionType)) {
            return false;
        }
        Restriction restriction = supportedRestrictions.get((Object)parameterRestrictionType);
        if (this.getRestrictions().contains(restriction)) {
            return false;
        }
        if (this.getRestrictionToParameterMap().containsKey((Object)parameterRestrictionType)) {
            this.fixedUnknownParameterTypes.add(this.getRestrictionToParameterMap().get((Object)parameterRestrictionType));
        }
        return this.getRestrictions().add(restriction);
    }

    public boolean removeRestriction(ParameterRestrictionType parameterRestrictionType) {
        Map<ParameterRestrictionType, Restriction> supportedRestrictions = this.getSupportedParameterRestrictions();
        if (!supportedRestrictions.containsKey((Object)parameterRestrictionType)) {
            return false;
        }
        if (this.getRestrictionToParameterMap().containsKey((Object)parameterRestrictionType)) {
            this.fixedUnknownParameterTypes.remove((Object)this.getRestrictionToParameterMap().get((Object)parameterRestrictionType));
        }
        Restriction restriction = supportedRestrictions.get((Object)parameterRestrictionType);
        return this.getRestrictions().remove(restriction);
    }

    public boolean isFixedParameter(UnknownParameter parameter) {
        return parameter.getProcessingType() == ProcessingType.FIXED || this.fixedUnknownParameterTypes.contains((Object)parameter.getParameterType());
    }

    abstract Map<ParameterRestrictionType, ParameterType> getRestrictionToParameterMap();
}

