/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.QR;
import no.uib.cipr.matrix.SymmPackEVD;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import no.uib.cipr.matrix.Vector;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.transformation.ParameterRestrictionType;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.equation.SpatialAffineEquations;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.ProcessingType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.restriction.AverageRestriction;
import org.applied_geodesy.adjustment.transformation.restriction.EulerAxisType;
import org.applied_geodesy.adjustment.transformation.restriction.ProductSumRestriction;
import org.applied_geodesy.adjustment.transformation.restriction.QuaternionEulerAngleRestriction;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;
import org.applied_geodesy.adjustment.transformation.restriction.ShearAngleRestriction;
import org.applied_geodesy.util.ObservableUniqueList;

public class SpatialAffineTransformation
extends Transformation {
    private final Map<ParameterRestrictionType, ParameterType> restrictionToParameterMap = Map.ofEntries(Map.entry(ParameterRestrictionType.FIXED_SHIFT_X, ParameterType.SHIFT_X), Map.entry(ParameterRestrictionType.FIXED_SHIFT_Y, ParameterType.SHIFT_Y), Map.entry(ParameterRestrictionType.FIXED_SHIFT_Z, ParameterType.SHIFT_Z), Map.entry(ParameterRestrictionType.FIXED_SCALE_X, ParameterType.SCALE_X), Map.entry(ParameterRestrictionType.FIXED_SCALE_Y, ParameterType.SCALE_Y), Map.entry(ParameterRestrictionType.FIXED_SCALE_Z, ParameterType.SCALE_Z), Map.entry(ParameterRestrictionType.FIXED_SHEAR_X, ParameterType.SHEAR_X), Map.entry(ParameterRestrictionType.FIXED_SHEAR_Y, ParameterType.SHEAR_Y), Map.entry(ParameterRestrictionType.FIXED_SHEAR_Z, ParameterType.SHEAR_Z), Map.entry(ParameterRestrictionType.FIXED_ROTATION_X, ParameterType.EULER_ANGLE_X), Map.entry(ParameterRestrictionType.FIXED_ROTATION_Y, ParameterType.EULER_ANGLE_Y), Map.entry(ParameterRestrictionType.FIXED_ROTATION_Z, ParameterType.EULER_ANGLE_Z));
    private final SpatialAffineEquations spatialAffineEquations = new SpatialAffineEquations();

    public SpatialAffineTransformation() {
        UnknownParameter shiftX = this.spatialAffineEquations.getUnknownParameter(ParameterType.SHIFT_X);
        UnknownParameter shiftY = this.spatialAffineEquations.getUnknownParameter(ParameterType.SHIFT_Y);
        UnknownParameter shiftZ = this.spatialAffineEquations.getUnknownParameter(ParameterType.SHIFT_Z);
        UnknownParameter q0 = this.spatialAffineEquations.getUnknownParameter(ParameterType.QUATERNION_Q0);
        UnknownParameter q1 = this.spatialAffineEquations.getUnknownParameter(ParameterType.QUATERNION_Q1);
        UnknownParameter q2 = this.spatialAffineEquations.getUnknownParameter(ParameterType.QUATERNION_Q2);
        UnknownParameter q3 = this.spatialAffineEquations.getUnknownParameter(ParameterType.QUATERNION_Q3);
        UnknownParameter s11 = this.spatialAffineEquations.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_11);
        UnknownParameter s12 = this.spatialAffineEquations.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_12);
        UnknownParameter s13 = this.spatialAffineEquations.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_13);
        UnknownParameter s22 = this.spatialAffineEquations.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_22);
        UnknownParameter s23 = this.spatialAffineEquations.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_23);
        UnknownParameter s33 = this.spatialAffineEquations.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_33);
        UnknownParameter quaternionLength = this.spatialAffineEquations.getUnknownParameter(ParameterType.VECTOR_LENGTH);
        UnknownParameter eulerAngleX = new UnknownParameter(ParameterType.EULER_ANGLE_X, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter eulerAngleY = new UnknownParameter(ParameterType.EULER_ANGLE_Y, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter eulerAngleZ = new UnknownParameter(ParameterType.EULER_ANGLE_Z, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter tmpScaleX = new UnknownParameter(ParameterType.CONSTANT, false, 0.0, 1.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter tmpScaleY = new UnknownParameter(ParameterType.CONSTANT, false, 0.0, 1.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter tmpScaleZ = new UnknownParameter(ParameterType.CONSTANT, false, 0.0, 1.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter scaleX = new UnknownParameter(ParameterType.SCALE_X, false, 1.0, 1.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter scaleY = new UnknownParameter(ParameterType.SCALE_Y, false, 1.0, 1.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter scaleZ = new UnknownParameter(ParameterType.SCALE_Z, false, 1.0, 1.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter shearX = new UnknownParameter(ParameterType.SHEAR_X, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter shearY = new UnknownParameter(ParameterType.SHEAR_Y, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter shearZ = new UnknownParameter(ParameterType.SHEAR_Z, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter zero = new UnknownParameter(ParameterType.CONSTANT, false, 0.0, false, ProcessingType.FIXED);
        UnknownParameter one = new UnknownParameter(ParameterType.CONSTANT, false, 1.0, false, ProcessingType.FIXED);
        QuaternionEulerAngleRestriction eulerAngleXRestriction = new QuaternionEulerAngleRestriction(false, EulerAxisType.X_AXIS, q0, q1, q2, q3, eulerAngleX);
        QuaternionEulerAngleRestriction eulerAngleYRestriction = new QuaternionEulerAngleRestriction(false, EulerAxisType.Y_AXIS, q0, q1, q2, q3, eulerAngleY);
        QuaternionEulerAngleRestriction eulerAngleZRestriction = new QuaternionEulerAngleRestriction(false, EulerAxisType.Z_AXIS, q0, q1, q2, q3, eulerAngleZ);
        ProductSumRestriction tmpScaleXRestriction = new ProductSumRestriction(false, List.of(s11), List.of(s11), 0.5, List.of(ProductSumRestriction.SignType.PLUS), tmpScaleX);
        ProductSumRestriction tmpScaleYRestriction = new ProductSumRestriction(false, List.of(s12, s22), List.of(s12, s22), 0.5, List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), tmpScaleY);
        ProductSumRestriction tmpScaleZRestriction = new ProductSumRestriction(false, List.of(s13, s23, s33), List.of(s13, s23, s33), 0.5, List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), tmpScaleZ);
        ProductSumRestriction scaleXRestriction = new ProductSumRestriction(false, List.of(tmpScaleX, one), List.of(one, one), 1.0, List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), scaleX);
        ProductSumRestriction scaleYRestriction = new ProductSumRestriction(false, List.of(tmpScaleY, one), List.of(one, one), 1.0, List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), scaleY);
        ProductSumRestriction scaleZRestriction = new ProductSumRestriction(false, List.of(tmpScaleZ, one), List.of(one, one), 1.0, List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), scaleZ);
        ShearAngleRestriction shearXRestriction = new ShearAngleRestriction(false, EulerAxisType.X_AXIS, s12, s13, s22, s23, s33, shearX);
        ShearAngleRestriction shearYRestriction = new ShearAngleRestriction(false, EulerAxisType.Y_AXIS, s12, s13, s22, s23, s33, shearY);
        ShearAngleRestriction shearZRestriction = new ShearAngleRestriction(false, EulerAxisType.Z_AXIS, s12, s13, s22, s23, s33, shearZ);
        AverageRestriction fixedShiftXRestriction = new AverageRestriction(false, List.of(shiftX), zero);
        AverageRestriction fixedShiftYRestriction = new AverageRestriction(false, List.of(shiftY), zero);
        AverageRestriction fixedShiftZRestriction = new AverageRestriction(false, List.of(shiftZ), zero);
        ProductSumRestriction fixedScaleXRestriction = new ProductSumRestriction(false, List.of(s11), List.of(s11), List.of(ProductSumRestriction.SignType.PLUS), one);
        ProductSumRestriction fixedScaleYRestriction = new ProductSumRestriction(false, List.of(s12, s22), List.of(s12, s22), 0.5, List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), one);
        ProductSumRestriction fixedScaleZRestriction = new ProductSumRestriction(false, List.of(s13, s23, s33), List.of(s13, s23, s33), 0.5, List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), one);
        AverageRestriction fixedShearXRestriction = new AverageRestriction(false, List.of(s23), zero);
        AverageRestriction fixedShearYRestriction = new AverageRestriction(false, List.of(s13), zero);
        AverageRestriction fixedShearZRestriction = new AverageRestriction(false, List.of(s12), zero);
        ProductSumRestriction fixedRotationXRestriction = new ProductSumRestriction(false, List.of(q2, q0), List.of(q3, q1), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.MINUS), zero);
        ProductSumRestriction fixedRotationYRestriction = new ProductSumRestriction(false, List.of(q1, q0), List.of(q3, q2), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), zero);
        ProductSumRestriction fixedRotationZRestriction = new ProductSumRestriction(false, List.of(q1, q0), List.of(q2, q3), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.MINUS), zero);
        ProductSumRestriction identicalScalesXYRestriction = new ProductSumRestriction(false, List.of(s12, s22, s11), List.of(s12, s22, s11), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.MINUS), zero);
        ProductSumRestriction identicalScalesXZRestriction = new ProductSumRestriction(false, List.of(s13, s23, s33, s11), List.of(s13, s23, s33, s11), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.MINUS), zero);
        ProductSumRestriction identicalScalesYZRestriction = new ProductSumRestriction(false, List.of(s13, s23, s33, s12, s22), List.of(s13, s23, s33, s12, s22), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.MINUS, ProductSumRestriction.SignType.MINUS), zero);
        ArrayList<UnknownParameter> unknownParameters = new ArrayList<UnknownParameter>();
        unknownParameters.add(shiftX);
        unknownParameters.add(shiftY);
        unknownParameters.add(shiftZ);
        unknownParameters.add(tmpScaleX);
        unknownParameters.add(tmpScaleY);
        unknownParameters.add(tmpScaleZ);
        unknownParameters.add(scaleX);
        unknownParameters.add(scaleY);
        unknownParameters.add(scaleZ);
        unknownParameters.add(eulerAngleX);
        unknownParameters.add(eulerAngleY);
        unknownParameters.add(eulerAngleZ);
        unknownParameters.add(shearX);
        unknownParameters.add(shearY);
        unknownParameters.add(shearZ);
        unknownParameters.add(q0);
        unknownParameters.add(q1);
        unknownParameters.add(q2);
        unknownParameters.add(q3);
        unknownParameters.add(s11);
        unknownParameters.add(s12);
        unknownParameters.add(s13);
        unknownParameters.add(s22);
        unknownParameters.add(s23);
        unknownParameters.add(s33);
        unknownParameters.add(quaternionLength);
        unknownParameters.add(zero);
        unknownParameters.add(one);
        this.set(this.spatialAffineEquations);
        this.getUnknownParameters().setAll(unknownParameters);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SHIFT_X, fixedShiftXRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SHIFT_Y, fixedShiftYRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SHIFT_Z, fixedShiftZRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SCALE_X, fixedScaleXRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SCALE_Y, fixedScaleYRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SCALE_Z, fixedScaleZRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_ROTATION_X, fixedRotationXRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_ROTATION_Y, fixedRotationYRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_ROTATION_Z, fixedRotationZRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SHEAR_X, fixedShearXRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SHEAR_Y, fixedShearYRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SHEAR_Z, fixedShearZRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.IDENTICAL_SCALE_XY, identicalScalesXYRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.IDENTICAL_SCALE_XZ, identicalScalesXZRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.IDENTICAL_SCALE_YZ, identicalScalesYZRestriction);
        this.getPostProcessingCalculations().addAll(new Restriction[]{eulerAngleXRestriction, eulerAngleYRestriction, eulerAngleZRestriction, tmpScaleXRestriction, tmpScaleYRestriction, tmpScaleZRestriction, scaleXRestriction, scaleYRestriction, scaleZRestriction, shearXRestriction, shearYRestriction, shearZRestriction});
    }

    public static void deriveInitialGuess(Collection<HomologousFramePositionPair> points, SpatialAffineTransformation transformation, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        SpatialAffineTransformation.deriveInitialGuess(points, transformation.spatialAffineEquations, parameterRestrictions);
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        ObservableUniqueList<Restriction> restrictions = this.getRestrictions();
        HashSet<ParameterRestrictionType> parameterRestrictions = new HashSet<ParameterRestrictionType>(restrictions.size());
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SHIFT_X))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SHIFT_X);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SHIFT_Y))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SHIFT_Y);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SHIFT_Z))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SHIFT_Z);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SCALE_X))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SCALE_X);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SCALE_Y))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SCALE_Y);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SCALE_Z))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SCALE_Z);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SHEAR_X))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SHEAR_X);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SHEAR_Y))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SHEAR_Y);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SHEAR_Z))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SHEAR_Z);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_ROTATION_X))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_ROTATION_X);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_ROTATION_Y))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_ROTATION_Y);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_ROTATION_Z))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_ROTATION_Z);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.IDENTICAL_SCALE_XY))) {
            parameterRestrictions.add(ParameterRestrictionType.IDENTICAL_SCALE_XY);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.IDENTICAL_SCALE_XZ))) {
            parameterRestrictions.add(ParameterRestrictionType.IDENTICAL_SCALE_XZ);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.IDENTICAL_SCALE_YZ))) {
            parameterRestrictions.add(ParameterRestrictionType.IDENTICAL_SCALE_YZ);
        }
        SpatialAffineTransformation.deriveInitialGuess(this.spatialAffineEquations.getHomologousFramePositionPairs(), this.spatialAffineEquations, parameterRestrictions);
    }

    public static void deriveInitialGuess(Collection<HomologousFramePositionPair> points, SpatialAffineEquations spatialAffineEquations, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        if (parameterRestrictions == null) {
            parameterRestrictions = Collections.emptySet();
        }
        if (parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_X) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Y) && !parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Z) || parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_X) && !parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Y) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Z) || !parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_X) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Y) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Z)) {
            SpatialAffineTransformation.deriveInitialGuessViaPlanarAffin(points, spatialAffineEquations, parameterRestrictions);
        } else if (!(parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHEAR_X) || parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHEAR_Y) || parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHEAR_Z))) {
            SpatialAffineTransformation.deriveInitialGuessViaQRdecomposition(points, spatialAffineEquations, parameterRestrictions);
        } else {
            SpatialAffineTransformation.deriveInitialGuessViaEigendecomposition(points, spatialAffineEquations, parameterRestrictions);
        }
    }

    private static void deriveInitialGuessViaPlanarAffin(Collection<HomologousFramePositionPair> points, SpatialAffineEquations spatialAffineEquations, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        double tx = 0.0;
        double ty = 0.0;
        double tz = 0.0;
        double q0 = 1.0;
        double q1 = 0.0;
        double q2 = 0.0;
        double q3 = 0.0;
        double s11 = 1.0;
        double s12 = 0.0;
        double s13 = 0.0;
        double s22 = 1.0;
        double s23 = 0.0;
        double s33 = 1.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double z0 = 0.0;
        double X0 = 0.0;
        double Y0 = 0.0;
        double Z0 = 0.0;
        int nop = 0;
        for (HomologousFramePositionPair homologousFramePositionPair : points) {
            if (!homologousFramePositionPair.isEnable()) continue;
            HomologousFramePosition pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
            HomologousFramePosition pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
            x0 += pointSrc.getX0();
            y0 += pointSrc.getY0();
            z0 += pointSrc.getZ0();
            X0 += pointTrg.getX0();
            Y0 += pointTrg.getY0();
            Z0 += pointTrg.getZ0();
            ++nop;
        }
        if (nop <= 0) {
            throw new IllegalArgumentException("Error, the number of points zero.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        z0 /= (double)nop;
        X0 /= (double)nop;
        Y0 /= (double)nop;
        Z0 /= (double)nop;
        double o = 0.0;
        double a = 0.0;
        double oa = 0.0;
        for (HomologousFramePositionPair homologousFramePositionPair : points) {
            if (!homologousFramePositionPair.isEnable()) continue;
            HomologousFramePosition pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
            HomologousFramePosition pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
            double x = pointSrc.getX0() - x0;
            double y = pointSrc.getY0() - y0;
            double z = pointSrc.getZ0() - z0;
            double X = pointTrg.getX0() - X0;
            double Y = pointTrg.getY0() - Y0;
            double Z = pointTrg.getZ0() - Z0;
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Z)) {
                o += x * Y - y * X;
                a += x * X + y * Y;
            } else if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Y)) {
                o += x * Z - z * X;
                a += x * X + z * Z;
            } else if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_X)) {
                o += y * Z - z * Y;
                a += y * Y + z * Z;
            }
            oa += x * x + y * y;
        }
        if (oa <= Constant.EPS) {
            throw new MatrixSingularException("Error, system of equations is singular.");
        }
        double m = Math.hypot(a /= oa, o /= oa);
        if (parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_X) || parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Y) || parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Z)) {
            if (m <= Constant.EPS) {
                throw new MatrixSingularException("Error, system of equations is singular.");
            }
            o /= m;
            a /= m;
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_X)) {
            s11 = m;
            s12 = 0.0;
            s13 = 0.0;
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Y)) {
            s22 = m;
            s23 = 0.0;
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Z)) {
            s33 = m;
        }
        double alpha = 0.5 * Math.atan2(o, a);
        q0 = Math.cos(alpha);
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Z)) {
            q3 = Math.sin(alpha);
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_X)) {
                tx = X0 - (a * x0 - o * y0);
            }
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Y)) {
                ty = Y0 - (o * x0 + a * y0);
            }
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Z)) {
                tz = Z0 - z0;
            }
        } else if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Y)) {
            q2 = Math.sin(alpha);
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_X)) {
                tx = X0 - (a * x0 - o * z0);
            }
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Y)) {
                ty = Y0 - y0;
            }
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Z)) {
                tz = Z0 - (o * x0 + a * z0);
            }
        } else if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_X)) {
            q1 = Math.sin(alpha);
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_X)) {
                tx = X0 - x0;
            }
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Y)) {
                ty = Y0 - (a * y0 - o * z0);
            }
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Z)) {
                tz = Z0 - (o * y0 + a * z0);
            }
        }
        spatialAffineEquations.setInitialGuess(tx, ty, tz, q0, q1, q2, q3, s11, s12, s13, s22, s23, s33);
    }

    private static void deriveInitialGuessViaQRdecomposition(Collection<HomologousFramePositionPair> points, SpatialAffineEquations spatialAffineEquations, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        HomologousFramePosition pointTrg;
        HomologousFramePosition pointSrc;
        double tx = 0.0;
        double ty = 0.0;
        double tz = 0.0;
        double q0 = 1.0;
        double q1 = 0.0;
        double q2 = 0.0;
        double q3 = 0.0;
        double s11 = 1.0;
        double s12 = 0.0;
        double s13 = 0.0;
        double s22 = 1.0;
        double s23 = 0.0;
        double s33 = 1.0;
        UpperSymmPackMatrix N = new UpperSymmPackMatrix(9);
        DenseVector n = new DenseVector(N.numRows());
        double x0 = 0.0;
        double y0 = 0.0;
        double z0 = 0.0;
        double X0 = 0.0;
        double Y0 = 0.0;
        double Z0 = 0.0;
        int nop = 0;
        for (HomologousFramePositionPair homologousFramePositionPair : points) {
            if (!homologousFramePositionPair.isEnable()) continue;
            pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
            pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
            x0 += pointSrc.getX0();
            y0 += pointSrc.getY0();
            z0 += pointSrc.getZ0();
            X0 += pointTrg.getX0();
            Y0 += pointTrg.getY0();
            Z0 += pointTrg.getZ0();
            ++nop;
        }
        if (nop <= 0) {
            throw new IllegalArgumentException("Error, the number of points is zero.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        z0 /= (double)nop;
        X0 /= (double)nop;
        Y0 /= (double)nop;
        Z0 /= (double)nop;
        if (!(nop <= 2 || parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_X) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Y) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Z))) {
            for (HomologousFramePositionPair homologousFramePositionPair : points) {
                if (!homologousFramePositionPair.isEnable()) continue;
                pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
                pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
                double x = pointSrc.getX0() - x0;
                double y = pointSrc.getY0() - y0;
                double z = pointSrc.getZ0() - z0;
                double X = pointTrg.getX0() - X0;
                double Y = pointTrg.getY0() - Y0;
                double Z = pointTrg.getZ0() - Z0;
                int row = 0;
                while (row <= 6) {
                    N.add(row, row, x * x);
                    N.add(row, row + 1, x * y);
                    N.add(row, row + 2, x * z);
                    N.add(row + 1, row + 1, y * y);
                    N.add(row + 1, row + 2, y * z);
                    N.add(row + 2, row + 2, z * z);
                    double w = 0.0;
                    w = row == 0 ? X : (row == 3 ? Y : Z);
                    n.add(row, x * w);
                    n.add(row + 1, y * w);
                    n.add(row + 2, z * w);
                    row += 3;
                }
            }
            DenseVector t = new DenseVector(n.size());
            try {
                N.solve((Vector)n, (Vector)t);
            }
            catch (Exception e) {
                N = MathExtension.pinv((Matrix)N, -1);
                N.mult((Vector)n, (Vector)t);
            }
            DenseMatrix T = new DenseMatrix(3, 3);
            int i = 0;
            while (i < 9) {
                T.set(i / 3, i % 3, t.get(i));
                ++i;
            }
            QR qr = QR.factorize((Matrix)T);
            DenseMatrix Q = qr.getQ();
            UpperTriangDenseMatrix R = qr.getR();
            q0 = 0.5 * Math.sqrt(1.0 + Q.get(0, 0) + Q.get(1, 1) + Q.get(2, 2));
            q1 = 0.25 * (Q.get(2, 1) - Q.get(1, 2)) / q0;
            q2 = 0.25 * (Q.get(0, 2) - Q.get(2, 0)) / q0;
            q3 = 0.25 * (Q.get(1, 0) - Q.get(0, 1)) / q0;
            s11 = R.get(0, 0);
            s12 = R.get(0, 1);
            s13 = R.get(0, 2);
            s22 = R.get(1, 1);
            s23 = R.get(1, 2);
            s33 = R.get(2, 2);
        }
        double smxP = s11 * x0 + s12 * y0 + s13 * z0;
        double smyP = s22 * y0 + s23 * z0;
        double smzP = s33 * z0;
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_X)) {
            double r11 = 2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1;
            double r12 = 2.0 * (q1 * q2 - q0 * q3);
            double r13 = 2.0 * (q1 * q3 + q0 * q2);
            tx = X0 - (r11 * smxP + r12 * smyP + r13 * smzP);
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Y)) {
            double r21 = 2.0 * (q1 * q2 + q0 * q3);
            double r22 = 2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2;
            double r23 = 2.0 * (q2 * q3 - q0 * q1);
            ty = Y0 - (r21 * smxP + r22 * smyP + r23 * smzP);
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Z)) {
            double r31 = 2.0 * (q1 * q3 - q0 * q2);
            double r32 = 2.0 * (q2 * q3 + q0 * q1);
            double r33 = 2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3;
            tz = Z0 - (r31 * smxP + r32 * smyP + r33 * smzP);
        }
        spatialAffineEquations.setInitialGuess(tx, ty, tz, q0, q1, q2, q3, s11, s12, s13, s22, s23, s33);
    }

    private static void deriveInitialGuessViaEigendecomposition(Collection<HomologousFramePositionPair> points, SpatialAffineEquations spatialAffineEquations, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        double tx = 0.0;
        double ty = 0.0;
        double tz = 0.0;
        double q0 = 1.0;
        double q1 = 0.0;
        double q2 = 0.0;
        double q3 = 0.0;
        double s11 = 1.0;
        double s12 = 0.0;
        double s13 = 0.0;
        double s22 = 1.0;
        double s23 = 0.0;
        double s33 = 1.0;
        double m = 1.0;
        int dim = 3;
        double x0 = 0.0;
        double y0 = 0.0;
        double z0 = 0.0;
        double X0 = 0.0;
        double Y0 = 0.0;
        double Z0 = 0.0;
        int nop = 0;
        for (HomologousFramePositionPair homologousFramePositionPair : points) {
            if (!homologousFramePositionPair.isEnable()) continue;
            HomologousFramePosition pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
            HomologousFramePosition pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
            x0 += pointSrc.getX0();
            y0 += pointSrc.getY0();
            z0 += pointSrc.getZ0();
            X0 += pointTrg.getX0();
            Y0 += pointTrg.getY0();
            Z0 += pointTrg.getZ0();
            ++nop;
        }
        if (nop <= 0) {
            throw new IllegalArgumentException("Error, the number of points is zero.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        z0 /= (double)nop;
        X0 /= (double)nop;
        Y0 /= (double)nop;
        Z0 /= (double)nop;
        if (!(nop <= 2 || parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_X) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Y) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Z))) {
            DenseMatrix S = new DenseMatrix(3, 3);
            for (HomologousFramePositionPair HomologousFramePositionPair2 : points) {
                if (!HomologousFramePositionPair2.isEnable()) continue;
                HomologousFramePosition pointSrc = (HomologousFramePosition)HomologousFramePositionPair2.getSourceSystemPosition();
                HomologousFramePosition pointTrg = (HomologousFramePosition)HomologousFramePositionPair2.getTargetSystemPosition();
                double xk = pointSrc.getX0();
                double yk = pointSrc.getY0();
                double zk = pointSrc.getZ0();
                double Xk = pointTrg.getX0();
                double Yk = pointTrg.getY0();
                double Zk = pointTrg.getZ0();
                int i = 0;
                while (i < dim) {
                    double ds = 0.0;
                    ds = i == 0 ? xk - x0 : (i == 1 ? yk - y0 : zk - z0);
                    int j = 0;
                    while (j < dim) {
                        double dt = 0.0;
                        dt = j == 0 ? Xk - X0 : (j == 1 ? Yk - Y0 : Zk - Z0);
                        S.add(i, j, ds * dt);
                        ++j;
                    }
                    ++i;
                }
            }
            UpperSymmPackMatrix N = new UpperSymmPackMatrix(4);
            N.set(0, 0, S.get(0, 0) + S.get(1, 1) + S.get(2, 2));
            N.set(0, 1, S.get(1, 2) - S.get(2, 1));
            N.set(0, 2, S.get(2, 0) - S.get(0, 2));
            N.set(0, 3, S.get(0, 1) - S.get(1, 0));
            N.set(1, 1, S.get(0, 0) - S.get(1, 1) - S.get(2, 2));
            N.set(1, 2, S.get(0, 1) + S.get(1, 0));
            N.set(1, 3, S.get(2, 0) + S.get(0, 2));
            N.set(2, 2, -S.get(0, 0) + S.get(1, 1) - S.get(2, 2));
            N.set(2, 3, S.get(1, 2) + S.get(2, 1));
            N.set(3, 3, -S.get(0, 0) - S.get(1, 1) + S.get(2, 2));
            SymmPackEVD evd = new SymmPackEVD(4, true, true);
            evd.factor(N);
            DenseMatrix eigVec = evd.getEigenvectors();
            double[] eigVal = evd.getEigenvalues();
            int indexMaxEigVal = 0;
            double maxEigVal = eigVal[indexMaxEigVal];
            int i = indexMaxEigVal + 1;
            while (i < eigVal.length) {
                if (maxEigVal < eigVal[i]) {
                    maxEigVal = eigVal[i];
                    indexMaxEigVal = i;
                }
                ++i;
            }
            q0 = eigVec.get(0, indexMaxEigVal);
            q1 = eigVec.get(1, indexMaxEigVal);
            q2 = eigVec.get(2, indexMaxEigVal);
            q3 = eigVec.get(3, indexMaxEigVal);
        }
        if (!(parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_X) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Y) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Z))) {
            double m1 = 0.0;
            double m2 = 0.0;
            for (HomologousFramePositionPair HomologousFramePositionPair3 : points) {
                if (!HomologousFramePositionPair3.isEnable()) continue;
                HomologousFramePosition pointSrc = (HomologousFramePosition)HomologousFramePositionPair3.getSourceSystemPosition();
                HomologousFramePosition pointTrg = (HomologousFramePosition)HomologousFramePositionPair3.getTargetSystemPosition();
                double xk = pointSrc.getX0();
                double yk = pointSrc.getY0();
                double zk = pointSrc.getZ0();
                double Xk = pointTrg.getX0();
                double Yk = pointTrg.getY0();
                double Zk = pointTrg.getZ0();
                double dx = xk - x0;
                double dy = yk - y0;
                double dz = zk - z0;
                double dX = Xk - X0;
                double dY = Yk - Y0;
                double dZ = Zk - Z0;
                m1 += dX * ((2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1) * dx + 2.0 * (q1 * q2 - q0 * q3) * dy + 2.0 * (q1 * q3 + q0 * q2) * dz);
                m1 += dY * (2.0 * (q1 * q2 + q0 * q3) * dx + (2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2) * dy + 2.0 * (q2 * q3 - q0 * q1) * dz);
                m1 += dZ * (2.0 * (q1 * q3 - q0 * q2) * dx + 2.0 * (q2 * q3 + q0 * q1) * dy + (2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3) * dz);
                m2 += dx * dx;
                m2 += dy * dy;
                m2 += dz * dz;
            }
            if (m1 > 0.0 && m2 > 0.0) {
                m = m1 / m2;
            }
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_X)) {
                s11 = m;
                s12 = 0.0;
                s13 = 0.0;
            }
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Y)) {
                s22 = m;
                s23 = 0.0;
            }
            if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Z)) {
                s33 = m;
            }
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_X)) {
            tx = X0 - m * ((2.0 * q0 * q0 - 1.0 + 2.0 * q1 * q1) * x0 + 2.0 * (q1 * q2 - q0 * q3) * y0 + 2.0 * (q1 * q3 + q0 * q2) * z0);
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Y)) {
            ty = Y0 - m * (2.0 * (q1 * q2 + q0 * q3) * x0 + (2.0 * q0 * q0 - 1.0 + 2.0 * q2 * q2) * y0 + 2.0 * (q2 * q3 - q0 * q1) * z0);
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Z)) {
            tz = Z0 - m * (2.0 * (q1 * q3 - q0 * q2) * x0 + 2.0 * (q2 * q3 + q0 * q1) * y0 + (2.0 * q0 * q0 - 1.0 + 2.0 * q3 * q3) * z0);
        }
        spatialAffineEquations.setInitialGuess(tx, ty, tz, q0, q1, q2, q3, s11, s12, s13, s22, s23, s33);
    }

    @Override
    Map<ParameterRestrictionType, ParameterType> getRestrictionToParameterMap() {
        return this.restrictionToParameterMap;
    }
}

