/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.transformation.ParameterRestrictionType;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.equation.PlanarAffineEquations;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.ProcessingType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.restriction.AverageRestriction;
import org.applied_geodesy.adjustment.transformation.restriction.InverseTangentRestriction;
import org.applied_geodesy.adjustment.transformation.restriction.ProductSumRestriction;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;
import org.applied_geodesy.util.ObservableUniqueList;

public class PlanarAffineTransformation
extends Transformation {
    private final Map<ParameterRestrictionType, ParameterType> restrictionToParameterMap = Map.ofEntries(Map.entry(ParameterRestrictionType.FIXED_SHIFT_X, ParameterType.SHIFT_X), Map.entry(ParameterRestrictionType.FIXED_SHIFT_Y, ParameterType.SHIFT_Y), Map.entry(ParameterRestrictionType.FIXED_SCALE_X, ParameterType.SCALE_X), Map.entry(ParameterRestrictionType.FIXED_SCALE_Y, ParameterType.SCALE_Y), Map.entry(ParameterRestrictionType.FIXED_SHEAR_Z, ParameterType.SHEAR_Z), Map.entry(ParameterRestrictionType.FIXED_ROTATION_Z, ParameterType.EULER_ANGLE_Z));
    private final PlanarAffineEquations planarAffineEquations = new PlanarAffineEquations();

    public PlanarAffineTransformation() {
        UnknownParameter shiftX = this.planarAffineEquations.getUnknownParameter(ParameterType.SHIFT_X);
        UnknownParameter shiftY = this.planarAffineEquations.getUnknownParameter(ParameterType.SHIFT_Y);
        UnknownParameter a11 = this.planarAffineEquations.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_11);
        UnknownParameter a12 = this.planarAffineEquations.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_12);
        UnknownParameter a21 = this.planarAffineEquations.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_21);
        UnknownParameter a22 = this.planarAffineEquations.getUnknownParameter(ParameterType.AUXILIARY_ELEMENT_22);
        UnknownParameter eulerAngleZ = new UnknownParameter(ParameterType.EULER_ANGLE_Z, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter tmpScaleX = new UnknownParameter(ParameterType.CONSTANT, false, 0.0, 1.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter tmpScaleY = new UnknownParameter(ParameterType.CONSTANT, false, 0.0, 1.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter tmpShearX = new UnknownParameter(ParameterType.CONSTANT, false, 0.0, 0.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter tmpShearY = new UnknownParameter(ParameterType.CONSTANT, false, 0.0, 0.0, false, ProcessingType.POSTPROCESSING);
        UnknownParameter scaleX = new UnknownParameter(ParameterType.SCALE_X, false, 1.0, 1.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter scaleY = new UnknownParameter(ParameterType.SCALE_Y, false, 1.0, 1.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter shearZ = new UnknownParameter(ParameterType.SHEAR_Z, false, 0.0, true, ProcessingType.POSTPROCESSING);
        UnknownParameter zero = new UnknownParameter(ParameterType.CONSTANT, false, 0.0, false, ProcessingType.FIXED);
        UnknownParameter one = new UnknownParameter(ParameterType.CONSTANT, false, 1.0, false, ProcessingType.FIXED);
        InverseTangentRestriction eulerAngleZRestriction = new InverseTangentRestriction(false, a21, a11, eulerAngleZ);
        ProductSumRestriction tmpScaleXRestriction = new ProductSumRestriction(false, List.of(a11, a21), List.of(a11, a21), 0.5, List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), tmpScaleX);
        ProductSumRestriction tmpScaleYRestriction = new ProductSumRestriction(false, List.of(a12, a22), List.of(a12, a22), 0.5, List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), tmpScaleY);
        ProductSumRestriction scaleXRestriction = new ProductSumRestriction(false, List.of(tmpScaleX, one), List.of(one, one), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), scaleX);
        ProductSumRestriction scaleYRestriction = new ProductSumRestriction(false, List.of(tmpScaleY, one), List.of(one, one), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), scaleY);
        ProductSumRestriction numeratorShearRestriction = new ProductSumRestriction(false, List.of(a11, a21), List.of(a12, a22), List.of(ProductSumRestriction.SignType.MINUS, ProductSumRestriction.SignType.PLUS), tmpShearX);
        ProductSumRestriction denominatorShearRestriction = new ProductSumRestriction(false, List.of(a21, a11), List.of(a12, a22), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), tmpShearY);
        InverseTangentRestriction shearZRestriction = new InverseTangentRestriction(false, tmpShearX, tmpShearY, shearZ);
        AverageRestriction fixedShiftXRestriction = new AverageRestriction(false, List.of(shiftX), zero);
        AverageRestriction fixedShiftYRestriction = new AverageRestriction(false, List.of(shiftY), zero);
        AverageRestriction fixedRotationZRestriction = new AverageRestriction(false, List.of(a21), zero);
        ProductSumRestriction fixedScaleXRestriction = new ProductSumRestriction(false, List.of(a11, a21), List.of(a11, a21), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), one);
        ProductSumRestriction fixedScaleYRestriction = new ProductSumRestriction(false, List.of(a12, a22), List.of(a12, a22), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS), one);
        ProductSumRestriction fixedShearZRestriction = new ProductSumRestriction(false, List.of(a11, a21), List.of(a12, a22), List.of(ProductSumRestriction.SignType.MINUS, ProductSumRestriction.SignType.PLUS), zero);
        ProductSumRestriction identicalScalesXYRestriction = new ProductSumRestriction(false, List.of(a11, a21, a12, a22), List.of(a11, a21, a12, a22), List.of(ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.PLUS, ProductSumRestriction.SignType.MINUS, ProductSumRestriction.SignType.MINUS), zero);
        ArrayList<UnknownParameter> unknownParameters = new ArrayList<UnknownParameter>();
        unknownParameters.add(shiftX);
        unknownParameters.add(shiftY);
        unknownParameters.add(tmpScaleX);
        unknownParameters.add(tmpScaleY);
        unknownParameters.add(scaleX);
        unknownParameters.add(scaleY);
        unknownParameters.add(eulerAngleZ);
        unknownParameters.add(tmpShearX);
        unknownParameters.add(tmpShearY);
        unknownParameters.add(shearZ);
        unknownParameters.add(a11);
        unknownParameters.add(a12);
        unknownParameters.add(a21);
        unknownParameters.add(a22);
        unknownParameters.add(zero);
        unknownParameters.add(one);
        this.set(this.planarAffineEquations);
        this.getUnknownParameters().setAll(unknownParameters);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SHIFT_X, fixedShiftXRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SHIFT_Y, fixedShiftYRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SCALE_X, fixedScaleXRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SCALE_Y, fixedScaleYRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_ROTATION_Z, fixedRotationZRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SHEAR_Z, fixedShearZRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.IDENTICAL_SCALE_XY, identicalScalesXYRestriction);
        this.getPostProcessingCalculations().addAll(new Restriction[]{eulerAngleZRestriction, tmpScaleXRestriction, tmpScaleYRestriction, scaleXRestriction, scaleYRestriction, numeratorShearRestriction, denominatorShearRestriction, shearZRestriction});
    }

    public static void deriveInitialGuess(Collection<HomologousFramePositionPair> points, PlanarAffineTransformation transformation, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        PlanarAffineTransformation.deriveInitialGuess(points, transformation.planarAffineEquations, parameterRestrictions);
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        ObservableUniqueList<Restriction> restrictions = this.getRestrictions();
        HashSet<ParameterRestrictionType> parameterRestrictions = new HashSet<ParameterRestrictionType>(restrictions.size());
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SHIFT_X))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SHIFT_X);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SHIFT_Y))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SHIFT_Y);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SCALE_X))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SCALE_X);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SCALE_Y))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SCALE_Y);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SHEAR_Z))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SHEAR_Z);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_ROTATION_Z))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_ROTATION_Z);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.IDENTICAL_SCALE_XY))) {
            parameterRestrictions.add(ParameterRestrictionType.IDENTICAL_SCALE_XY);
        }
        PlanarAffineTransformation.deriveInitialGuess(this.planarAffineEquations.getHomologousFramePositionPairs(), this.planarAffineEquations, parameterRestrictions);
    }

    public static void deriveInitialGuess(Collection<HomologousFramePositionPair> points, PlanarAffineEquations planarAffineEquations, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        if (parameterRestrictions == null) {
            parameterRestrictions = Collections.emptySet();
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Z) && !parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHEAR_Z)) {
            PlanarAffineTransformation.deriveInitialGuessViaAffin(points, planarAffineEquations, parameterRestrictions);
        } else {
            PlanarAffineTransformation.deriveInitialGuessViaHelmert(points, planarAffineEquations, parameterRestrictions);
        }
    }

    public static void deriveInitialGuessViaHelmert(Collection<HomologousFramePositionPair> points, PlanarAffineEquations planarAffineEquations, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        double tx = 0.0;
        double ty = 0.0;
        double a11 = 1.0;
        double a12 = 0.0;
        double a21 = 0.0;
        double a22 = 1.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double X0 = 0.0;
        double Y0 = 0.0;
        int nop = 0;
        for (HomologousFramePositionPair homologousFramePositionPair : points) {
            if (!homologousFramePositionPair.isEnable()) continue;
            HomologousFramePosition pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
            HomologousFramePosition pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
            x0 += pointSrc.getX0();
            y0 += pointSrc.getY0();
            X0 += pointTrg.getX0();
            Y0 += pointTrg.getY0();
            ++nop;
        }
        if (nop <= 0) {
            throw new IllegalArgumentException("Error, the number of points is zero.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        X0 /= (double)nop;
        Y0 /= (double)nop;
        if (parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_ROTATION_Z) && parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHEAR_Z)) {
            a11 = 1.0;
            a22 = 1.0;
        } else {
            double o = 0.0;
            double a = 0.0;
            double oa = 0.0;
            for (HomologousFramePositionPair homologousFramePositionPair : points) {
                if (!homologousFramePositionPair.isEnable()) continue;
                HomologousFramePosition pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
                HomologousFramePosition pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
                double x = pointSrc.getX0() - x0;
                double y = pointSrc.getY0() - y0;
                double X = pointTrg.getX0() - X0;
                double Y = pointTrg.getY0() - Y0;
                o += x * Y - y * X;
                a += x * X + y * Y;
                oa += x * x + y * y;
            }
            if (oa <= Constant.EPS) {
                throw new MatrixSingularException("Error, system of equations is singular.");
            }
            a11 = a /= oa;
            a12 = o /= oa;
            a21 = o;
            a22 = a;
            if (parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_X) || parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Y)) {
                oa = Math.hypot(a, o);
                if (oa <= Constant.EPS) {
                    throw new MatrixSingularException("Error, system of equations is singular.");
                }
                if (parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_X)) {
                    a11 /= oa;
                    a21 /= oa;
                }
                if (parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Y)) {
                    a12 /= oa;
                    a22 /= oa;
                }
            }
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_X)) {
            tx = X0 - (a11 * x0 - a12 * y0);
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Y)) {
            ty = Y0 - (a21 * x0 + a22 * y0);
        }
        planarAffineEquations.setInitialGuess(tx, ty, a11, a12, a21, a22);
    }

    private static void deriveInitialGuessViaAffin(Collection<HomologousFramePositionPair> points, PlanarAffineEquations planarAffineEquations, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        double tx = 0.0;
        double ty = 0.0;
        double a11 = 1.0;
        double a12 = 0.0;
        double a21 = 0.0;
        double a22 = 1.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double X0 = 0.0;
        double Y0 = 0.0;
        int nop = 0;
        for (HomologousFramePositionPair homologousFramePositionPair : points) {
            if (!homologousFramePositionPair.isEnable()) continue;
            HomologousFramePosition pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
            HomologousFramePosition pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
            x0 += pointSrc.getX0();
            y0 += pointSrc.getY0();
            X0 += pointTrg.getX0();
            Y0 += pointTrg.getY0();
            ++nop;
        }
        if (nop <= 0) {
            throw new IllegalArgumentException("Error, the number of points is zero.");
        }
        x0 /= (double)nop;
        y0 /= (double)nop;
        X0 /= (double)nop;
        Y0 /= (double)nop;
        double xx = 0.0;
        double xX = 0.0;
        double xY = 0.0;
        double yy = 0.0;
        double yY = 0.0;
        double yX = 0.0;
        double xy = 0.0;
        for (HomologousFramePositionPair homologousFramePositionPair : points) {
            if (!homologousFramePositionPair.isEnable()) continue;
            HomologousFramePosition pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
            HomologousFramePosition pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
            double x = pointSrc.getX0() - x0;
            double y = pointSrc.getY0() - y0;
            double X = pointTrg.getX0() - X0;
            double Y = pointTrg.getY0() - Y0;
            xx += x * x;
            xX += x * X;
            xY += x * Y;
            yy += y * y;
            yY += y * Y;
            yX += y * X;
            xy += x * y;
        }
        double N = xx * yy - xy * xy;
        if (N <= Constant.EPS) {
            throw new MatrixSingularException("Error, system of equations is singular.");
        }
        a11 = (xX * yy - yX * xy) / N;
        a12 = (xX * xy - yX * xx) / N;
        a21 = (xY * yy - yY * xy) / N;
        a22 = (yY * xx - xY * xy) / N;
        if (parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_X)) {
            double mx = Math.hypot(a11, a21);
            if (mx <= Constant.EPS) {
                throw new MatrixSingularException("Error, system of equations is singular.");
            }
            a11 /= mx;
            a21 /= mx;
        }
        if (parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Y)) {
            double my = Math.hypot(a12, a22);
            if (my <= Constant.EPS) {
                throw new MatrixSingularException("Error, system of equations is singular.");
            }
            a12 /= my;
            a22 /= my;
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_X)) {
            tx = X0 - (a11 * x0 - a12 * y0);
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Y)) {
            ty = Y0 - (a21 * x0 + a22 * y0);
        }
        planarAffineEquations.setInitialGuess(tx, ty, a11, a12, a21, a22);
    }

    @Override
    Map<ParameterRestrictionType, ParameterType> getRestrictionToParameterMap() {
        return this.restrictionToParameterMap;
    }
}

