/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.transformation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.transformation.ParameterRestrictionType;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.equation.HeightEquations;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.ProcessingType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.restriction.AverageRestriction;
import org.applied_geodesy.adjustment.transformation.restriction.Restriction;
import org.applied_geodesy.util.ObservableUniqueList;

public class HeightTransformation
extends Transformation {
    private final Map<ParameterRestrictionType, ParameterType> restrictionToParameterMap = Map.ofEntries(Map.entry(ParameterRestrictionType.FIXED_SHIFT_Z, ParameterType.SHIFT_Z), Map.entry(ParameterRestrictionType.FIXED_SCALE_Z, ParameterType.SCALE_Z));
    private final HeightEquations heightEquations = new HeightEquations();

    public HeightTransformation() {
        UnknownParameter shiftZ = this.heightEquations.getUnknownParameter(ParameterType.SHIFT_Z);
        UnknownParameter scaleZ = this.heightEquations.getUnknownParameter(ParameterType.SCALE_Z);
        UnknownParameter zero = new UnknownParameter(ParameterType.CONSTANT, false, 0.0, false, ProcessingType.FIXED);
        UnknownParameter one = new UnknownParameter(ParameterType.CONSTANT, false, 1.0, false, ProcessingType.FIXED);
        AverageRestriction fixedShiftZRestriction = new AverageRestriction(false, List.of(shiftZ), zero);
        AverageRestriction fixedScaleZRestriction = new AverageRestriction(false, List.of(scaleZ), one);
        ArrayList<UnknownParameter> unknownParameters = new ArrayList<UnknownParameter>();
        unknownParameters.add(shiftZ);
        unknownParameters.add(scaleZ);
        unknownParameters.add(zero);
        unknownParameters.add(one);
        this.set(this.heightEquations);
        this.getUnknownParameters().setAll(unknownParameters);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SHIFT_Z, fixedShiftZRestriction);
        this.getSupportedParameterRestrictions().put(ParameterRestrictionType.FIXED_SCALE_Z, fixedScaleZRestriction);
    }

    public static void deriveInitialGuess(Collection<HomologousFramePositionPair> points, HeightTransformation transformation, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        if (parameterRestrictions == null) {
            parameterRestrictions = Collections.emptySet();
        }
        HeightTransformation.deriveInitialGuess(points, transformation.heightEquations, parameterRestrictions);
    }

    @Override
    public void deriveInitialGuess() throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        ObservableUniqueList<Restriction> restrictions = this.getRestrictions();
        HashSet<ParameterRestrictionType> parameterRestrictions = new HashSet<ParameterRestrictionType>(restrictions.size());
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SHIFT_Z))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SHIFT_Z);
        }
        if (restrictions.contains(this.getSupportedParameterRestrictions().get((Object)ParameterRestrictionType.FIXED_SCALE_Z))) {
            parameterRestrictions.add(ParameterRestrictionType.FIXED_SCALE_Z);
        }
        HeightTransformation.deriveInitialGuess(this.heightEquations.getHomologousFramePositionPairs(), this.heightEquations, parameterRestrictions);
    }

    public static void deriveInitialGuess(Collection<HomologousFramePositionPair> points, HeightEquations heightEquations, Set<ParameterRestrictionType> parameterRestrictions) throws MatrixSingularException, IllegalArgumentException, NotConvergedException, UnsupportedOperationException {
        HomologousFramePosition pointTrg;
        HomologousFramePosition pointSrc;
        double tz = 0.0;
        double mz = 1.0;
        double z0 = 0.0;
        double Z0 = 0.0;
        int nop = 0;
        for (HomologousFramePositionPair homologousFramePositionPair : points) {
            if (!homologousFramePositionPair.isEnable()) continue;
            pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
            pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
            z0 += pointSrc.getZ0();
            Z0 += pointTrg.getZ0();
            ++nop;
        }
        if (nop <= 0) {
            throw new IllegalArgumentException("Error, the number of points is zero.");
        }
        z0 /= (double)nop;
        Z0 /= (double)nop;
        if (parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SCALE_Z)) {
            mz = 1.0;
        } else {
            mz = 0.0;
            nop = 0;
            for (HomologousFramePositionPair homologousFramePositionPair : points) {
                if (!homologousFramePositionPair.isEnable()) continue;
                pointSrc = (HomologousFramePosition)homologousFramePositionPair.getSourceSystemPosition();
                pointTrg = (HomologousFramePosition)homologousFramePositionPair.getTargetSystemPosition();
                double dz = pointSrc.getZ0() - z0;
                double dZ = pointTrg.getZ0() - Z0;
                mz += Math.abs(dz / dZ);
                ++nop;
            }
            if (mz <= Constant.EPS) {
                throw new MatrixSingularException("Error, system of equations is singular.");
            }
            mz /= (double)nop;
        }
        if (!parameterRestrictions.contains((Object)ParameterRestrictionType.FIXED_SHIFT_Z)) {
            tz = Z0 - mz * z0;
        }
        heightEquations.setInitialGuess(tz, mz);
    }

    @Override
    Map<ParameterRestrictionType, ParameterType> getRestrictionToParameterMap() {
        return this.restrictionToParameterMap;
    }
}

