/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.statistic;

import org.applied_geodesy.adjustment.statistic.TestStatistic;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;

public class UnadjustedTestStatitic
extends TestStatistic {
    private final double alpha;
    private final double beta;

    public UnadjustedTestStatitic() {
        this(0.001, 0.8);
    }

    public UnadjustedTestStatitic(double alpha, double beta) {
        super(TestStatisticType.NONE, alpha, beta);
        this.beta = beta;
        this.alpha = alpha;
    }

    @Override
    public TestStatisticParameterSet[] adjustTestStatisticParameters(TestStatisticParameterSet[] testStatisticParameterSet) {
        int l = testStatisticParameterSet.length;
        int i = 0;
        while (i < l) {
            TestStatisticParameterSet parameter = testStatisticParameterSet[i];
            double n2 = parameter.getNumeratorDof();
            double m2 = parameter.getDenominatorDof();
            parameter.setProbabilityValue(this.alpha);
            parameter.setPowerOfTest(this.beta);
            if (Double.isInfinite(m2)) {
                quantile = TestStatistic.getQuantile(n2, this.alpha);
                ncp = TestStatistic.getNoncentralityParameter(n2, this.alpha, this.beta);
                logP = TestStatistic.getLogarithmicProbabilityValue(quantile, n2);
                parameter.setQuantile(quantile);
                parameter.setNoncentralityParameter(ncp);
                parameter.setLogarithmicProbabilityValue(logP);
            } else {
                quantile = TestStatistic.getQuantile(n2, m2, this.alpha);
                ncp = TestStatistic.getNoncentralityParameter(n2, m2, this.alpha, this.beta);
                logP = TestStatistic.getLogarithmicProbabilityValue(quantile, n2, m2);
                parameter.setQuantile(quantile);
                parameter.setNoncentralityParameter(ncp);
                parameter.setLogarithmicProbabilityValue(logP);
            }
            ++i;
        }
        return testStatisticParameterSet;
    }

    public static void main(String[] args) {
        int dof = 10000000;
        UnadjustedTestStatitic bMeth = new UnadjustedTestStatitic(0.001, 0.8);
        TestStatisticParameterSet[] set = new TestStatisticParameterSet[]{new TestStatisticParameterSet(1.0, Double.POSITIVE_INFINITY), new TestStatisticParameterSet(1.0, dof - 1), new TestStatisticParameterSet(2.0, Double.POSITIVE_INFINITY), new TestStatisticParameterSet(2.0, dof - 2), new TestStatisticParameterSet(3.0, Double.POSITIVE_INFINITY), new TestStatisticParameterSet(3.0, dof - 3), new TestStatisticParameterSet(dof, Double.POSITIVE_INFINITY)};
        bMeth.adjustTestStatisticParameters(set);
        TestStatisticParameterSet[] testStatisticParameterSetArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            TestStatisticParameterSet s = testStatisticParameterSetArray[n2];
            System.out.println(s);
            ++n2;
        }
    }
}

