/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.statistic;

import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import org.applied_geodesy.adjustment.statistic.TestStatistic;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;

public class TestStatisticParameters {
    public TestStatistic testStatistic;
    private SortedMap<KeySet, TestStatisticParameterSet> params = Collections.synchronizedSortedMap(new TreeMap());

    public TestStatisticParameters(TestStatistic testStatistic) {
        this.testStatistic = testStatistic;
    }

    public TestStatistic getTestStatistic() {
        return this.testStatistic;
    }

    public TestStatisticParameterSet[] getTestStatisticParameterSets() {
        TestStatisticParameterSet[] arr = new TestStatisticParameterSet[this.params.size()];
        int i = 0;
        for (TestStatisticParameterSet set : this.params.values()) {
            arr[i++] = set;
        }
        return arr;
    }

    public TestStatisticParameterSet getTestStatisticParameter(double f1, double f2) {
        return this.getTestStatisticParameter(f1, f2, Boolean.FALSE);
    }

    public TestStatisticParameterSet getTestStatisticParameter(double f1, double f2, boolean isGlobalTestStatistic) {
        KeySet key = new KeySet(f1, f2);
        if (!this.params.containsKey(key)) {
            this.params.put(key, this.testStatistic.adjustTestStatisticParameter(new TestStatisticParameterSet(f1, f2, isGlobalTestStatistic)));
        }
        return (TestStatisticParameterSet)this.params.get(key);
    }

    private class KeySet
    implements Comparable<KeySet> {
        public final double f1;
        public final double f2;

        public KeySet(double f1, double f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            long temp = Double.doubleToLongBits(this.f1);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.f2);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeySet other = (KeySet)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (Double.doubleToLongBits(this.f1) != Double.doubleToLongBits(other.f1)) {
                return false;
            }
            return Double.doubleToLongBits(this.f2) == Double.doubleToLongBits(other.f2);
        }

        private TestStatisticParameters getOuterType() {
            return TestStatisticParameters.this;
        }

        @Override
        public int compareTo(KeySet keySet) {
            if (this.equals(keySet)) {
                return 0;
            }
            if (this.f1 < keySet.f1 || this.f1 == keySet.f1 && this.f2 > keySet.f2) {
                return -1;
            }
            if (this.f1 > keySet.f1 || this.f1 == keySet.f1 && this.f2 < keySet.f2) {
                return 1;
            }
            return 0;
        }
    }
}

