/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.statistic;

import org.applied_geodesy.adjustment.statistic.DefaultTestStatisticValue;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;

public class TestStatisticDefinition {
    private TestStatisticType testStatisticType;
    private double probabilityValue;
    private double powerOfTest;
    private boolean familywiseErrorRate = false;

    public TestStatisticDefinition() {
        this(DefaultTestStatisticValue.getTestStatisticType(), DefaultTestStatisticValue.getProbabilityValue(), DefaultTestStatisticValue.getPowerOfTest(), false);
    }

    public TestStatisticDefinition(TestStatisticType testStatisticType) {
        this(testStatisticType, DefaultTestStatisticValue.getProbabilityValue(), DefaultTestStatisticValue.getPowerOfTest(), false);
    }

    public TestStatisticDefinition(TestStatisticType testStatisticType, double probabilityValue) {
        this(testStatisticType, probabilityValue, DefaultTestStatisticValue.getPowerOfTest(), false);
    }

    public TestStatisticDefinition(TestStatisticType testStatisticType, double probabilityValue, double powerOfTest, boolean familywiseErrorRate) {
        this.testStatisticType = testStatisticType != null ? testStatisticType : DefaultTestStatisticValue.getTestStatisticType();
        this.probabilityValue = probabilityValue > 0.0 && probabilityValue < 1.0 ? probabilityValue : DefaultTestStatisticValue.getProbabilityValue();
        this.powerOfTest = powerOfTest > 0.0 && powerOfTest < 1.0 ? powerOfTest : DefaultTestStatisticValue.getPowerOfTest();
        this.familywiseErrorRate = familywiseErrorRate;
    }

    public TestStatisticType getTestStatisticType() {
        return this.testStatisticType;
    }

    public double getProbabilityValue() {
        return this.probabilityValue;
    }

    public double getPowerOfTest() {
        return this.powerOfTest;
    }

    public boolean isFamilywiseErrorRate() {
        return this.familywiseErrorRate;
    }

    public void setTestStatisticType(TestStatisticType testStatisticType) {
        this.testStatisticType = testStatisticType;
    }

    public void setProbabilityValue(double probabilityValue) {
        this.probabilityValue = probabilityValue;
    }

    public void setPowerOfTest(double powerOfTest) {
        this.powerOfTest = powerOfTest;
    }

    public void setFamilywiseErrorRate(boolean familywiseErrorRate) {
        this.familywiseErrorRate = familywiseErrorRate;
    }

    public String toString() {
        return "TestStatisticDefinition [testStatisticType=" + String.valueOf((Object)this.testStatisticType) + ", probabilityValue=" + this.probabilityValue + ", powerOfTest=" + this.powerOfTest + ", familywiseErrorRate=" + this.familywiseErrorRate + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.probabilityValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.powerOfTest);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.familywiseErrorRate ? 1231 : 1237);
        result = 31 * result + (this.testStatisticType == null ? 0 : this.testStatisticType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestStatisticDefinition other = (TestStatisticDefinition)obj;
        if (Double.doubleToLongBits(this.probabilityValue) != Double.doubleToLongBits(other.probabilityValue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.powerOfTest) != Double.doubleToLongBits(other.powerOfTest)) {
            return false;
        }
        if (this.familywiseErrorRate != other.familywiseErrorRate) {
            return false;
        }
        return this.testStatisticType == other.testStatisticType;
    }
}

