/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.statistic;

import jdistlib.Binomial;
import jdistlib.ChiSquare;
import jdistlib.F;
import jdistlib.NonCentralChiSquare;
import jdistlib.NonCentralF;
import jdistlib.Normal;
import org.applied_geodesy.adjustment.statistic.BinomialTestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;

public abstract class TestStatistic {
    private final TestStatisticType type;
    private final double alpha;
    private final double beta;

    public TestStatistic(TestStatisticType type, double alpha, double beta) {
        this.type = type;
        this.alpha = alpha;
        this.beta = beta;
    }

    public double getProbabilityValue() {
        return this.alpha;
    }

    public double getTestPower() {
        return this.beta;
    }

    public TestStatisticType getTestStatisticType() {
        return this.type;
    }

    public TestStatisticParameterSet adjustTestStatisticParameter(TestStatisticParameterSet testStatisticParameterSet) {
        TestStatisticParameterSet[] set = new TestStatisticParameterSet[]{testStatisticParameterSet};
        this.adjustTestStatisticParameters(set);
        return set[0];
    }

    public abstract TestStatisticParameterSet[] adjustTestStatisticParameters(TestStatisticParameterSet[] var1);

    public BinomialTestStatisticParameterSet adjustTestStatisticParameter(BinomialTestStatisticParameterSet binomialTestStatisticParameterSet) {
        BinomialTestStatisticParameterSet[] set = new BinomialTestStatisticParameterSet[]{binomialTestStatisticParameterSet};
        this.adjustTestStatisticParameters(set);
        return set[0];
    }

    public BinomialTestStatisticParameterSet[] adjustTestStatisticParameters(BinomialTestStatisticParameterSet[] binomialTestStatisticParameterSet) {
        int l = binomialTestStatisticParameterSet.length;
        int i = 0;
        while (i < l) {
            BinomialTestStatisticParameterSet parameter = binomialTestStatisticParameterSet[i];
            int numberOfTrials = parameter.getNumberOfTrials();
            double successProbability = parameter.getSuccessProbability();
            int lowerQuantile = (int)TestStatistic.getQuantile(numberOfTrials, successProbability, 0.5 * this.alpha);
            int upperQuantile = (int)TestStatistic.getQuantile(numberOfTrials, successProbability, 1.0 - 0.5 * this.alpha);
            double alphaL = TestStatistic.getProbabilityValue(lowerQuantile, numberOfTrials, successProbability);
            double alphaU = 1.0 - TestStatistic.getProbabilityValue(upperQuantile, numberOfTrials, successProbability);
            parameter.setProbabilityValue(alphaL + alphaU);
            parameter.setLowerTailQuantile(lowerQuantile);
            parameter.setUpperTailQuantile(upperQuantile);
            ++i;
        }
        return binomialTestStatisticParameterSet;
    }

    public static double getQuantileViaNCP(double n2, double ncp, double beta) {
        if (n2 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return NonCentralChiSquare.quantile((double)(1.0 - beta), (double)n2, (double)ncp, (boolean)true, (boolean)false) / n2;
    }

    public static double getQuantileViaNCP(double n2, double m2, double ncp, double beta) {
        if (n2 <= 0.0 || m2 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isInfinite(ncp)) {
            return TestStatistic.getQuantileViaNCP(n2, ncp, beta);
        }
        return NonCentralF.quantile((double)(1.0 - beta), (double)n2, (double)m2, (double)ncp, (boolean)true, (boolean)false);
    }

    public static double getQuantile(double n1, double alpha) {
        if (n1 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return ChiSquare.quantile((double)(1.0 - alpha), (double)n1, (boolean)true, (boolean)false) / n1;
    }

    public static double getQuantile(double n1, double m1, double alpha) {
        if (n1 <= 0.0 || m1 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isInfinite(m1)) {
            return TestStatistic.getQuantile(n1, alpha);
        }
        return F.quantile((double)(1.0 - alpha), (double)n1, (double)m1, (boolean)true, (boolean)false);
    }

    public static double getQuantile(double n1, double n2, double alpha, double beta) {
        if (n1 <= 0.0 || n2 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (n1 == n2) {
            return ChiSquare.quantile((double)(1.0 - alpha), (double)n1, (boolean)true, (boolean)false) / n1;
        }
        double ncp = TestStatistic.getNoncentralityParameter(n1, alpha, beta);
        if (Double.isInfinite(ncp)) {
            return Double.POSITIVE_INFINITY;
        }
        return NonCentralChiSquare.quantile((double)(1.0 - beta), (double)n2, (double)ncp, (boolean)true, (boolean)false) / n2;
    }

    public static double getQuantile(double n1, double n2, double m2, double alpha, double beta) {
        if (m2 <= 0.0 || n1 <= 0.0 || n2 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isInfinite(m2)) {
            return TestStatistic.getQuantile(n1, n2, alpha, beta);
        }
        double ncp = TestStatistic.getNoncentralityParameter(n1, alpha, beta);
        if (Double.isInfinite(ncp)) {
            return Double.POSITIVE_INFINITY;
        }
        return NonCentralF.quantile((double)(1.0 - beta), (double)n2, (double)m2, (double)ncp, (boolean)true, (boolean)false);
    }

    public static double getQuantile(double n1, double m1, double n2, double m2, double alpha, double beta) {
        if (m2 <= 0.0 || n1 <= 0.0 || n2 <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double ncp = TestStatistic.getNoncentralityParameter(n1, m1, alpha, beta);
        if (Double.isInfinite(ncp)) {
            return Double.POSITIVE_INFINITY;
        }
        return NonCentralF.quantile((double)(1.0 - beta), (double)n2, (double)m2, (double)ncp, (boolean)true, (boolean)false);
    }

    /*
     * Unable to fully structure code
     */
    public static double getNoncentralityParameter(double n, double alpha, double beta) {
        if (n <= 0.0) {
            return 0.0;
        }
        alpha = Math.max(alpha, 1.0E-10);
        if (n == 1.0) {
            return Math.pow(Normal.quantile((double)(1.0 - 0.5 * alpha), (double)0.0, (double)1.0, (boolean)true, (boolean)false) + Normal.quantile((double)beta, (double)0.0, (double)1.0, (boolean)true, (boolean)false), 2.0);
        }
        itr = 0;
        EPS_APPROX = 1.0E-4;
        EPS_NEWTON = EPS_APPROX * EPS_APPROX;
        q1 = ChiSquare.quantile((double)(1.0 - alpha), (double)n, (boolean)true, (boolean)false);
        lowerNCP = 0.0;
        upperNCP = 50.0;
        x = Math.pow(2.0 * (n + upperNCP) * q1 / (n + 2.0 * upperNCP), 0.5) - Math.pow(2.0 * (n + upperNCP) * (n + upperNCP) / (n + 2.0 * upperNCP) - 1.0, 0.5);
        if (!Double.isInfinite(x) && !Double.isNaN(x)) ** GOTO lbl17
        return Infinity;
lbl-1000:
        // 1 sources

        {
            if (!Double.isInfinite(x = Math.pow(2.0 * (n + (upperNCP += 50.0)) * q1 / (n + 2.0 * upperNCP), 0.5) - Math.pow(2.0 * (n + upperNCP) * (n + upperNCP) / (n + 2.0 * upperNCP) - 1.0, 0.5)) && !Double.isNaN(x)) continue;
            return Infinity;
lbl17:
            // 2 sources

            ** while (Normal.cumulative((double)x, (double)0.0, (double)1.0, (boolean)false, (boolean)false) < beta)
        }
lbl18:
        // 1 sources

        lowerNCP = upperNCP - 50.0;
        while (Math.abs(upperNCP - lowerNCP) > EPS_APPROX && itr++ < 200) {
            ncp = 0.5 * (lowerNCP + upperNCP);
            x = Math.pow(2.0 * (n + ncp) * q1 / (n + 2.0 * ncp), 0.5) - Math.pow(2.0 * (n + ncp) * (n + ncp) / (n + 2.0 * ncp) - 1.0, 0.5);
            if (Double.isInfinite(x) || Double.isNaN(x)) {
                return Infinity;
            }
            if (Normal.cumulative((double)x, (double)0.0, (double)1.0, (boolean)false, (boolean)false) < beta) {
                lowerNCP = ncp;
                continue;
            }
            upperNCP = ncp;
        }
        ncp = 0.5 * (lowerNCP + upperNCP);
        ncp0 = ncp - 1.0;
        itr = 0;
        while (Math.abs(ncp - ncp0) > EPS_NEWTON && itr++ < 200) {
            ncp0 = ncp;
            f1 = NonCentralChiSquare.cumulative((double)q1, (double)n, (double)ncp, (boolean)true, (boolean)false);
            f2 = -0.5 * f1 + 0.5 * NonCentralChiSquare.cumulative((double)q1, (double)(n + 2.0), (double)ncp, (boolean)true, (boolean)false);
            ncp -= (f1 -= 1.0 - beta) / f2;
        }
        if (Math.abs(ncp - ncp0) > EPS_NEWTON || itr++ >= 200) {
            System.err.println("Error, iteration limit reached during noncentrality parameter estimation: itr = " + itr + ", epsilon = " + Math.abs(ncp - ncp0));
        }
        return ncp;
    }

    public static double getNoncentralityParameter(double n, double m, double alpha, double beta) {
        if (n <= 0.0 || m <= 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(m)) {
            return TestStatistic.getNoncentralityParameter(n, alpha, beta);
        }
        alpha = Math.max(alpha, 1.0E-10);
        double EPS_APPROX = 1.0E-4;
        double EPS = EPS_APPROX * EPS_APPROX;
        int itr = 0;
        double q1 = F.quantile((double)(1.0 - alpha), (double)n, (double)m, (boolean)true, (boolean)false);
        double lowerNCP = 0.0;
        double upperNCP = 50.0;
        double n1 = (n + upperNCP) * (n + upperNCP) / (n + 2.0 * upperNCP);
        double f2 = n / (n + upperNCP) * q1;
        double beta2 = F.cumulative((double)f2, (double)n1, (double)m, (boolean)false, (boolean)false);
        while (beta2 < beta) {
            n1 = (n + (upperNCP += 50.0)) * (n + upperNCP) / (n + 2.0 * upperNCP);
            f2 = n / (n + upperNCP) * q1;
            beta2 = F.cumulative((double)f2, (double)n1, (double)m, (boolean)false, (boolean)false);
        }
        lowerNCP = upperNCP - 50.0;
        itr = 0;
        while (Math.abs(beta2 - beta) > EPS && itr++ < 200) {
            double ncp = 0.5 * (lowerNCP + upperNCP);
            beta2 = NonCentralF.cumulative((double)q1, (double)n, (double)m, (double)ncp, (boolean)false, (boolean)false);
            if (beta2 > beta) {
                upperNCP = ncp;
                continue;
            }
            lowerNCP = ncp;
        }
        if (Math.abs(beta2 - beta) > EPS || itr++ >= 200) {
            System.err.println("Error, iteration limit reached during noncentrality parameter estimation: itr = " + itr + ", epsilon = " + Math.abs(beta2 - beta));
        }
        return 0.5 * (lowerNCP + upperNCP);
    }

    public static double getProbabilityValue(double x, double n1) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x < 0.0 || n1 <= 0.0) {
            return 1.0;
        }
        return ChiSquare.cumulative((double)(n1 * x), (double)n1, (boolean)false, (boolean)false);
    }

    public static double getProbabilityValue(double x, double n1, double m1) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x < 0.0 || n1 <= 0.0 || m1 <= 0.0) {
            return 1.0;
        }
        if (Double.isInfinite(m1)) {
            return TestStatistic.getProbabilityValue(x, n1);
        }
        return F.cumulative((double)x, (double)n1, (double)m1, (boolean)false, (boolean)false);
    }

    public static double getPowerOfTest(double x, double n1, double ncp) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x < 0.0 || n1 <= 0.0) {
            return 1.0;
        }
        return NonCentralChiSquare.cumulative((double)(n1 * x), (double)n1, (double)ncp, (boolean)false, (boolean)false);
    }

    public static double getPowerOfTest(double x, double n1, double m1, double ncp) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x < 0.0 || n1 <= 0.0 || m1 <= 0.0) {
            return 1.0;
        }
        if (Double.isInfinite(m1)) {
            return TestStatistic.getPowerOfTest(x, n1, ncp);
        }
        return NonCentralF.cumulative((double)x, (double)n1, (double)m1, (double)ncp, (boolean)false, (boolean)false);
    }

    public static double getLogarithmicProbabilityValue(double x, double n1) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x < 0.0 || n1 <= 0.0) {
            return 0.0;
        }
        return ChiSquare.cumulative((double)(n1 * x), (double)n1, (boolean)false, (boolean)true);
    }

    public static double getLogarithmicProbabilityValue(double x, double n1, double m1) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x < 0.0 || n1 <= 0.0 || m1 <= 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(m1)) {
            return TestStatistic.getLogarithmicProbabilityValue(x, n1);
        }
        return F.cumulative((double)x, (double)n1, (double)m1, (boolean)false, (boolean)true);
    }

    public static double getLogarithmicPowerOfTest(double x, double n1, double ncp) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x < 0.0 || n1 <= 0.0) {
            return 0.0;
        }
        return NonCentralChiSquare.cumulative((double)(n1 * x), (double)n1, (double)ncp, (boolean)false, (boolean)true);
    }

    public static double getLogarithmicPowerOfTest(double x, double n1, double m1, double ncp) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x < 0.0 || n1 <= 0.0 || m1 <= 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(m1)) {
            return TestStatistic.getLogarithmicPowerOfTest(x, n1, ncp);
        }
        return NonCentralF.cumulative((double)x, (double)n1, (double)m1, (double)ncp, (boolean)false, (boolean)true);
    }

    public static double getQuantile(int numberOfTrials, double successProbability, double alpha) {
        return Binomial.quantile((double)alpha, (double)numberOfTrials, (double)successProbability, (boolean)Boolean.TRUE, (boolean)Boolean.FALSE);
    }

    public static double getProbabilityValue(int x, int numberOfTrials, double successProbability) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x < 0 || numberOfTrials <= 0 || successProbability <= 0.0) {
            return 1.0;
        }
        if (successProbability >= 1.0) {
            return 0.0;
        }
        return Binomial.cumulative((double)x, (double)numberOfTrials, (double)successProbability, (boolean)true, (boolean)false);
    }
}

