/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.statistic;

import org.applied_geodesy.adjustment.statistic.TestStatistic;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;

public class SidakTestStatistic
extends TestStatistic {
    private final double alphaGlobal;
    private final double alphaLocal;
    private final double beta;
    private final int numberOfIndependentHypothesis;
    private double ncp = -1.0;

    public SidakTestStatistic() {
        this(Integer.MAX_VALUE, 0.001, 0.8, false);
    }

    public SidakTestStatistic(int numberOfIndependentHypothesis, double alpha, double beta, boolean isAlphaGlobal) {
        super(TestStatisticType.SIDAK, alpha, beta);
        this.beta = beta;
        this.numberOfIndependentHypothesis = numberOfIndependentHypothesis;
        if (isAlphaGlobal && this.numberOfIndependentHypothesis > 0) {
            this.alphaGlobal = alpha;
            double d = 1.0 - alpha;
            this.alphaLocal = 1.0 - Math.pow(d, 1.0 / (double)this.numberOfIndependentHypothesis);
            this.ncp = TestStatistic.getNoncentralityParameter(this.numberOfIndependentHypothesis, alpha, this.beta);
        } else if (!isAlphaGlobal && this.numberOfIndependentHypothesis > 0) {
            this.alphaLocal = alpha;
            double d = 1.0 - alpha;
            this.alphaGlobal = 1.0 - Math.pow(d, this.numberOfIndependentHypothesis);
            this.ncp = TestStatistic.getNoncentralityParameter(1.0, alpha, this.beta);
        } else {
            this.alphaGlobal = this.alphaLocal = alpha;
            this.ncp = TestStatistic.getNoncentralityParameter(1.0, alpha, this.beta);
        }
    }

    @Override
    public TestStatisticParameterSet[] adjustTestStatisticParameters(TestStatisticParameterSet[] testStatisticParameterSet) {
        int i = 0;
        while (i < testStatisticParameterSet.length) {
            TestStatisticParameterSet parameter = testStatisticParameterSet[i];
            double n2 = parameter.getNumeratorDof();
            double m2 = parameter.getDenominatorDof();
            double alpha = this.alphaLocal;
            if (parameter.isGlobalTestStatistic() || n2 >= (double)this.numberOfIndependentHypothesis) {
                alpha = this.alphaGlobal;
            }
            parameter.setNoncentralityParameter(this.ncp);
            parameter.setProbabilityValue(alpha);
            if (Double.isInfinite(m2)) {
                quantile = TestStatistic.getQuantile(n2, alpha);
                beta = TestStatistic.getPowerOfTest(quantile, n2, this.ncp);
                logP = TestStatistic.getLogarithmicProbabilityValue(quantile, n2);
                parameter.setQuantile(quantile);
                parameter.setPowerOfTest(beta);
                parameter.setLogarithmicProbabilityValue(logP);
            } else {
                quantile = TestStatistic.getQuantile(n2, m2, alpha);
                beta = TestStatistic.getPowerOfTest(quantile, n2, m2, this.ncp);
                logP = TestStatistic.getLogarithmicProbabilityValue(quantile, n2, m2);
                parameter.setQuantile(quantile);
                parameter.setPowerOfTest(beta);
                parameter.setLogarithmicProbabilityValue(logP);
            }
            ++i;
        }
        return testStatisticParameterSet;
    }

    public static void main(String[] args) {
        int numberOfIndependentHypothesis = 100;
        SidakTestStatistic testStatistic = new SidakTestStatistic(numberOfIndependentHypothesis, 0.001, 0.8, false);
        TestStatisticParameterSet[] set = new TestStatisticParameterSet[]{new TestStatisticParameterSet(1.0, Double.POSITIVE_INFINITY), new TestStatisticParameterSet(1.0, numberOfIndependentHypothesis - 1), new TestStatisticParameterSet(2.0, Double.POSITIVE_INFINITY), new TestStatisticParameterSet(2.0, numberOfIndependentHypothesis - 2), new TestStatisticParameterSet(3.0, Double.POSITIVE_INFINITY), new TestStatisticParameterSet(3.0, numberOfIndependentHypothesis - 3), new TestStatisticParameterSet(numberOfIndependentHypothesis, Double.POSITIVE_INFINITY)};
        testStatistic.adjustTestStatisticParameters(set);
        TestStatisticParameterSet[] testStatisticParameterSetArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            TestStatisticParameterSet s = testStatisticParameterSetArray[n2];
            System.out.println(s);
            ++n2;
        }
    }
}

