/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.statistic;

import java.io.BufferedInputStream;
import java.util.Properties;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;

public class DefaultTestStatisticValue {
    private static final double PROBABILITY_VALUE = 0.001;
    private static final double POWER_OF_TEST = 0.8;
    private static final TestStatisticType TEST_STATISTIC_TYPE = TestStatisticType.BAARDA_METHOD;
    private static final Properties PROPERTIES = new Properties();

    static {
        BufferedInputStream bis = null;
        String path = "properties/teststatistic.default";
        try {
            try {
                if (DefaultTestStatisticValue.class.getClassLoader().getResourceAsStream("properties/teststatistic.default") != null) {
                    bis = new BufferedInputStream(DefaultTestStatisticValue.class.getClassLoader().getResourceAsStream("properties/teststatistic.default"));
                    PROPERTIES.load(bis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DefaultTestStatisticValue() {
    }

    public static TestStatisticType getTestStatisticType() {
        TestStatisticType value = null;
        try {
            value = TestStatisticType.valueOf(PROPERTIES.getProperty("TEST_STATISTIC_TYPE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value != null ? value : TEST_STATISTIC_TYPE;
    }

    public static double getProbabilityValue() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("PROBABILITY_VALUE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 && value < 1.0 ? value : 0.001;
    }

    public static double getPowerOfTest() {
        double value = -1.0;
        try {
            value = Double.parseDouble(PROPERTIES.getProperty("POWER_OF_TEST"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value > 0.0 && value < 1.0 ? value : 0.8;
    }
}

