/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.statistic;

import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import org.applied_geodesy.adjustment.statistic.BinomialTestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatistic;

public class BinomialTestStatisticParameters {
    public TestStatistic testStatistic;
    private SortedMap<KeySet, BinomialTestStatisticParameterSet> params = Collections.synchronizedSortedMap(new TreeMap());

    public BinomialTestStatisticParameters(TestStatistic testStatistic) {
        this.testStatistic = testStatistic;
    }

    public BinomialTestStatisticParameterSet[] getBinomialTestStatisticParameterSets() {
        BinomialTestStatisticParameterSet[] arr = new BinomialTestStatisticParameterSet[this.params.size()];
        int i = 0;
        for (BinomialTestStatisticParameterSet set : this.params.values()) {
            arr[i++] = set;
        }
        return arr;
    }

    public BinomialTestStatisticParameterSet getTestStatisticParameter(int numberOfTrials) {
        return this.getTestStatisticParameter(numberOfTrials, 0.5);
    }

    public BinomialTestStatisticParameterSet getTestStatisticParameter(int numberOfTrials, double successProbability) {
        KeySet key = new KeySet(numberOfTrials, successProbability);
        if (!this.params.containsKey(key)) {
            this.params.put(key, this.testStatistic.adjustTestStatisticParameter(new BinomialTestStatisticParameterSet(numberOfTrials, successProbability)));
        }
        return (BinomialTestStatisticParameterSet)this.params.get(key);
    }

    private class KeySet
    implements Comparable<KeySet> {
        public final int numberOfTrials;
        public final double successProbability;

        public KeySet(int numberOfTrials, double successProbability) {
            this.numberOfTrials = numberOfTrials;
            this.successProbability = successProbability;
        }

        private BinomialTestStatisticParameters getOuterType() {
            return BinomialTestStatisticParameters.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.numberOfTrials;
            long temp = Double.doubleToLongBits(this.successProbability);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeySet other = (KeySet)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.numberOfTrials != other.numberOfTrials) {
                return false;
            }
            return Double.doubleToLongBits(this.successProbability) == Double.doubleToLongBits(other.successProbability);
        }

        @Override
        public int compareTo(KeySet keySet) {
            if (this.equals(keySet)) {
                return 0;
            }
            if (this.numberOfTrials < keySet.numberOfTrials || this.numberOfTrials == keySet.numberOfTrials && this.successProbability > keySet.successProbability) {
                return -1;
            }
            if (this.numberOfTrials > keySet.numberOfTrials || this.numberOfTrials == keySet.numberOfTrials && this.successProbability < keySet.successProbability) {
                return 1;
            }
            return 0;
        }
    }
}

