/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.statistic;

public class BinomialTestStatisticParameterSet {
    private double alpha;
    private final double successProbability;
    private final int numberOfTrials;
    private double lowerTailQuantile = 0.0;
    private double upperTailQuantile;

    public BinomialTestStatisticParameterSet(int numberOfTrials, double successProbability) {
        this.numberOfTrials = numberOfTrials;
        this.successProbability = successProbability > 0.0 && successProbability < 1.0 ? successProbability : 0.5;
        this.upperTailQuantile = numberOfTrials;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getSuccessProbability() {
        return this.successProbability;
    }

    public double getProbabilityValue() {
        return this.alpha;
    }

    public void setProbabilityValue(double alpha) {
        this.alpha = alpha;
    }

    public void setLowerTailQuantile(double lowerTailQuantile) {
        this.lowerTailQuantile = lowerTailQuantile >= 0.0 && lowerTailQuantile <= (double)this.numberOfTrials ? lowerTailQuantile : 0.0;
    }

    public void setUpperTailQuantile(double upperTailQuantile) {
        this.upperTailQuantile = upperTailQuantile >= 0.0 && upperTailQuantile <= (double)this.numberOfTrials ? upperTailQuantile : 0.0;
    }

    public double getLowerTailQuantile() {
        return this.lowerTailQuantile;
    }

    public double getUpperTailQuantile() {
        return this.upperTailQuantile;
    }
}

