/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.statistic;

import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.statistic.TestStatistic;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;

public class BaardaMethodTestStatistic
extends TestStatistic {
    private final double alpha;
    private final double beta;
    private final double n1;
    private final double m1;
    private double ncp = -1.0;

    public BaardaMethodTestStatistic() {
        this(1.0, 0.1, 80.0);
    }

    public BaardaMethodTestStatistic(double n1, double alpha, double beta) {
        this(n1, Double.POSITIVE_INFINITY, alpha, beta);
    }

    public BaardaMethodTestStatistic(double n1, double m1, double alpha, double beta) {
        super(TestStatisticType.BAARDA_METHOD, alpha, beta);
        this.alpha = alpha;
        this.beta = beta;
        this.n1 = n1;
        this.m1 = m1;
        this.ncp = Double.isInfinite(this.m1) ? TestStatistic.getNoncentralityParameter(this.n1, this.alpha, this.beta) : TestStatistic.getNoncentralityParameter(this.n1, this.m1, this.alpha, this.beta);
    }

    @Override
    public TestStatisticParameterSet[] adjustTestStatisticParameters(TestStatisticParameterSet[] testStatisticParameterSet) {
        int l = testStatisticParameterSet.length;
        int i = 0;
        while (i < l) {
            TestStatisticParameterSet parameter = testStatisticParameterSet[i];
            double n2 = parameter.getNumeratorDof();
            double m2 = parameter.getDenominatorDof();
            parameter.setNoncentralityParameter(this.ncp);
            parameter.setPowerOfTest(this.beta);
            if (Double.isInfinite(m2)) {
                quantile = this.n1 == n2 && Double.isInfinite(this.m1) ? TestStatistic.getQuantile(n2, this.alpha) : TestStatistic.getQuantileViaNCP(n2, this.ncp, this.beta);
                logP = TestStatistic.getLogarithmicProbabilityValue(quantile, n2);
                double d = alpha = this.n1 == n2 && Double.isInfinite(this.m1) ? this.alpha : TestStatistic.getProbabilityValue(quantile, n2);
                alpha = alpha <= 0.0 ? Constant.EPS : (alpha >= 1.0 ? 1.0 - Math.sqrt(Constant.EPS) : alpha);
                parameter.setProbabilityValue(alpha);
                parameter.setQuantile(quantile);
                parameter.setLogarithmicProbabilityValue(logP);
            } else {
                quantile = this.n1 == n2 && this.m1 == m2 ? TestStatistic.getQuantile(n2, m2, this.alpha) : TestStatistic.getQuantileViaNCP(n2, m2, this.ncp, this.beta);
                logP = TestStatistic.getLogarithmicProbabilityValue(quantile, n2, m2);
                double d = alpha = this.n1 == n2 && this.m1 == m2 ? this.alpha : TestStatistic.getProbabilityValue(quantile, n2, m2);
                alpha = alpha <= 0.0 ? Constant.EPS : (alpha >= 1.0 ? 1.0 - Math.sqrt(Constant.EPS) : alpha);
                parameter.setProbabilityValue(alpha);
                parameter.setQuantile(quantile);
                parameter.setLogarithmicProbabilityValue(logP);
            }
            ++i;
        }
        return testStatisticParameterSet;
    }

    public static void main(String[] args) {
        int dof = 100;
        BaardaMethodTestStatistic bMeth = new BaardaMethodTestStatistic(1.0, 0.001, 0.8);
        TestStatisticParameterSet[] set = new TestStatisticParameterSet[]{new TestStatisticParameterSet(1.0, Double.POSITIVE_INFINITY), new TestStatisticParameterSet(1.0, dof - 1), new TestStatisticParameterSet(2.0, Double.POSITIVE_INFINITY), new TestStatisticParameterSet(2.0, dof - 2), new TestStatisticParameterSet(3.0, Double.POSITIVE_INFINITY), new TestStatisticParameterSet(3.0, dof - 3)};
        bMeth.adjustTestStatisticParameters(set);
        TestStatisticParameterSet[] testStatisticParameterSetArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            TestStatisticParameterSet s = testStatisticParameterSetArray[n2];
            System.out.println(s);
            ++n2;
        }
    }
}

