/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.point.group;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.applied_geodesy.adjustment.network.DefaultUncertainty;
import org.applied_geodesy.adjustment.network.point.Point;
import org.applied_geodesy.adjustment.network.point.Point1D;
import org.applied_geodesy.adjustment.network.point.Point2D;
import org.applied_geodesy.adjustment.network.point.Point3D;

public class PointGroup {
    private int id;
    private int dimension = -1;
    private Map<String, Point> pointHashMap = new LinkedHashMap<String, Point>();
    private List<Point> pointArrayList = new ArrayList<Point>();

    public PointGroup(int id) {
        this.id = id;
    }

    public final int getId() {
        return this.id;
    }

    public boolean add(Point point) {
        String name = point.getName();
        int pointDim = point.getDimension();
        if (this.dimension < 0) {
            this.dimension = pointDim;
        }
        if (this.dimension != pointDim || this.pointHashMap.containsKey(name)) {
            return false;
        }
        if (this.dimension > 1) {
            point.setStdX(point.getStdX() > 0.0 ? point.getStdX() : DefaultUncertainty.getUncertaintyX());
            point.setStdY(point.getStdY() > 0.0 ? point.getStdY() : DefaultUncertainty.getUncertaintyY());
        }
        if (this.dimension != 2) {
            point.setStdZ(point.getStdZ() > 0.0 ? point.getStdZ() : DefaultUncertainty.getUncertaintyZ());
        }
        if (this.dimension == 3) {
            point.getVerticalDeflectionX().setStd(point.getVerticalDeflectionX().getStd() > 0.0 ? point.getVerticalDeflectionX().getStd() : DefaultUncertainty.getUncertaintyDeflectionX());
            point.getVerticalDeflectionY().setStd(point.getVerticalDeflectionY().getStd() > 0.0 ? point.getVerticalDeflectionY().getStd() : DefaultUncertainty.getUncertaintyDeflectionY());
        }
        this.pointHashMap.put(name, point);
        this.pointArrayList.add(point);
        return true;
    }

    public Point get(int index) throws ArrayIndexOutOfBoundsException {
        return this.pointArrayList.get(index);
    }

    public Point get(String pointId) {
        return this.pointHashMap.get(pointId);
    }

    public int size() {
        return this.pointArrayList.size();
    }

    public int getDimension() {
        return this.dimension;
    }

    public String toString() {
        return new String(String.valueOf(this.getClass()) + " " + this.id + " Points in Group: " + this.size());
    }

    public Point getCenterPoint() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i = 0;
        while (i < this.size()) {
            if (this.getDimension() > 1) {
                x += this.get(i).getX();
                y += this.get(i).getY();
            }
            if (this.getDimension() != 2) {
                z += this.get(i).getZ();
            }
            ++i;
        }
        if (this.getDimension() == 1) {
            return new Point1D("c", z / (double)this.size());
        }
        if (this.getDimension() == 2) {
            return new Point2D("c", x / (double)this.size(), y / (double)this.size());
        }
        if (this.getDimension() == 3) {
            return new Point3D("c", x / (double)this.size(), y / (double)this.size(), z / (double)this.size());
        }
        return null;
    }
}

