/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.point;

import org.applied_geodesy.adjustment.ConfidenceRegion;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.network.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.network.parameter.VerticalDeflectionX;
import org.applied_geodesy.adjustment.network.parameter.VerticalDeflectionY;
import org.applied_geodesy.transformation.datum.SphericalDeflectionParameter;

public abstract class Point
extends UnknownParameter {
    private String name = new String();
    private int rowInJacobiMatrix = -1;
    private int colInDesignmatrixOfModelErros = -1;
    private VerticalDeflectionX verticalDeflectionX = new VerticalDeflectionX(this);
    private VerticalDeflectionY verticalDeflectionY = new VerticalDeflectionY(this);
    private SphericalDeflectionParameter sphericalDeflectionParameter = new SphericalDeflectionParameter();
    private static final double ZERO = Math.sqrt(Constant.EPS);
    protected final double[] coordinates0 = new double[3];
    private double[] coordinates = new double[3];
    private double[] redundancy = new double[this.getDimension()];
    private double[] ep = new double[this.getDimension()];
    private double[] nabla = new double[this.getDimension()];
    private double[] mdb = new double[this.getDimension()];
    private double[] mtb = new double[this.getDimension()];
    private double[] sigma = new double[this.getDimension()];
    private double[] sigma0 = new double[this.getDimension()];
    private double[] confidenceAxis = new double[this.getDimension()];
    private double[] confidenceAngles = new double[3];
    private double[] principalComponents = new double[this.getDimension()];
    private double[] confidenceEllipseAxis = new double[2];
    private double confidenceEllipseAngle = 0.0;
    private double nablaCoVarNable = 0.0;
    private double efsp = 0.0;
    private double Tprio = 0.0;
    private double Tpost = 0.0;
    private double Pprio = 0.0;
    private double Ppost = 0.0;
    private double omega = 0.0;
    private boolean significant = false;

    public Point(String name) throws IllegalArgumentException {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " Punktnummer ungueltig!");
        }
        this.name = name.trim();
        int i = 0;
        while (i < this.getDimension()) {
            this.sigma[i] = -1.0;
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getColInDesignmatrixOfModelErros() {
        return this.colInDesignmatrixOfModelErros;
    }

    public void setColInDesignmatrixOfModelErros(int col) {
        this.colInDesignmatrixOfModelErros = col;
    }

    public abstract int getDimension();

    public void setStdX(double std) {
        this.sigma0[0] = this.sigma0[0] <= 0.0 && std > 0.0 ? std : this.sigma0[0];
        this.sigma[0] = std > 0.0 ? std : -1.0;
    }

    public void setStdY(double std) {
        this.sigma0[1] = this.sigma0[1] <= 0.0 && std > 0.0 ? std : this.sigma0[1];
        this.sigma[1] = std > 0.0 ? std : -1.0;
    }

    public void setStdZ(double std) {
        this.sigma0[this.getDimension() - 1] = this.sigma0[this.getDimension() - 1] <= 0.0 && std > 0.0 ? std : this.sigma0[this.getDimension() - 1];
        this.sigma[this.getDimension() - 1] = std > 0.0 ? std : -1.0;
    }

    public double getStdX() {
        return this.sigma[0];
    }

    public double getStdY() {
        return this.sigma[1];
    }

    public double getStdZ() {
        return this.sigma[this.getDimension() - 1];
    }

    public double getStdXApriori() {
        return this.sigma0[0];
    }

    public double getStdYApriori() {
        return this.sigma0[1];
    }

    public double getStdZApriori() {
        return this.sigma0[this.getDimension() - 1];
    }

    public void setStdXApriori(double sigmaX) {
        if (sigmaX > 0.0) {
            this.sigma0[0] = sigmaX;
        }
    }

    public void setStdYApriori(double sigmaY) {
        if (sigmaY > 0.0) {
            this.sigma0[1] = sigmaY;
        }
    }

    public void setStdZApriori(double sigmaZ) {
        if (sigmaZ > 0.0) {
            this.sigma0[this.getDimension() - 1] = sigmaZ;
        }
    }

    public void setX(double x) {
        this.coordinates[0] = x;
    }

    public void setY(double y) {
        this.coordinates[1] = y;
    }

    public void setZ(double z) {
        this.coordinates[2] = z;
    }

    public double getX() {
        return this.coordinates[0];
    }

    public double getY() {
        return this.coordinates[1];
    }

    public double getZ() {
        return this.coordinates[2];
    }

    public double getX0() {
        return this.coordinates0[0];
    }

    public double getY0() {
        return this.coordinates0[1];
    }

    public double getZ0() {
        return this.coordinates0[2];
    }

    public void setX0(double x0) {
        this.coordinates0[0] = x0;
        this.setX(x0);
    }

    public void setY0(double y0) {
        this.coordinates0[1] = y0;
        this.setY(y0);
    }

    public void setZ0(double z0) {
        this.coordinates0[2] = z0;
        this.setZ(z0);
    }

    public void resetCoordinates() {
        int i = 0;
        while (i < this.coordinates0.length) {
            this.coordinates[i] = this.coordinates0[i];
            ++i;
        }
    }

    public double getDistance3D(Point p) {
        return Math.sqrt(Math.pow(this.getX() - p.getX(), 2.0) + Math.pow(this.getY() - p.getY(), 2.0) + Math.pow(this.getZ() - p.getZ(), 2.0));
    }

    public double getAprioriDistance3D(Point p) {
        return Math.sqrt(Math.pow(this.getX0() - p.getX0(), 2.0) + Math.pow(this.getY0() - p.getY0(), 2.0) + Math.pow(this.getZ0() - p.getZ0(), 2.0));
    }

    public double getDistance2D(Point p) {
        return Math.hypot(this.getX() - p.getX(), this.getY() - p.getY());
    }

    public double getAprioriDistance2D(Point p) {
        return Math.hypot(this.getX0() - p.getX0(), this.getY0() - p.getY0());
    }

    public int getRowInJacobiMatrix() {
        return this.rowInJacobiMatrix;
    }

    public void setRowInJacobiMatrix(int row) {
        this.rowInJacobiMatrix = row;
    }

    public void setInfluenceOnNetworkDistortion(double efsp) {
        this.efsp = efsp;
    }

    public double getInfluenceOnNetworkDistortion() {
        return this.efsp;
    }

    public void setNablaCoVarNabla(double ncn) {
        if (ncn >= 0.0) {
            this.nablaCoVarNable = ncn;
        }
    }

    public void calcStochasticParameters(double sigma2apost, int redundancy, boolean applyAposterioriVarianceOfUnitWeight) {
        double omega = sigma2apost * (double)redundancy;
        int dim = this.getDimension();
        double sigma2apostPoint = redundancy - dim > 0 ? (omega - this.nablaCoVarNable) / (double)(redundancy - dim) : 0.0;
        this.Tprio = this.nablaCoVarNable / (double)dim;
        this.Tpost = applyAposterioriVarianceOfUnitWeight && redundancy - dim > 0 && sigma2apostPoint > ZERO ? this.Tprio / sigma2apostPoint : 0.0;
    }

    public void setProbabilityValues(double pPrio, double pPost) {
        this.Pprio = pPrio;
        this.Ppost = pPost;
    }

    public double getTprio() {
        return this.Tprio < ZERO ? 0.0 : this.Tprio;
    }

    public double getTpost() {
        return this.Tpost < ZERO ? 0.0 : this.Tpost;
    }

    public double getPprio() {
        return this.Pprio;
    }

    public double getPpost() {
        return this.Ppost;
    }

    public void setInfluencesOnPointPosition(double[] ep) {
        if (ep.length == this.getDimension()) {
            this.ep = ep;
        }
    }

    public double getInfluenceOnPointPositionX() {
        return this.ep[0];
    }

    public double getInfluenceOnPointPositionY() {
        return this.ep[1];
    }

    public double getInfluenceOnPointPositionZ() {
        return this.ep[this.getDimension() - 1];
    }

    public void setFirstPrincipalComponents(double[] principalComponents) {
        if (principalComponents.length == this.getDimension()) {
            this.principalComponents = principalComponents;
        }
    }

    public double getFirstPrincipalComponentX() {
        return this.principalComponents[0];
    }

    public double getFirstPrincipalComponentY() {
        return this.principalComponents[1];
    }

    public double getFirstPrincipalComponentZ() {
        return this.principalComponents[this.getDimension() - 1];
    }

    public void setRedundancy(double[] redundancy) {
        if (redundancy.length == this.getDimension()) {
            this.redundancy = redundancy;
        }
    }

    public double getRedundancy() {
        double r = 0.0;
        int i = 0;
        while (i < this.redundancy.length) {
            r += this.redundancy[i];
            ++i;
        }
        return r;
    }

    public double getRedundancyX() {
        return this.redundancy[0];
    }

    public double getRedundancyY() {
        return this.redundancy[1];
    }

    public double getRedundancyZ() {
        return this.redundancy[this.getDimension() - 1];
    }

    public double getGrossErrorX() {
        return this.nabla[0];
    }

    public double getGrossErrorY() {
        return this.nabla[1];
    }

    public double getGrossErrorZ() {
        return this.nabla[this.getDimension() - 1];
    }

    public void setGrossErrors(double[] nabla) {
        if (nabla.length == this.getDimension()) {
            this.nabla = nabla;
        }
    }

    public void setMinimalDetectableBiases(double[] mdb) {
        if (mdb.length == this.getDimension()) {
            this.mdb = mdb;
        }
    }

    public double getMinimalDetectableBiasX() {
        return this.mdb[0];
    }

    public double getMinimalDetectableBiasY() {
        return this.mdb[1];
    }

    public double getMinimalDetectableBiasZ() {
        return this.mdb[this.getDimension() - 1];
    }

    public void setMaximumTolerableBiases(double[] mtb) {
        if (mtb.length == this.getDimension()) {
            this.mtb = mtb;
        }
    }

    public double getMaximumTolerableBiasX() {
        return this.mtb[0];
    }

    public double getMaximumTolerableBiasY() {
        return this.mtb[1];
    }

    public double getMaximumTolerableBiasZ() {
        return this.mtb[this.getDimension() - 1];
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public double getOmega() {
        return this.omega;
    }

    public double getConfidenceAxis(int i) {
        return this.confidenceAxis[i];
    }

    public double getConfidenceAngle(int i) {
        return this.confidenceAngles[i];
    }

    public double getConfidenceEllipseAxis(int i) {
        return this.confidenceEllipseAxis[i];
    }

    public double getConfidenceEllipseAngle() {
        return this.confidenceEllipseAngle;
    }

    public void setConfidenceRegion(ConfidenceRegion confidence) {
        int i = 0;
        while (i < this.getDimension()) {
            this.confidenceAxis[i] = confidence.getConfidenceRegionAxis(i);
            if (this.getDimension() == 1 && i == 0 || this.getDimension() > 1 && i < 2) {
                this.confidenceEllipseAxis[i] = confidence.getConfidenceEllipseAxis(i);
            }
            ++i;
        }
        if (this.getDimension() > 1) {
            this.confidenceEllipseAngle = confidence.getConfidenceEllipseAngle();
            this.confidenceAngles = confidence.getEulerAngles();
        }
    }

    public void setSignificant(boolean significant) {
        this.significant = significant;
    }

    public boolean isSignificant() {
        return this.significant;
    }

    public VerticalDeflectionX getVerticalDeflectionX() {
        return this.verticalDeflectionX;
    }

    public VerticalDeflectionY getVerticalDeflectionY() {
        return this.verticalDeflectionY;
    }

    public boolean hasUnknownDeflectionParameters() {
        return this.getDimension() != 2 && this.verticalDeflectionX.getColInJacobiMatrix() >= 0 && this.verticalDeflectionY.getColInJacobiMatrix() >= 0;
    }

    public boolean hasObservedDeflectionParameters() {
        return this.getDimension() != 2 && this.verticalDeflectionX.getRowInJacobiMatrix() >= 0 && this.verticalDeflectionY.getRowInJacobiMatrix() >= 0;
    }

    public SphericalDeflectionParameter getSphericalDeflectionParameter() {
        return this.sphericalDeflectionParameter;
    }
}

