/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.parameter;

import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.adjustment.network.parameter.VerticalDeflection;
import org.applied_geodesy.adjustment.network.point.Point;

public class VerticalDeflectionX
extends VerticalDeflection {
    private boolean significant = false;
    private static final double ZERO = Math.sqrt(Constant.EPS);
    private double nablaCoVarNable = 0.0;
    private double tPrio = 0.0;
    private double tPost = 0.0;
    private double pPrio = 0.0;
    private double pPost = 0.0;

    public VerticalDeflectionX(Point point) {
        super(point);
    }

    public VerticalDeflectionX(Point point, double value) {
        super(point, value);
    }

    public VerticalDeflectionX(Point point, double value, double std) {
        super(point, value, std);
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.VERTICAL_DEFLECTION_X;
    }

    public void setSignificant(boolean significant) {
        this.significant = significant;
    }

    public boolean isSignificant() {
        return this.significant;
    }

    public void setNablaCoVarNabla(double ncn) {
        if (ncn >= 0.0) {
            this.nablaCoVarNable = ncn;
        }
    }

    public void setPprio(double p) {
        this.pPrio = p;
    }

    public void setPpost(double p) {
        this.pPost = p;
    }

    public double getTprio() {
        return this.tPrio;
    }

    public double getTpost() {
        return this.tPost;
    }

    public double getPprio() {
        return this.pPrio;
    }

    public double getPpost() {
        return this.pPost;
    }

    public void calcStochasticParameters(double sigma2apost, int redundancy, boolean applyAposterioriVarianceOfUnitWeight) {
        int dim = 2;
        double omega = sigma2apost * (double)redundancy;
        double sigma2apostDeflection = redundancy - 2 > 0 ? (omega - this.nablaCoVarNable) / (double)(redundancy - 2) : 0.0;
        this.tPrio = this.nablaCoVarNable / 2.0;
        this.tPost = applyAposterioriVarianceOfUnitWeight && redundancy - 2 > 0 && sigma2apostDeflection > ZERO ? this.tPrio / sigma2apostDeflection : 0.0;
    }

    @Override
    public String toString() {
        return "VerticalDeflectionX [point=" + String.valueOf(this.getPoint()) + ", value0=" + this.getValue0() + ", value=" + this.getValue() + "]";
    }
}

