/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.parameter;

import org.applied_geodesy.adjustment.network.observation.group.ObservationGroup;
import org.applied_geodesy.adjustment.network.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.network.point.Point;

public abstract class VerticalDeflection
extends UnknownParameter {
    private final Point point;
    private int rowInJacobiMatrix = -1;
    private double redundancy = 0.0;
    private double sigma0 = -1.0;
    private double sigma = 0.0;
    private double omega = 0.0;
    private double value0;
    private double value;
    private double nabla;
    private double mdb;
    private double mtb;
    private double confidence;

    public VerticalDeflection(Point point) {
        this(point, 0.0);
    }

    public VerticalDeflection(Point point, double value) {
        this.point = point;
        this.setValue0(value);
    }

    public VerticalDeflection(Point point, double value, double std) {
        this.setValue0(value);
        this.point = point;
        this.setStd(std);
    }

    public final Point getPoint() {
        return this.point;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue0(double value0) {
        this.value0 = value0;
        this.setValue(value0);
    }

    public double getValue0() {
        return this.value0;
    }

    public void reset() {
        this.setValue(this.value0);
    }

    @Override
    public ObservationGroup getObservations() {
        return this.point.getObservations();
    }

    public void setStd(double std) {
        this.sigma0 = this.sigma0 <= 0.0 && std > 0.0 ? std : this.sigma0;
        this.sigma = std > 0.0 ? std : this.sigma;
    }

    public double getStd() {
        return this.sigma;
    }

    public double getStdApriori() {
        return this.sigma0;
    }

    public void setStdApriori(double std) {
        if (std > 0.0) {
            this.sigma0 = std;
        }
    }

    public int getRowInJacobiMatrix() {
        return this.rowInJacobiMatrix;
    }

    public void setRowInJacobiMatrix(int row) {
        this.rowInJacobiMatrix = row;
    }

    public double getRedundancy() {
        return this.redundancy;
    }

    public void setRedundancy(double redundancy) {
        this.redundancy = redundancy;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public double getOmega() {
        return this.omega;
    }

    public double getGrossError() {
        return this.nabla;
    }

    public void setGrossError(double nabla) {
        this.nabla = nabla;
    }

    public double getMinimalDetectableBias() {
        return this.mdb;
    }

    public void setMinimalDetectableBias(double mdb) {
        this.mdb = mdb;
    }

    public double getMaximumTolerableBias() {
        return this.mtb;
    }

    public void setMaximumTolerableBias(double mtb) {
        this.mtb = mtb;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public String toString() {
        return "VerticalDeflection [point=" + String.valueOf(this.point) + ", value0=" + this.value0 + ", value=" + this.value + "]";
    }
}

