/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.parameter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.adjustment.network.parameter.UnknownParameter;

public class UnknownParameters
implements Iterable<UnknownParameter> {
    private int col = 0;
    private int lastPointColumn = -1;
    private int lastParamColumn = -1;
    private int leastParamColumn = -1;
    private List<UnknownParameter> parameters = new ArrayList<UnknownParameter>();

    public void resortParameters() {
        if (this.leastParamColumn < this.lastPointColumn && this.leastParamColumn >= 0) {
            ArrayList<UnknownParameter> sortedParameters = new ArrayList<UnknownParameter>(this.parameters.size());
            ArrayList<UnknownParameter> nonPointParameters = new ArrayList<UnknownParameter>();
            this.col = 0;
            this.leastParamColumn = -1;
            this.lastParamColumn = -1;
            this.lastPointColumn = -1;
            for (UnknownParameter parameter : this.parameters) {
                switch (parameter.getParameterType()) {
                    case POINT1D: 
                    case POINT2D: 
                    case POINT3D: {
                        parameter.setColInJacobiMatrix(this.col);
                        this.increaseColumnCount(parameter.getParameterType());
                        sortedParameters.add(parameter);
                        break;
                    }
                    default: {
                        nonPointParameters.add(parameter);
                    }
                }
            }
            for (UnknownParameter parameter : nonPointParameters) {
                parameter.setColInJacobiMatrix(this.col);
                this.increaseColumnCount(parameter.getParameterType());
                sortedParameters.add(parameter);
            }
            this.parameters = sortedParameters;
        }
    }

    public boolean add(UnknownParameter parameter) {
        if (!this.parameters.contains(parameter)) {
            parameter.setColInJacobiMatrix(this.col);
            this.increaseColumnCount(parameter.getParameterType());
            return this.parameters.add(parameter);
        }
        return false;
    }

    public int columnsOfAddionalParameters() {
        return this.lastParamColumn <= 0 ? 0 : this.lastParamColumn - this.lastPointColumn;
    }

    public int columnsOfPoints() {
        return this.lastPointColumn;
    }

    public int columnsInJacobi() {
        return this.col;
    }

    public boolean contains(Object obj) {
        return this.parameters.contains(obj);
    }

    private void increaseColumnCount(ParameterType type) {
        switch (type) {
            case POINT1D: {
                ++this.col;
                this.lastPointColumn = this.col;
                break;
            }
            case POINT2D: {
                this.col += 2;
                this.lastPointColumn = this.col;
                break;
            }
            case POINT3D: {
                this.col += 3;
                this.lastPointColumn = this.col;
                break;
            }
            default: {
                ++this.col;
                this.lastParamColumn = this.col;
                if (this.leastParamColumn >= 0) break;
                this.leastParamColumn = this.col;
            }
        }
    }

    public UnknownParameter get(int i) {
        return this.parameters.get(i);
    }

    public int size() {
        return this.parameters.size();
    }

    @Override
    public Iterator<UnknownParameter> iterator() {
        return this.parameters.iterator();
    }
}

