/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.parameter;

import java.util.Arrays;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.network.DefaultAverageThreshold;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.adjustment.network.observation.Direction;
import org.applied_geodesy.adjustment.network.observation.FaceType;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.parameter.AdditionalUnknownParameter;

public class Orientation
extends AdditionalUnknownParameter {
    private boolean estimateApproximationValue = true;

    public Orientation() {
        this(0.0, true);
    }

    public Orientation(boolean estimateApproximationValue) {
        this(0.0, estimateApproximationValue);
    }

    public Orientation(double ori, boolean estimateApproximationValue) {
        super(ori);
        this.estimateApproximationValue = estimateApproximationValue;
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.ORIENTATION;
    }

    @Override
    public void setColInJacobiMatrix(int col) {
        super.setColInJacobiMatrix(col);
        this.checkFace();
    }

    private void checkFace() {
        if (this.getObservations().size() <= 0 || !(this.getObservations().get(0) instanceof Direction)) {
            return;
        }
        double deltaOri = 0.0;
        if (this.isEnable() && this.estimateApproximationValue) {
            deltaOri = this.advancedOrientation();
        }
        int length = this.getObservations().size();
        int i = 0;
        while (i < length) {
            double face2;
            Direction dir = (Direction)this.getObservations().get(i);
            double azimuthMeasuredFace1 = deltaOri + dir.getValueApriori();
            double azimuthCalculated = dir.getValueAposteriori();
            azimuthMeasuredFace1 = MathExtension.MOD(azimuthMeasuredFace1, Math.PI * 2);
            double azimuthMeasuredFace2 = MathExtension.MOD(azimuthMeasuredFace1 + Math.PI, Math.PI * 2);
            double face1 = Math.min(Math.abs(azimuthCalculated - azimuthMeasuredFace1), Math.abs(Math.abs(azimuthCalculated - azimuthMeasuredFace1) - Math.PI * 2));
            if (face1 > (face2 = Math.min(Math.abs(azimuthCalculated - azimuthMeasuredFace2), Math.abs(Math.abs(azimuthCalculated - azimuthMeasuredFace2) - Math.PI * 2)))) {
                dir.setValueApriori(MathExtension.MOD(dir.getValueApriori() + Math.PI, Math.PI * 2));
                dir.setFace(dir.getFace() == FaceType.ONE ? FaceType.TWO : FaceType.ONE);
            }
            ++i;
        }
        if (this.isEnable() && this.estimateApproximationValue) {
            this.setValue(MathExtension.MOD(this.getValue() + this.advancedOrientation(), Math.PI * 2));
        }
    }

    private double advancedOrientation() {
        int length = this.getObservations().size();
        if (!(this.getObservations().get(0) instanceof Direction) || length == 0) {
            return 0.0;
        }
        double[] orientations = new double[length];
        int i = 0;
        while (i < length) {
            Observation observation = this.getObservations().get(i);
            double orientation = observation.getValueAposteriori() - observation.getValueApriori();
            orientations[i] = MathExtension.MOD(orientation, Math.PI * 2);
            ++i;
        }
        Arrays.sort(orientations);
        double medianOrientation = orientations[(length - 1) / 2];
        double averageOrientation = 0.0;
        double maxUncertainty = Double.MIN_VALUE;
        orientations = new double[length];
        int i2 = 0;
        while (i2 < length) {
            Observation observation = this.getObservations().get(i2);
            double orientation = observation.getValueAposteriori() - observation.getValueApriori();
            maxUncertainty = Math.max(observation.getStdApriori(), maxUncertainty);
            if (Math.abs(Math.PI * 2 - Math.abs(medianOrientation - (orientation = MathExtension.MOD(orientation, Math.PI * 2)))) < Math.abs(medianOrientation - orientation)) {
                orientation = orientation < medianOrientation ? (orientation += Math.PI * 2) : (orientation -= Math.PI * 2);
            }
            orientations[i2] = orientation;
            averageOrientation += orientation;
            ++i2;
        }
        Arrays.sort(orientations);
        medianOrientation = orientations[(length - 1) / 2];
        averageOrientation /= (double)length;
        maxUncertainty = Math.max(DefaultAverageThreshold.getThresholdDirection(), 100.0 * maxUncertainty);
        if (Math.abs(averageOrientation - medianOrientation) < maxUncertainty) {
            return averageOrientation;
        }
        averageOrientation = 0.0;
        int count = 0;
        int i3 = 0;
        while (i3 < length) {
            if (Math.abs(orientations[i3] - medianOrientation) < maxUncertainty) {
                averageOrientation += orientations[i3];
                ++count;
            }
            ++i3;
        }
        if (count > 0) {
            return averageOrientation / (double)count;
        }
        return medianOrientation;
    }

    @Override
    public double getExpectationValue() {
        return 0.0;
    }

    public void setEstimateApproximationValue(boolean estimateApproximationValue) {
        this.estimateApproximationValue = estimateApproximationValue;
    }
}

