/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.adjustment.network.observation.reduction;

import java.util.HashSet;
import java.util.Set;
import org.applied_geodesy.adjustment.network.observation.reduction.ProjectionType;
import org.applied_geodesy.adjustment.network.observation.reduction.ReductionTaskType;
import org.applied_geodesy.transformation.datum.Ellipsoid;
import org.applied_geodesy.transformation.datum.PrincipalPoint;

public class Reduction {
    private ProjectionType projectionType = ProjectionType.LOCAL_CARTESIAN;
    private PrincipalPoint principalPoint = new PrincipalPoint();
    private Ellipsoid ellipsoid = Ellipsoid.SPHERE;
    private Set<ReductionTaskType> reductionTypes = new HashSet<ReductionTaskType>(ReductionTaskType.values().length);

    public double getEarthRadius() {
        return this.ellipsoid.getRadiusOfConformalSphere(this.principalPoint.getLatitude());
    }

    public PrincipalPoint getPrincipalPoint() {
        return this.principalPoint;
    }

    public void setEllipsoid(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public void clear() {
        this.reductionTypes.clear();
    }

    public boolean applyReductionTask(ReductionTaskType type) {
        return this.reductionTypes.contains((Object)type);
    }

    public boolean addReductionTaskType(ReductionTaskType type) {
        if (type != null) {
            return this.reductionTypes.add(type);
        }
        return false;
    }

    public boolean removeReductionTaskType(ReductionTaskType type) {
        return this.reductionTypes.remove((Object)type);
    }

    public void setProjectionType(ProjectionType projectionType) {
        this.projectionType = projectionType;
    }

    public ProjectionType getProjectionType() {
        return this.projectionType;
    }

    public int size() {
        return this.reductionTypes.size();
    }
}

